/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingutils.binding.Property;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.util.layout.LayoutUtils;
import org.eclipse.buildship.ui.util.widget.UiBuilder;
import org.eclipse.buildship.ui.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.wizard.project.AbstractWizardPage;
import org.eclipse.buildship.ui.wizard.project.ProjectWizardMessages;
import org.eclipse.buildship.ui.wizard.project.WorkingSetChangedListener;
import org.eclipse.buildship.ui.wizard.project.WorkingSetConfigurationWidget;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkingSet;

public final class GradleProjectWizardPage
extends AbstractWizardPage {
    private Text projectDirText;
    private WorkingSetConfigurationWidget workingSetConfigurationWidget;

    public GradleProjectWizardPage(ProjectImportConfiguration configuration) {
        super("GradleProject", ProjectWizardMessages.Title_GradleProjectWizardPage, ProjectWizardMessages.InfoMessage_GradleProjectWizardPageDefault, configuration, (List<Property<?>>)ImmutableList.of((Object)configuration.getProjectDir(), (Object)configuration.getWorkingSets()));
    }

    @Override
    protected void createWidgets(Composite root) {
        root.setLayout((Layout)LayoutUtils.newGridLayout(3));
        this.createContent(root);
        this.bindToConfiguration();
    }

    private void createContent(Composite root) {
        UiBuilder.UiBuilderFactory uiBuilderFactory = this.getUiBuilderFactory();
        Composite projectDirectoryComposite = new Composite(root, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).extendedMargins(0, 0, 0, 10).applyTo(projectDirectoryComposite);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(3, -1).applyTo((Control)projectDirectoryComposite);
        uiBuilderFactory.newLabel(projectDirectoryComposite).alignLeft().text(ProjectWizardMessages.Label_ProjectRootDirectory).control();
        File projectDir = (File)this.getConfiguration().getProjectDir().getValue();
        String projectDirValue = (String)FileUtils.getAbsolutePath((File)projectDir).orNull();
        this.projectDirText = uiBuilderFactory.newText(projectDirectoryComposite).alignFillHorizontal().text(projectDirValue).control();
        Button projectDirBrowseButton = uiBuilderFactory.newButton(projectDirectoryComposite).alignLeft().text(UiMessages.Button_Label_Browse).control();
        projectDirBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(root.getShell(), (Widget)this.projectDirText, ProjectWizardMessages.Label_ProjectRootDirectory));
        Group workingSetGroup = uiBuilderFactory.newGroup(root).text(ProjectWizardMessages.Group_Label_WorkingSets).control();
        GridLayoutFactory.swtDefaults().applyTo((Composite)workingSetGroup);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(3, -1).applyTo((Control)workingSetGroup);
        this.workingSetConfigurationWidget = new WorkingSetConfigurationWidget(new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"}, UiPlugin.getInstance().getDialogSettings());
        this.workingSetConfigurationWidget.createContent((Composite)workingSetGroup);
        this.workingSetConfigurationWidget.modifyCurrentWorkingSetItem(WorkingSetUtils.toWorkingSets((List)this.getConfiguration().getWorkingSets().getValue()));
        this.workingSetConfigurationWidget.getWorkingSetsEnabledButton().setSelection(((Boolean)this.getConfiguration().getApplyWorkingSets().getValue()).booleanValue());
        this.workingSetConfigurationWidget.getWorkingSetsCombo().setEnabled(((Boolean)this.getConfiguration().getApplyWorkingSets().getValue()).booleanValue());
        this.workingSetConfigurationWidget.getWorkingSetsSelectButton().setEnabled(((Boolean)this.getConfiguration().getApplyWorkingSets().getValue()).booleanValue());
    }

    private void bindToConfiguration() {
        this.projectDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                File projectDir = (File)FileUtils.getAbsoluteFile((String)GradleProjectWizardPage.this.projectDirText.getText()).orNull();
                GradleProjectWizardPage.this.getConfiguration().setProjectDir(projectDir);
            }
        });
        this.workingSetConfigurationWidget.addWorkingSetChangeListener(new WorkingSetChangedListener(){

            @Override
            public void workingSetsChanged(List<IWorkingSet> workingSets) {
                List<String> workingSetNames = WorkingSetUtils.toWorkingSetNames(workingSets);
                GradleProjectWizardPage.this.getConfiguration().setWorkingSets(workingSetNames);
            }
        });
        this.workingSetConfigurationWidget.getWorkingSetsEnabledButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = GradleProjectWizardPage.this.workingSetConfigurationWidget.getWorkingSetsEnabledButton().getSelection();
                GradleProjectWizardPage.this.getConfiguration().setApplyWorkingSets(Boolean.valueOf(selected));
            }
        });
    }

    @Override
    protected String getPageContextInformation() {
        return ProjectWizardMessages.InfoMessage_GradleProjectWizardPageContext;
    }
}

