/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class TaskViewActionStateRules {
    private TaskViewActionStateRules() {
    }

    public static boolean taskScopedTaskExecutionActionsVisibleFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return nodeSelection.hasAllNodesOfType(TaskNode.class);
    }

    public static boolean taskScopedTaskExecutionActionsEnabledFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return (nodeSelection.hasAllNodesOfType(ProjectTaskNode.class) || nodeSelection.hasAllNodesOfType(TaskSelectorNode.class) && TaskViewActionStateRules.gradleCanFindTheRootProject(nodeSelection)) && TaskViewActionStateRules.taskNodesBelongToSameParentProjectNode(nodeSelection);
    }

    private static boolean gradleCanFindTheRootProject(NodeSelection nodeSelection) {
        return nodeSelection.allMatch(new Predicate<Object>(){

            public boolean apply(Object input) {
                TaskNode node = (TaskNode)input;
                OmniEclipseProject project = node.getParentProjectNode().getEclipseProject();
                Path projectPath = new Path(project.getProjectDirectory().getPath());
                IPath masterPath = projectPath.removeLastSegments(1).append("master");
                Path rootPath = new Path(project.getRoot().getProjectDirectory().getPath());
                return rootPath.isPrefixOf((IPath)projectPath) || rootPath.equals((Object)masterPath);
            }
        });
    }

    private static boolean taskNodesBelongToSameParentProjectNode(NodeSelection nodeSelection) {
        Preconditions.checkArgument((!nodeSelection.isEmpty() ? 1 : 0) != 0);
        final TaskNode firstNode = (TaskNode)nodeSelection.getFirstElement();
        return nodeSelection.allMatch(new Predicate<Object>(){

            public boolean apply(Object input) {
                return ((TaskNode)input).getParentProjectNode() == firstNode.getParentProjectNode();
            }
        });
    }

    public static boolean projectScopedTaskExecutionActionsVisibleFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return nodeSelection.hasAllNodesOfType(ProjectNode.class);
    }

    public static boolean projectScopedTaskExecutionActionsEnabledFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return nodeSelection.hasAllNodesOfType(ProjectNode.class) && nodeSelection.isSingleSelection();
    }
}

