/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import org.eclipse.core.resources.IProject;

public final class ProjectNode {
    private final ProjectNode parentProjectNode;
    private final OmniEclipseProject eclipseProject;
    private final OmniGradleProject gradleProject;
    private final Optional<IProject> workspaceProject;

    public ProjectNode(ProjectNode parentProjectNode, OmniEclipseProject eclipseProject, OmniGradleProject gradleProject, Optional<IProject> workspaceProject) {
        this.parentProjectNode = parentProjectNode;
        this.eclipseProject = (OmniEclipseProject)Preconditions.checkNotNull((Object)eclipseProject);
        this.gradleProject = (OmniGradleProject)Preconditions.checkNotNull((Object)gradleProject);
        this.workspaceProject = workspaceProject;
    }

    public ProjectNode getRootProjectNode() {
        ProjectNode root = this;
        while (root.getParentProjectNode() != null) {
            root = root.getParentProjectNode();
        }
        return root;
    }

    public ProjectNode getParentProjectNode() {
        return this.parentProjectNode;
    }

    public OmniEclipseProject getEclipseProject() {
        return this.eclipseProject;
    }

    public OmniGradleProject getGradleProject() {
        return this.gradleProject;
    }

    public Optional<IProject> getWorkspaceProject() {
        return this.workspaceProject;
    }

    public String toString() {
        return this.gradleProject.getName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProjectNode that = (ProjectNode)other;
        return Objects.equal((Object)this.parentProjectNode, (Object)that.parentProjectNode) && Objects.equal((Object)this.eclipseProject, (Object)that.eclipseProject) && Objects.equal((Object)this.gradleProject, (Object)that.gradleProject) && Objects.equal(this.workspaceProject, that.workspaceProject);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parentProjectNode, this.eclipseProject, this.gradleProject, this.workspaceProject});
    }
}

