/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.gradleware.tooling.toolingclient.CompositeBuildModelRequest;
import com.gradleware.tooling.toolingclient.CompositeBuildRequest;
import com.gradleware.tooling.toolingclient.Consumer;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseWorkspace;
import com.gradleware.tooling.toolingmodel.repository.CompositeBuildModelRepository;
import com.gradleware.tooling.toolingmodel.repository.EclipseWorkspaceUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseConverter;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseModelRepository;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseWorkspace;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.util.GradleVersion;

public class DefaultCompositeModelRepository
extends BaseModelRepository
implements CompositeBuildModelRepository {
    private final ImmutableSet<FixedRequestAttributes> requestAttributes;

    public DefaultCompositeModelRepository(Set<FixedRequestAttributes> requestAttributes, ToolingClient toolingClient, EventBus eventBus) {
        super(toolingClient, eventBus);
        this.requestAttributes = ImmutableSet.copyOf(requestAttributes);
    }

    @Override
    public OmniEclipseWorkspace fetchEclipseWorkspace(TransientRequestAttributes transientAttributes, FetchStrategy fetchStrategy) {
        if (this.requestAttributes.isEmpty()) {
            return DefaultOmniEclipseWorkspace.from(Collections.<OmniEclipseProject>emptyList());
        }
        final OmniBuildEnvironments buildEnvironments = this.fetchBuildEnvironments(transientAttributes, fetchStrategy);
        CompositeBuildModelRequest<EclipseProject> modelRequest = this.createModelRequest((Class)EclipseProject.class, (Set<FixedRequestAttributes>)this.requestAttributes, transientAttributes);
        Consumer<OmniEclipseWorkspace> successHandler = new Consumer<OmniEclipseWorkspace>(){

            public void accept(OmniEclipseWorkspace result) {
                DefaultCompositeModelRepository.this.postEvent(new EclipseWorkspaceUpdateEvent(result));
            }
        };
        BaseConverter<Set<EclipseProject>, OmniEclipseWorkspace> converter = new BaseConverter<Set<EclipseProject>, OmniEclipseWorkspace>(){

            @Override
            public OmniEclipseWorkspace apply(Set<EclipseProject> eclipseProjects) {
                ImmutableList omniEclipseProjects = FluentIterable.from(eclipseProjects).transform((Function)new Function<EclipseProject, OmniEclipseProject>(){

                    public OmniEclipseProject apply(EclipseProject eclipseProject) {
                        boolean isPublicFixRequired = DefaultCompositeModelRepository.this.isPublicFixRequired(buildEnvironments, eclipseProject);
                        return DefaultOmniEclipseProject.from(eclipseProject, isPublicFixRequired);
                    }
                }).toList();
                return DefaultOmniEclipseWorkspace.from((List<OmniEclipseProject>)omniEclipseProjects);
            }
        };
        return this.executeRequest(modelRequest, successHandler, fetchStrategy, OmniEclipseWorkspace.class, converter);
    }

    private OmniBuildEnvironments fetchBuildEnvironments(TransientRequestAttributes transientAttributes, FetchStrategy fetchStrategy) {
        CompositeBuildModelRequest<BuildEnvironment> modelRequest = this.createModelRequest((Class)BuildEnvironment.class, (Set<FixedRequestAttributes>)this.requestAttributes, transientAttributes);
        Consumer<OmniBuildEnvironments> newCacheEntryHandler = new Consumer<OmniBuildEnvironments>(){

            public void accept(OmniBuildEnvironments input) {
            }
        };
        BaseConverter<Set<BuildEnvironment>, OmniBuildEnvironments> resultConverter = new BaseConverter<Set<BuildEnvironment>, OmniBuildEnvironments>(){

            @Override
            public OmniBuildEnvironments apply(Set<BuildEnvironment> input) {
                return OmniBuildEnvironments.from(input);
            }
        };
        return this.executeRequest(modelRequest, newCacheEntryHandler, fetchStrategy, OmniBuildEnvironments.class, resultConverter);
    }

    private <T> CompositeBuildModelRequest<T> createModelRequest(Class<T> model, Set<FixedRequestAttributes> fixedAttributes, TransientRequestAttributes transientAttributes) {
        CompositeBuildModelRequest request = this.getToolingClient().newCompositeModelRequest(model);
        for (FixedRequestAttributes fixedRequestAttribute : fixedAttributes) {
            fixedRequestAttribute.apply((CompositeBuildRequest<?>)request);
        }
        transientAttributes.apply((Request<?>)request);
        return request;
    }

    boolean isPublicFixRequired(OmniBuildEnvironments buildEnvironments, EclipseProject eclipseProject) {
        OmniBuildEnvironment buildEnvironment = buildEnvironments.get(eclipseProject.getGradleProject().getProjectIdentifier().getBuildIdentifier());
        return this.targetGradleVersionIsBetween("2.1", "2.2.1", buildEnvironment);
    }

    private boolean targetGradleVersionIsBetween(String minVersion, String maxVersion, OmniBuildEnvironment buildEnvironment) {
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)minVersion)) >= 0 && gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)maxVersion)) <= 0;
    }

    private static class OmniBuildEnvironments {
        private final Map<BuildIdentifier, OmniBuildEnvironment> environmentsByBuild;

        public static OmniBuildEnvironments from(Set<BuildEnvironment> environments) {
            HashMap environmentsByBuild = Maps.newHashMap();
            for (BuildEnvironment buildEnvironment : environments) {
                environmentsByBuild.put(buildEnvironment.getBuildIdentifier(), DefaultOmniBuildEnvironment.from(buildEnvironment));
            }
            return new OmniBuildEnvironments(environmentsByBuild);
        }

        private OmniBuildEnvironments(Map<BuildIdentifier, OmniBuildEnvironment> environmentsByBuild) {
            this.environmentsByBuild = environmentsByBuild;
        }

        public OmniBuildEnvironment get(BuildIdentifier build) {
            return this.environmentsByBuild.get(build);
        }
    }
}

