/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ChainedJob;
import org.eclipse.wst.server.core.internal.Messages;

public class PublishServerJob
extends ChainedJob {
    protected int kind;
    protected boolean check;
    protected List<IModule[]> modules;
    protected IAdaptable info;

    public PublishServerJob(IServer server, int kind, IAdaptable info) {
        this(server, kind, null, info);
    }

    public PublishServerJob(IServer server, int kind, List<IModule[]> modules, IAdaptable info) {
        super(NLS.bind((String)Messages.publishing, (Object)server.getName()), server);
        this.kind = kind;
        this.modules = modules;
        this.info = info;
    }

    public PublishServerJob(IServer server, int kind, boolean check) {
        this(server, kind, null, null);
        this.check = check;
    }

    public PublishServerJob(IServer server) {
        this(server, 1, true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.check && !ServerCore.isAutoPublishing()) {
            return Status.OK_STATUS;
        }
        final IStatus[] status = new IStatus[1];
        this.getServer().publish(this.kind, this.modules, this.info, new IServer.IOperationListener(){

            @Override
            public void done(IStatus result) {
                status[0] = result;
            }
        });
        while (status[0] == null & !monitor.isCanceled()) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        if (status[0] != null) {
            return status[0];
        }
        return Status.CANCEL_STATUS;
    }
}

