/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util.bidi;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class BidiUIUtils {
    public static final char LRE = '\u202a';
    public static final char RLE = '\u202b';
    public static final char PDF = '\u202c';
    private static int OS_STYLE_INDEX = 0;
    private static int WS_EX_LAYOUTRTL = 0;
    private static int WS_EX_NOINHERITLAYOUT = 0;
    private static Class osWinClass = null;
    private static Method GET_WINDOW_LONG = null;
    private static Method SET_WINDOW_LONG = null;
    private static Method INVALIDATE_RECT = null;
    private static Field STYLE_FIELD = null;
    private static Field HANDLE = null;
    private TextLayout layout;
    private boolean isInitialized = false;
    public static final BidiUIUtils INSTANCE = new BidiUIUtils();

    private BidiUIUtils() {
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        try {
            osWinClass = Class.forName("org.eclipse.swt.internal.win32.OS");
            if (osWinClass != null) {
                GET_WINDOW_LONG = osWinClass.getMethod("GetWindowLong", Integer.TYPE, Integer.TYPE);
                SET_WINDOW_LONG = osWinClass.getMethod("SetWindowLongW", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                INVALIDATE_RECT = osWinClass.getMethod("InvalidateRect", Integer.TYPE, Class.forName("org.eclipse.swt.internal.win32.RECT"), Boolean.TYPE);
                Field field = osWinClass.getField("GWL_EXSTYLE");
                OS_STYLE_INDEX = field.getInt(null);
                field = osWinClass.getField("WS_EX_LAYOUTRTL");
                WS_EX_LAYOUTRTL = field.getInt(null);
                field = osWinClass.getField("WS_EX_NOINHERITLAYOUT");
                WS_EX_NOINHERITLAYOUT = field.getInt(null);
                STYLE_FIELD = Widget.class.getDeclaredField("style");
                STYLE_FIELD.setAccessible(true);
                HANDLE = Control.class.getDeclaredField("handle");
                HANDLE.setAccessible(true);
            }
        }
        catch (ClassNotFoundException e) {
            osWinClass = null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            osWinClass = null;
            ExceptionHandler.handle(e, true);
        }
    }

    public void applyOrientation(Control control, boolean mirrored) {
        Control[] children;
        if (control == null) {
            return;
        }
        if (!this.isInitialized) {
            this.init();
        }
        if (osWinClass == null) {
            return;
        }
        int swtStyle = control.getStyle() & 0xF1FFFFFF;
        try {
            int osStyle = (Integer)GET_WINDOW_LONG.invoke(null, this.getControHandle(control), OS_STYLE_INDEX);
            if (mirrored) {
                SET_WINDOW_LONG.invoke(null, this.getControHandle(control), OS_STYLE_INDEX, osStyle | WS_EX_LAYOUTRTL | WS_EX_NOINHERITLAYOUT);
                STYLE_FIELD.setInt(control, swtStyle |= 0xC000000);
            } else {
                SET_WINDOW_LONG.invoke(null, this.getControHandle(control), OS_STYLE_INDEX, osStyle & ~WS_EX_LAYOUTRTL);
                STYLE_FIELD.setInt(control, swtStyle |= 0x2000000);
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = this.getControHandle(control);
            objectArray[2] = Boolean.TRUE;
            INVALIDATE_RECT.invoke(null, objectArray);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            ExceptionHandler.handle(e, true);
        }
        if (control instanceof Composite && (children = ((Composite)control).getChildren()) != null) {
            int i = children.length;
            while (i-- > 0) {
                this.applyOrientation(children[i], mirrored);
            }
        }
    }

    public boolean isDirectionRTL(Object model) {
        return model instanceof DesignElementHandle && ((DesignElementHandle)model).isDirectionRTL();
    }

    public boolean isMirrored(Control control) {
        return control != null && (control.getStyle() & 0x4000000) != 0;
    }

    private int getControHandle(Control control) {
        if (HANDLE != null) {
            try {
                return HANDLE.getInt(control);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public synchronized TextLayout getTextLayout(int orientation) {
        if (this.layout == null || this.layout.isDisposed()) {
            this.layout = new TextLayout((Device)Display.getDefault());
        }
        this.layout.setOrientation(orientation);
        return this.layout;
    }

    protected void finalize() throws Throwable {
        System.out.println("layout finalized");
        if (this.layout != null && !this.layout.isDisposed()) {
            this.layout.dispose();
        }
        this.layout = null;
        super.finalize();
    }
}

