/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButtonProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionButtonProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.elements.interfaces.IDesignElementModel;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PropertyBindingPage
extends AbstractDescriptionPropertyPage {
    private IDesignElementModel ds;
    private List propList = new ArrayList();
    private List bindingValue = new ArrayList();
    private List nameLabelList = new ArrayList();
    private List<Text> propertyTextList = new ArrayList<Text>();
    private final String QUERYTEXT = "queryText";
    private static Logger logger = Logger.getLogger(PropertyBindingPage.class.getName());
    private ReportElementHandle handle;

    public Control createContents(Composite parent) {
        this.initPropertyBinding();
        int size = this.propList.size();
        ScrolledComposite sComposite = new ScrolledComposite(parent, 768);
        sComposite.setLayout((Layout)new GridLayout());
        sComposite.setLayoutData((Object)new GridData(1808));
        sComposite.setMinWidth(600);
        sComposite.setExpandHorizontal(true);
        Composite mainComposite = new Composite((Composite)sComposite, 0);
        mainComposite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(272);
        mainComposite.setLayoutData((Object)gridData);
        Text propertyText = null;
        int i = 0;
        while (i < size) {
            String contextId;
            OdaDataSourceHandle odsh;
            Label nameLabel = new Label(mainComposite, 0);
            String bindingName = "";
            boolean isEncryptable = false;
            if (this.propList.get(i) instanceof String[]) {
                bindingName = ((String[])this.propList.get(i))[0];
                nameLabel.setText(this.getLabelText(((String[])this.propList.get(i))[1]));
            } else if (this.propList.get(i) instanceof Property) {
                Property prop = (Property)this.propList.get(i);
                bindingName = prop.getName();
                nameLabel.setText(this.getLabelText(prop.getDisplayName()));
                isEncryptable = prop.isEncryptable();
            }
            this.nameLabelList.add(nameLabel);
            GridData data = new GridData(768);
            if ("queryText".equals(bindingName)) {
                propertyText = new Text(mainComposite, 2816);
                data.heightHint = 100;
            } else if (isEncryptable) {
                Expression expr;
                propertyText = new Text(mainComposite, 2048);
                if (this.ds instanceof DesignElementHandle && (expr = ((DesignElementHandle)this.ds).getPropertyBindingExpression(bindingName)) != null && "constant".equals(expr.getType())) {
                    Text dummy = new Text(mainComposite, 0x400800);
                    propertyText.setEchoChar(dummy.getEchoChar());
                    dummy.dispose();
                }
            } else {
                propertyText = new Text(mainComposite, 2048);
            }
            propertyText.setLayoutData((Object)data);
            if (i < this.bindingValue.size()) {
                propertyText.setText((String)this.bindingValue.get(i) == null ? "" : (String)this.bindingValue.get(i));
            }
            this.propertyTextList.add(propertyText);
            if (this.ds instanceof OdaDataSourceHandle) {
                this.handle = (OdaDataSourceHandle)this.ds;
                odsh = (OdaDataSourceHandle)this.ds;
                contextId = PropertyBindingPage.getDynamicContextId(odsh.getExtensionID(), odsh.getExtensionID());
                if (contextId != null) {
                    Utility.setSystemHelp((Control)mainComposite, (String)contextId);
                } else {
                    Utility.setSystemHelp((Control)mainComposite, (String)("org.eclipse.birt.cshelp.Wizard_DataSourcePropertyBinding(" + odsh.getExtensionID().replace('.', '_') + ")" + "_ID"));
                }
            } else if (this.ds instanceof OdaDataSetHandle) {
                this.handle = (OdaDataSetHandle)this.ds;
                odsh = (OdaDataSourceHandle)((OdaDataSetHandle)this.ds).getDataSource();
                contextId = PropertyBindingPage.getDynamicContextId(((OdaDataSetHandle)this.ds).getExtensionID(), odsh.getExtensionID());
                if (contextId != null) {
                    Utility.setSystemHelp((Control)mainComposite, (String)contextId);
                } else {
                    Utility.setSystemHelp((Control)mainComposite, (String)("org.eclipse.birt.cshelp.Wizard_DataSetPropertyBinding(" + odsh.getExtensionID().replace('.', '_') + ")" + "_ID"));
                }
            }
            this.createExpressionButton(mainComposite, propertyText, bindingName, isEncryptable);
            if (i == 0) {
                propertyText.setFocus();
            }
            ++i;
        }
        if (size <= 0) {
            this.setEmptyPropertyMessages(mainComposite);
        }
        Point compositeSize = mainComposite.computeSize(-1, -1);
        mainComposite.setSize(compositeSize.x, compositeSize.y);
        sComposite.setContent((Control)mainComposite);
        return sComposite;
    }

    private String getLabelText(String displayName) {
        return String.valueOf(displayName) + Messages.getString((String)"PropertyBindingPage.label.colon");
    }

    private void addPropertyDisplayNamesFromDriver(OdaDataSourceHandle dataSourceHandle) {
        try {
            ExtensionManifest extMF = ManifestExplorer.getInstance().getExtensionManifest(dataSourceHandle.getExtensionID());
            Property[] properties = extMF.getVisibleProperties();
            int i = 0;
            while (i < properties.length) {
                this.propList.add(properties[i]);
                ++i;
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    private void addPropertyDisplayNamesFromDriver(OdaDataSetHandle dataSetHandle) {
        try {
            ((OdaDataSourceHandle)dataSetHandle.getDataSource()).getExtensionID();
            ExtensionManifest extMF = ManifestExplorer.getInstance().getExtensionManifest(((OdaDataSourceHandle)dataSetHandle.getDataSource()).getExtensionID());
            Property[] properties = extMF.getDataSetType(dataSetHandle.getExtensionID()).getVisibleProperties();
            int i = 0;
            while (i < properties.length) {
                this.propList.add(properties[i]);
                ++i;
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    private static String getDynamicContextId(String helpKeyPrefix, String helpPlugin) {
        return HelpUtil.getContextId((String)(String.valueOf(helpKeyPrefix) + ".properties.helpKey"), (String)helpPlugin);
    }

    private void createExpressionButton(Composite composite, Text property, String propName, boolean isEncryptable) {
        Expression expr;
        ExpressionButton exprButton = ExpressionButtonUtil.createExpressionButton((Composite)composite, (Control)property, (IExpressionProvider)new ExpressionProvider((DesignElementHandle)this.handle), (Object)this.handle, (int)8);
        if (isEncryptable) {
            exprButton.setExpressionButtonProvider((IExpressionButtonProvider)new ExprButtonProvider(true, property));
        }
        property.setData("exprType", (Object)((expr = this.handle.getPropertyBindingExpression(propName)) == null || expr.getType() == null ? UIUtil.getDefaultScriptType() : expr.getType()));
        property.setText(expr == null || expr.getStringExpression() == null ? "" : expr.getStringExpression());
        exprButton.refresh();
    }

    private void initPropertyBinding() {
        this.ds = (IDesignElementModel)this.getContainer().getModel();
        Iterator iterator = null;
        IElementDefn elementDefn = this.getElementDefn();
        if (elementDefn != null) {
            iterator = elementDefn.getProperties().iterator();
        }
        if (this.ds instanceof DataSetHandle && ((DataSetHandle)this.ds).getPropertyHandle("queryText").isVisible()) {
            this.propList.add(new String[]{"queryText", Messages.getString((String)"PropertyBindingPage.dataset.queryText")});
            this.bindingValue.add(((DataSetHandle)this.ds).getPropertyBinding("queryText") == null ? "" : ((DataSetHandle)this.ds).getPropertyBinding("queryText"));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                IElementPropertyDefn propertyDefn = (IElementPropertyDefn)iterator.next();
                if (propertyDefn.getValueType() != 4) continue;
                String name = propertyDefn.getName();
                if (elementDefn != null && !elementDefn.isPropertyVisible(name)) continue;
                if (this.ds instanceof DataSetHandle) {
                    this.bindingValue.add(((DataSetHandle)this.ds).getPropertyBinding(name) == null ? "" : ((DataSetHandle)this.ds).getPropertyBinding(name));
                    continue;
                }
                if (this.ds instanceof DataSourceHandle) {
                    this.bindingValue.add(((DataSourceHandle)this.ds).getPropertyBinding(name) == null ? "" : ((DataSourceHandle)this.ds).getPropertyBinding(name));
                    continue;
                }
                this.bindingValue.add("");
            }
        }
        if (this.ds instanceof OdaDataSetHandle) {
            this.addPropertyDisplayNamesFromDriver((OdaDataSetHandle)this.ds);
        } else if (this.ds instanceof OdaDataSourceHandle) {
            this.addPropertyDisplayNamesFromDriver((OdaDataSourceHandle)this.ds);
        }
    }

    private IElementDefn getElementDefn() {
        IElementDefn elementDefn = null;
        if (this.ds instanceof DataSourceHandle) {
            elementDefn = ((DataSourceHandle)this.ds).getDefn();
        } else if (this.ds instanceof DataSetHandle) {
            elementDefn = ((DataSetHandle)this.ds).getDefn();
        }
        return elementDefn;
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.propList.size()) {
            try {
                String value = null;
                Text propertyText = this.propertyTextList.get(i);
                if (!propertyText.isDisposed() && propertyText.getText() != null && propertyText.getText().trim().length() > 0) {
                    value = propertyText.getText().trim();
                }
                Expression expr = new Expression(value, (String)propertyText.getData("exprType"));
                if (this.ds instanceof DesignElementHandle) {
                    if (this.propList.get(i) instanceof String[]) {
                        ((DesignElementHandle)this.ds).setPropertyBinding(((String[])this.propList.get(i))[0], expr);
                    } else if (this.propList.get(i) instanceof Property) {
                        ((DesignElementHandle)this.ds).setPropertyBinding(((Property)this.propList.get(i)).getName(), expr);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, e.getMessage(), e);
                ExceptionHandler.handle((Throwable)e);
                return true;
            }
            ++i;
        }
        return super.performOk();
    }

    private void setEmptyPropertyMessages(Composite composite) {
        Label messageLabel = new Label(composite, 0);
        if (this.ds instanceof DataSourceHandle) {
            messageLabel.setText(Messages.getString((String)"PropertyBindingPage.datasource.property.empty"));
        } else if (this.ds instanceof DataSetHandle) {
            messageLabel.setText(Messages.getString((String)"PropertyBindingPage.dataset.property.empty"));
        }
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"datasource.editor.property"), 0);
    }

    public String getToolTip() {
        return Messages.getString((String)"PropertyBindingPage.property.tooltip");
    }

    private static class ExprButtonProvider
    extends ExpressionButtonProvider {
        private Text propText;

        public ExprButtonProvider(boolean allowConstant, Text propText) {
            super(allowConstant);
            this.propText = propText;
        }

        public void handleSelectionEvent(String exprType) {
            super.handleSelectionEvent(exprType);
            if ("constant".equals(exprType)) {
                Text dummy = new Text(this.propText.getParent(), 0x400800);
                this.propText.setEchoChar(dummy.getEchoChar());
                dummy.dispose();
            } else {
                this.propText.setEchoChar('\u0000');
            }
        }
    }
}

