/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.site.SiteCategory;
import org.eclipse.pde.internal.core.site.VersionableObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteFeature
extends VersionableObject
implements ISiteFeature {
    private static final long serialVersionUID = 1L;
    private final Vector<ISiteCategory> fCategories = new Vector();
    private String fType;
    private String fUrl;
    private String fOS;
    private String fWS;
    private String fArch;
    private String fNL;
    private boolean fIsPatch;

    @Override
    public boolean isValid() {
        if (this.fUrl == null) {
            return false;
        }
        int i = 0;
        while (i < this.fCategories.size()) {
            ISiteCategory category = this.fCategories.get(i);
            if (!category.isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void addCategories(ISiteCategory[] newCategories) throws CoreException {
        this.ensureModelEditable();
        ISiteCategory[] iSiteCategoryArray = newCategories;
        int n = newCategories.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteCategory category = iSiteCategoryArray[n2];
            ((SiteCategory)category).setInTheModel(true);
            this.fCategories.add(category);
            ++n2;
        }
        this.fireStructureChanged(newCategories, 1);
    }

    @Override
    public void removeCategories(ISiteCategory[] newCategories) throws CoreException {
        this.ensureModelEditable();
        ISiteCategory[] iSiteCategoryArray = newCategories;
        int n = newCategories.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteCategory category = iSiteCategoryArray[n2];
            ((SiteCategory)category).setInTheModel(false);
            this.fCategories.remove(category);
            ++n2;
        }
        this.fireStructureChanged(newCategories, 2);
    }

    @Override
    public ISiteCategory[] getCategories() {
        return this.fCategories.toArray(new ISiteCategory[this.fCategories.size()]);
    }

    @Override
    public String getType() {
        return this.fType;
    }

    @Override
    public String getURL() {
        return this.fUrl;
    }

    @Override
    public void setType(String type) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fType;
        this.fType = type;
        this.firePropertyChanged("type", oldValue, this.fType);
    }

    @Override
    public void setURL(String url) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fUrl;
        this.fUrl = url;
        this.firePropertyChanged("type", oldValue, url);
    }

    @Override
    protected void parse(Node node) {
        super.parse(node);
        this.fType = this.getNodeAttribute(node, "type");
        this.fUrl = this.getNodeAttribute(node, "url");
        this.fOS = this.getNodeAttribute(node, "os");
        this.fNL = this.getNodeAttribute(node, "nl");
        this.fWS = this.getNodeAttribute(node, "ws");
        this.fArch = this.getNodeAttribute(node, "arch");
        String value = this.getNodeAttribute(node, "patch");
        this.fIsPatch = value != null && value.equals("true");
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase("category")) {
                SiteCategory category = (SiteCategory)this.getModel().getFactory().createCategory(this);
                category.parse(child);
                category.setInTheModel(true);
                this.fCategories.add(category);
            }
            ++i;
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.fType = null;
        this.fUrl = null;
        this.fOS = null;
        this.fWS = null;
        this.fArch = null;
        this.fNL = null;
        this.fIsPatch = false;
        this.fCategories.clear();
    }

    @Override
    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        switch (name) {
            case "type": {
                this.setType(newValue != null ? newValue.toString() : null);
                break;
            }
            case "url": {
                this.setURL(newValue != null ? newValue.toString() : null);
                break;
            }
            case "arch": {
                this.setArch(newValue != null ? newValue.toString() : null);
                break;
            }
            case "nl": {
                this.setNL(newValue != null ? newValue.toString() : null);
                break;
            }
            case "os": {
                this.setOS(newValue != null ? newValue.toString() : null);
                break;
            }
            case "ws": {
                this.setWS(newValue != null ? newValue.toString() : null);
                break;
            }
            case "patch": {
                this.setIsPatch((Boolean)newValue);
                break;
            }
            default: {
                super.restoreProperty(name, oldValue, newValue);
            }
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.print(indent);
        writer.print("<feature");
        if (this.fType != null) {
            writer.print(" type=\"" + this.fType + "\"");
        }
        if (this.fUrl != null) {
            writer.print(" url=\"" + this.fUrl + "\"");
        }
        if (this.id != null) {
            writer.print(" id=\"" + this.getId() + "\"");
        }
        if (this.version != null) {
            writer.print(" version=\"" + this.getVersion() + "\"");
        }
        if (this.label != null) {
            writer.print(" label=\"" + this.getLabel() + "\"");
        }
        if (this.fOS != null) {
            writer.print(" os=\"" + this.fOS + "\"");
        }
        if (this.fWS != null) {
            writer.print(" ws=\"" + this.fWS + "\"");
        }
        if (this.fNL != null) {
            writer.print(" nl=\"" + this.fNL + "\"");
        }
        if (this.fArch != null) {
            writer.print(" arch=\"" + this.fArch + "\"");
        }
        if (this.fIsPatch) {
            writer.print(" patch=\"true\"");
        }
        if (!this.fCategories.isEmpty()) {
            writer.println(">");
            String indent2 = String.valueOf(indent) + "   ";
            int i = 0;
            while (i < this.fCategories.size()) {
                ISiteCategory category = this.fCategories.get(i);
                category.write(indent2, writer);
                ++i;
            }
            writer.println(String.valueOf(indent) + "</feature>");
        } else {
            writer.println("/>");
        }
    }

    @Override
    public IFile getArchiveFile() {
        if (this.fUrl == null) {
            return null;
        }
        IResource resource = this.getModel().getUnderlyingResource();
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        IFile file = project.getFile((IPath)new Path(this.fUrl));
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @Override
    public String getOS() {
        return this.fOS;
    }

    @Override
    public String getNL() {
        return this.fNL;
    }

    @Override
    public String getArch() {
        return this.fArch;
    }

    @Override
    public String getWS() {
        return this.fWS;
    }

    @Override
    public void setOS(String os) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fOS;
        this.fOS = os;
        this.firePropertyChanged("os", oldValue, this.fOS);
    }

    @Override
    public void setWS(String ws) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fWS;
        this.fWS = ws;
        this.firePropertyChanged("ws", oldValue, this.fWS);
    }

    @Override
    public void setArch(String arch) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fArch;
        this.fArch = arch;
        this.firePropertyChanged("arch", oldValue, this.fArch);
    }

    @Override
    public void setNL(String nl) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fNL;
        this.fNL = nl;
        this.firePropertyChanged("nl", oldValue, this.fNL);
    }

    @Override
    public boolean isPatch() {
        return this.fIsPatch;
    }

    @Override
    public void setIsPatch(boolean patch) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = this.fIsPatch;
        this.fIsPatch = patch;
        this.firePropertyChanged("patch", oldValue, this.fIsPatch);
    }
}

