/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import org.eclipse.jst.j2ee.internal.web.operations.AbstractSupertypesValidator;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ServletSupertypesValidator
extends AbstractSupertypesValidator {
    public static boolean isHttpServletSuperclass(IDataModel dataModel) {
        if ("jakarta.servlet.http.HttpServlet".equals(ServletSupertypesValidator.getSuperclass(dataModel))) {
            return true;
        }
        if ("javax.servlet.http.HttpServlet".equals(ServletSupertypesValidator.getSuperclass(dataModel))) {
            return true;
        }
        if (ServletSupertypesValidator.hasSuperclass(dataModel, ServletSupertypesValidator.getSuperclass(dataModel), "jakarta.servlet.http.HttpServlet")) {
            return true;
        }
        return ServletSupertypesValidator.hasSuperclass(dataModel, ServletSupertypesValidator.getSuperclass(dataModel), "javax.servlet.http.HttpServlet");
    }

    public static boolean isGenericServletSuperclass(IDataModel dataModel) {
        if ("jakarta.servlet.http.HttpServlet".equals(ServletSupertypesValidator.getSuperclass(dataModel))) {
            return true;
        }
        if ("javax.servlet.http.HttpServlet".equals(ServletSupertypesValidator.getSuperclass(dataModel))) {
            return true;
        }
        if ("jakarta.servlet.GenericServlet".equals(ServletSupertypesValidator.getSuperclass(dataModel))) {
            return true;
        }
        if ("javax.servlet.GenericServlet".equals(ServletSupertypesValidator.getSuperclass(dataModel))) {
            return true;
        }
        if (ServletSupertypesValidator.hasSuperclass(dataModel, ServletSupertypesValidator.getSuperclass(dataModel), "jakarta.servlet.GenericServlet")) {
            return true;
        }
        return ServletSupertypesValidator.hasSuperclass(dataModel, ServletSupertypesValidator.getSuperclass(dataModel), "javax.servlet.GenericServlet");
    }

    public static boolean isServletSuperclass(IDataModel dataModel) {
        if ("jakarta.servlet.http.HttpServlet".equals(ServletSupertypesValidator.getSuperclass(dataModel))) {
            return true;
        }
        if ("javax.servlet.http.HttpServlet".equals(ServletSupertypesValidator.getSuperclass(dataModel))) {
            return true;
        }
        if ("jakarta.servlet.GenericServlet".equals(ServletSupertypesValidator.getSuperclass(dataModel))) {
            return true;
        }
        if ("javax.servlet.GenericServlet".equals(ServletSupertypesValidator.getSuperclass(dataModel))) {
            return true;
        }
        if (ServletSupertypesValidator.getInterfaces(dataModel).contains("jakarta.servlet.Servlet")) {
            return true;
        }
        if (ServletSupertypesValidator.getInterfaces(dataModel).contains("javax.servlet.Servlet")) {
            return true;
        }
        if (ServletSupertypesValidator.hasSuperInterface(dataModel, ServletSupertypesValidator.getSuperclass(dataModel), "jakarta.servlet.Servlet")) {
            return true;
        }
        if (ServletSupertypesValidator.hasSuperInterface(dataModel, ServletSupertypesValidator.getSuperclass(dataModel), "javax.servlet.Servlet")) {
            return true;
        }
        for (Object iface : ServletSupertypesValidator.getInterfaces(dataModel)) {
            if (ServletSupertypesValidator.hasSuperInterface(dataModel, (String)iface, "jakarta.servlet.Servlet")) {
                return true;
            }
            if (!ServletSupertypesValidator.hasSuperInterface(dataModel, (String)iface, "javax.servlet.Servlet")) continue;
            return true;
        }
        return false;
    }
}

