/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.PDFLayoutEmitter;

public class WrappedPDFLayoutEmitter
extends LayoutEmitterAdapter
implements IContentEmitter {
    private PDFLayoutEmitter layoutEmitter;
    private int repeatedHeaderLevel = 0;
    private Stack parentContents = new Stack();
    private HashMap cachedGroupHeaders = new HashMap();
    private HashMap cachedTableHeaders = new HashMap();

    public WrappedPDFLayoutEmitter(IReportExecutor executor, IContentEmitter emitter, LayoutEngineContext context) {
        this.layoutEmitter = new PDFLayoutEmitter(executor, emitter, context);
        this.layoutEmitter.context.setCachedHeaderMap(this.cachedTableHeaders, this.cachedGroupHeaders);
    }

    @Override
    public void initialize(IEmitterServices service) throws BirtException {
        this.layoutEmitter.initialize(service);
    }

    @Override
    public String getOutputFormat() {
        return this.layoutEmitter.getOutputFormat();
    }

    @Override
    public void start(IReportContent report) throws BirtException {
        this.layoutEmitter.start(report);
    }

    @Override
    public void end(IReportContent report) throws BirtException {
        this.layoutEmitter.end(report);
    }

    protected void resolveTotalPage(IContentEmitter emitter) throws BirtException {
        this.layoutEmitter.resolveTotalPage(emitter);
    }

    @Override
    public void startContainer(IContainerContent container) throws BirtException {
        this.layoutEmitter.startContainer(container);
        if (this.isInHeader()) {
            this.constructClonedContent(container);
        }
    }

    @Override
    public void endContainer(IContainerContent container) throws BirtException {
        this.layoutEmitter.endContainer(container);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    @Override
    public void startContent(IContent content) throws BirtException {
        this.layoutEmitter.startContent(content);
        if (this.isInHeader()) {
            if (content instanceof IContainerContent) {
                this.constructClonedContent((IContainerContent)content);
            } else {
                IContainerContent pContent = (IContainerContent)this.parentContents.peek();
                pContent.getChildren().add(content);
            }
        }
    }

    @Override
    public void endContent(IContent content) {
        this.layoutEmitter.endContent(content);
        if (this.isInHeader() && content instanceof IContainerContent) {
            this.destructClonedContent();
        }
    }

    @Override
    public void startTable(ITableContent table) throws BirtException {
        this.layoutEmitter.startTable(table);
        if (this.isInHeader()) {
            this.constructClonedContent(table);
        }
    }

    @Override
    public void endTable(ITableContent table) throws BirtException {
        this.layoutEmitter.endTable(table);
        InstanceID tableID = table.getInstanceID();
        this.removeCachedTableHeader(tableID);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    @Override
    public void startListBand(IListBandContent listBand) {
        this.layoutEmitter.startListBand(listBand);
        if (this.isInHeader()) {
            this.constructClonedContent(listBand);
        }
    }

    @Override
    public void endListBand(IListBandContent listBand) {
        this.layoutEmitter.endListBand(listBand);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    @Override
    public void startListGroup(IListGroupContent listGroup) throws BirtException {
        this.layoutEmitter.startListGroup(listGroup);
        if (this.isInHeader()) {
            this.constructClonedContent(listGroup);
        }
    }

    public void endListGroup(IListBandContent listGroup) {
        this.layoutEmitter.endListBand(listGroup);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    @Override
    public void startPage(IPageContent page) throws BirtException {
        this.layoutEmitter.startPage(page);
    }

    @Override
    public void outputPage(IPageContent page) throws BirtException {
        this.layoutEmitter.outputPage(page);
    }

    @Override
    public void endPage(IPageContent page) throws BirtException {
        this.layoutEmitter.endPage(page);
    }

    @Override
    public void startRow(IRowContent row) throws BirtException {
        this.layoutEmitter.startRow(row);
        if (this.isInHeader()) {
            this.constructClonedContent(row);
        }
    }

    @Override
    public void endRow(IRowContent row) throws BirtException {
        this.layoutEmitter.endRow(row);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    @Override
    public void startTableBand(ITableBandContent band) throws BirtException {
        this.layoutEmitter.startTableBand(band);
        if (band.getBandType() == 3) {
            IElement group = band.getParent();
            if (group instanceof ITableGroupContent && ((ITableGroupContent)group).isHeaderRepeat()) {
                InstanceID id = ((ITableGroupContent)group).getInstanceID();
                ++this.repeatedHeaderLevel;
                ITableBandContent clonedBand = (ITableBandContent)this.constructClonedContent(band);
                this.createCachedGroupHeader(id, clonedBand);
            }
        } else if (band.getBandType() == 1) {
            IElement table = band.getParent();
            if (table instanceof ITableContent && ((ITableContent)table).isHeaderRepeat()) {
                InstanceID tableID = ((ITableContent)table).getInstanceID();
                ++this.repeatedHeaderLevel;
                ITableBandContent clonedBand = (ITableBandContent)this.constructClonedContent(band);
                this.createCachedTableHeader(tableID, clonedBand);
            }
        } else if (this.isInHeader()) {
            this.constructClonedContent(band);
        }
    }

    @Override
    public void endTableBand(ITableBandContent band) throws BirtException {
        this.layoutEmitter.endTableBand(band);
        if (this.isInHeader()) {
            this.destructClonedContent();
            if (band.getBandType() == 3) {
                --this.repeatedHeaderLevel;
            }
            if (band.getBandType() == 1) {
                --this.repeatedHeaderLevel;
            }
        }
    }

    @Override
    public void startTableGroup(ITableGroupContent group) throws BirtException {
        this.layoutEmitter.startTableGroup(group);
        if (this.isInHeader()) {
            this.constructClonedContent(group);
        }
    }

    @Override
    public void endTableGroup(ITableGroupContent group) throws BirtException {
        this.layoutEmitter.endTableGroup(group);
        this.removeCachedGroupHeader(group.getInstanceID());
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    @Override
    public void startCell(ICellContent cell) throws BirtException {
        this.layoutEmitter.startCell(cell);
        if (this.isInHeader()) {
            this.constructClonedContent(cell);
        }
    }

    @Override
    public void endCell(ICellContent cell) throws BirtException {
        this.layoutEmitter.endCell(cell);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    @Override
    public void startForeign(IForeignContent foreign) throws BirtException {
        this.layoutEmitter.startForeign(foreign);
        if (this.isInHeader()) {
            IContainerContent pContent = (IContainerContent)this.parentContents.peek();
            pContent.getChildren().add(foreign);
        }
    }

    @Override
    public ILayoutPageHandler getPageHandler() {
        return this.layoutEmitter.getPageHandler();
    }

    @Override
    public void setPageHandler(ILayoutPageHandler pageHandler) {
        this.layoutEmitter.setPageHandler(pageHandler);
    }

    private boolean isInHeader() {
        return this.repeatedHeaderLevel > 0;
    }

    private void createCachedGroupHeader(InstanceID id, ITableBandContent header) {
        this.cachedGroupHeaders.put(id, header);
    }

    private void removeCachedGroupHeader(InstanceID id) {
        this.cachedGroupHeaders.remove(id);
    }

    private void createCachedTableHeader(InstanceID id, ITableBandContent header) {
        this.cachedTableHeaders.put(id, header);
    }

    private void removeCachedTableHeader(InstanceID id) {
        this.cachedTableHeaders.remove(id);
    }

    private IContainerContent constructClonedContent(IContainerContent container) {
        if (this.parentContents.isEmpty()) {
            IContainerContent clonedContainer = (IContainerContent)container.cloneContent(false);
            clonedContainer.setParent(container.getParent());
            this.parentContents.push(clonedContainer);
            return clonedContainer;
        }
        IContainerContent pContent = (IContainerContent)this.parentContents.peek();
        IContainerContent clonedContainer = (IContainerContent)container.cloneContent(false);
        clonedContainer.setParent(container.getParent());
        pContent.getChildren().add(clonedContainer);
        this.parentContents.push(clonedContainer);
        return clonedContainer;
    }

    private void destructClonedContent() {
        if (!this.parentContents.isEmpty()) {
            this.parentContents.pop();
        }
    }
}

