/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.nLayout.area.IArea;

public class PPTUtil {
    private static final Logger logger = Logger.getLogger(PPTUtil.class.getName());

    public static HyperlinkDef getHyperlink(IArea area, IEmitterServices services, IReportRunnable reportRunnable, IReportContext context) {
        IHyperlinkAction hyperlinkAction = area.getAction();
        if (hyperlinkAction != null) {
            try {
                if (hyperlinkAction.getType() != 2) {
                    String link = hyperlinkAction.getHyperlink();
                    String tooltip = hyperlinkAction.getTooltip();
                    Object handler = services.getOption("actionHandler");
                    if (handler instanceof IHTMLActionHandler) {
                        IHTMLActionHandler actionHandler = (IHTMLActionHandler)handler;
                        String systemId = reportRunnable == null ? null : reportRunnable.getReportName();
                        Action action = new Action(systemId, hyperlinkAction);
                        link = actionHandler.getURL((IAction)action, context);
                    }
                    return new HyperlinkDef(link, tooltip);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    public static class HyperlinkDef {
        String link;
        String tooltip;

        public HyperlinkDef(String link, String tooltip) {
            this.link = link;
            this.tooltip = tooltip;
        }

        public String getLink() {
            return this.link;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }
}

