/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.internal.impl;

import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.internal.impl.SampleDbFactory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;

public class SampleDbPropertyProvider
implements IPropertyProvider {
    public Properties getDataSourceProperties(Properties candidateProperties, Object appContext) throws OdaException {
        if (!SampleDbPropertyProvider.isTransientSampleDbProfile(candidateProperties)) {
            return candidateProperties;
        }
        Properties defaultProfileProps = new Properties();
        defaultProfileProps.setProperty("OdaConnProfileName", SampleDbFactory.getLocalizedSampleDbProfileName());
        IConnectionProfile sampleDbProfile = OdaProfileExplorer.getInstance().getProfileByName(defaultProfileProps, appContext);
        if (sampleDbProfile != null) {
            defaultProfileProps.clear();
            defaultProfileProps.putAll((Map<?, ?>)candidateProperties);
            defaultProfileProps.putAll((Map<?, ?>)sampleDbProfile.getBaseProperties());
            return defaultProfileProps;
        }
        return candidateProperties;
    }

    private static boolean isTransientSampleDbProfile(Properties dbProfileProps) {
        String profileName = dbProfileProps.getProperty("OdaConnProfileName");
        if (profileName != null && profileName.length() > 0) {
            return false;
        }
        String driverDefnId = dbProfileProps.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID", null);
        if (driverDefnId == null || !driverDefnId.equalsIgnoreCase("DriverDefn.org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb.driverTemplate.BIRT SampleDb Derby Embedded Driver") && !driverDefnId.equalsIgnoreCase(SampleDbFactory.getLocalizedDriverDefinitionId())) {
            return false;
        }
        String dbUrl = dbProfileProps.getProperty("org.eclipse.datatools.connectivity.db.URL", null);
        return dbUrl != null && dbUrl.replace('\\', '/').indexOf("org.eclipse.birt.report.data.oda.jdbc.dbprofile.sampledb/db/BirtSample") != -1;
    }
}

