/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.AmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.impl.CompareUtil;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputPromptControlStyle;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;

class ReportParamChecker {
    protected ScalarParameterHandle reportParam;
    protected ParameterDefinition currentParam;
    private List<IAmbiguousAttribute> ambiguousList;
    private Set<String> ambiguousAttrs = null;

    ReportParamChecker(ParameterDefinition currentParam, ScalarParameterHandle reportParam) {
        this.currentParam = currentParam;
        this.reportParam = reportParam;
        this.ambiguousAttrs = new HashSet<String>(4);
        this.ambiguousList = new ArrayList<IAmbiguousAttribute>();
    }

    public List<IAmbiguousAttribute> process() {
        DataElementAttributes dataAttrs = this.currentParam.getAttributes();
        this.processDataElementAttributes(dataAttrs);
        InputParameterAttributes inputParamAttrs = this.currentParam.getInputAttributes();
        this.processInputParameterAttributes(inputParamAttrs);
        return this.ambiguousList;
    }

    private void processDataElementAttributes(DataElementAttributes dataAttrs) {
        if (dataAttrs == null) {
            return;
        }
        boolean allowsNull = dataAttrs.allowsNull();
        boolean oldValue = this.reportParam.isRequired();
        this.handleValue(allowsNull, oldValue, "isRequired", true);
        DataElementUIHints dataElementUIHints = dataAttrs.getUiHints();
        this.processDataElementUIHints(dataElementUIHints);
    }

    private void processDataElementUIHints(DataElementUIHints dataElementUiHints) {
        if (dataElementUiHints == null) {
            return;
        }
        String newPromptText = dataElementUiHints.getDisplayName();
        String oldPrompText = this.reportParam.getPromptText();
        this.handleValue(newPromptText, oldPrompText, "promptText");
        String newHelpText = dataElementUiHints.getDescription();
        String oldHelpText = this.reportParam.getHelpText();
        this.handleValue(newHelpText, oldHelpText, "helpText");
    }

    private void processInputParameterAttributes(InputParameterAttributes attrs) {
        if (attrs == null) {
            return;
        }
        InputElementAttributes inputElementAttrs = attrs.getElementAttributes();
        this.processInputElementAttributes(inputElementAttrs);
        InputParameterUIHints inputParamUIHints = attrs.getUiHints();
        this.processInputParameterUIHints(inputParamUIHints);
    }

    private void processInputParameterUIHints(InputParameterUIHints inputParamUiHints) {
        if (inputParamUiHints == null) {
            return;
        }
        if (this.reportParam.getContainer() instanceof ParameterGroupHandle) {
            ParameterGroupHandle groupHandle = (ParameterGroupHandle)this.reportParam.getContainer();
            String newValue = inputParamUiHints.getGroupPromptDisplayName();
            String oldValue = groupHandle.getDisplayName();
            this.handleValue(newValue, oldValue, "displayName");
        }
    }

    private void processInputElementAttributes(InputElementAttributes attrs) {
        if (attrs == null) {
            return;
        }
        boolean isOptional = attrs.isOptional();
        boolean oldValue = this.reportParam.isRequired();
        this.handleValue(isOptional, oldValue, "isRequired", true);
        boolean newConcealValue = attrs.isMasksValue();
        boolean oldConcealValue = this.reportParam.isConcealValue();
        this.handleValue(newConcealValue, oldConcealValue, "concealValue", false);
        InputElementUIHints inputElementUIHints = attrs.getUiHints();
        this.processInputElementUIHints(inputElementUIHints);
    }

    private void processInputElementUIHints(InputElementUIHints inputElementUiHints) {
        int oldValue;
        if (inputElementUiHints == null) {
            return;
        }
        int newValue = inputElementUiHints.getAutoSuggestThreshold();
        if (newValue != (oldValue = this.reportParam.getAutoSuggestThreshold()) && !this.ambiguousAttrs.contains("autoSuggestThreshold")) {
            this.ambiguousList.add(new AmbiguousAttribute("autoSuggestThreshold", oldValue, newValue, true));
            this.ambiguousAttrs.add("autoSuggestThreshold");
        }
        InputPromptControlStyle style = inputElementUiHints.getPromptStyle();
        this.processInputPromptControlStyle(style);
    }

    private void processInputPromptControlStyle(InputPromptControlStyle style) {
        if (style == null) {
            return;
        }
        String newControlType = AdapterUtil.newROMControlType(style);
        String oldControlType = this.reportParam.getControlType();
        this.handleValue(newControlType, oldControlType, "controlType");
    }

    private void handleValue(String newValue, String oldValue, String propName) {
        PropertyHandle propHandle = this.reportParam.getPropertyHandle(propName);
        if (!CompareUtil.isEquals(newValue, oldValue) && !this.ambiguousAttrs.contains(propName)) {
            if (newValue == null && !propHandle.isLocal()) {
                return;
            }
            this.ambiguousList.add(new AmbiguousAttribute(propName, oldValue, newValue, true));
            this.ambiguousAttrs.add(propName);
        }
    }

    private void handleValue(boolean newValue, boolean oldValue, String propName, boolean isContary) {
        if (isContary) {
            boolean bl = newValue = !newValue;
        }
        if (!CompareUtil.isEquals(newValue, oldValue) && !this.ambiguousAttrs.contains(propName)) {
            this.ambiguousList.add(new AmbiguousAttribute(propName, oldValue, newValue, true));
            this.ambiguousAttrs.add(propName);
        }
    }
}

