/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.birt.report.designer.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class DateSetPreferencePage
extends PropertyAndPreferencePage {
    private IntegerFieldEditor maxRowEditor;
    private Button promptButton;
    private Button paramUpdatePromptButton;
    private Button updateButton;
    private Button ignoreButton;
    private Label alwaysLabel;
    public static final int DEFAULT_MAX_ROW = 500;
    public static final boolean DEFAULT_PROMPT_SELECTION = false;
    public static final boolean DEFAULT_REPORTPARAM_UPDATE_PROMP_SELECTION = false;
    private static final int MAX_MAX_ROW = Integer.MAX_VALUE;
    public static final String USER_MAXROW = "user_maxrow";
    public static final String USER_MAX_NUM_OF_SCHEMA = "user_max_num_of_schema";
    public static final String USER_MAX_NUM_OF_TABLE_EACH_SCHEMA = "user_max_num_of_table_each_schema";
    public static final String PROMPT_ENABLE = "prompt_enable";
    public static final String PROMPT_PARAM_UPDATE = "reportParam_update_enable";
    public static final String PROMPT_PARAM_UPDATE_OPTION = "reportParam_update_enable_option";
    public static final String PROMPT_PARAM_UPDATE_OPTION_UPDATE = "update";
    public static final String PROMPT_PARAM_UPDATE_OPTION_IGNORE = "ignore";
    private OptionsConfigurationBlock block = null;

    @Override
    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.Preference_BIRT_DataSetEditor_ID");
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalSpan = 5;
        GridLayout layout = new GridLayout();
        mainComposite.setLayout((Layout)layout);
        Group previewPageGroup = new Group(mainComposite, 0);
        previewPageGroup.setLayout((Layout)new GridLayout());
        previewPageGroup.setText(Messages.getString((String)"designer.preview.preference.resultset.previewpage.group.title"));
        previewPageGroup.setLayoutData((Object)data);
        previewPageGroup.setEnabled(true);
        this.maxRowEditor = new IntegerFieldEditor(USER_MAXROW, "", (Composite)previewPageGroup);
        Label lab2 = this.maxRowEditor.getLabelControl((Composite)previewPageGroup);
        lab2.setText(Messages.getString((String)"designer.preview.preference.resultset.maxrow.description"));
        this.maxRowEditor.setPage((DialogPage)this);
        this.maxRowEditor.setTextLimit(Integer.toString(Integer.MAX_VALUE).length());
        this.maxRowEditor.setErrorMessage(Messages.getFormattedString((String)"designer.preview.preference.resultset.maxrow.errormessage", (Object[])new Object[]{Integer.MAX_VALUE}));
        this.maxRowEditor.setValidateStrategy(0);
        this.maxRowEditor.setValidRange(1, Integer.MAX_VALUE);
        this.maxRowEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    DateSetPreferencePage.this.setValid(DateSetPreferencePage.this.maxRowEditor.isValid());
                }
            }
        });
        String defaultMaxRow = ReportPlugin.getDefault().getPluginPreferences().getString(USER_MAXROW);
        if (defaultMaxRow == null || defaultMaxRow.trim().length() <= 0) {
            defaultMaxRow = String.valueOf(500);
        }
        this.maxRowEditor.setStringValue(defaultMaxRow);
        Group promptPageGroup = new Group(mainComposite, 0);
        promptPageGroup.setLayout((Layout)new GridLayout());
        promptPageGroup.setText(Messages.getString((String)"designer.preview.preference.updateParameter.confirmMessage"));
        this.promptButton = new Button((Composite)promptPageGroup, 32);
        boolean enable = ReportPlugin.getDefault().getPluginPreferences().getBoolean(PROMPT_ENABLE);
        this.promptButton.setSelection(enable);
        this.promptButton.setText(Messages.getString((String)"designer.preview.preference.updateParameter.confirmButton"));
        this.paramUpdatePromptButton = new Button((Composite)promptPageGroup, 32);
        boolean enableParamUpdate = ReportPlugin.getDefault().getPluginPreferences().getBoolean(PROMPT_PARAM_UPDATE);
        this.paramUpdatePromptButton.setSelection(enableParamUpdate);
        this.paramUpdatePromptButton.setText(Messages.getString((String)"designer.preview.preference.updateReportParameter.confirmButton"));
        this.paramUpdatePromptButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DateSetPreferencePage.this.paramUpdatePromptButton.getSelection()) {
                    DateSetPreferencePage.this.updateButton.setEnabled(true);
                    DateSetPreferencePage.this.ignoreButton.setEnabled(true);
                    DateSetPreferencePage.this.alwaysLabel.setEnabled(true);
                } else {
                    DateSetPreferencePage.this.updateButton.setEnabled(false);
                    DateSetPreferencePage.this.ignoreButton.setEnabled(false);
                    DateSetPreferencePage.this.alwaysLabel.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite com = new Composite((Composite)promptPageGroup, 0);
        GridLayout gd = new GridLayout();
        gd.numColumns = 3;
        com.setLayout((Layout)gd);
        this.alwaysLabel = new Label(com, 0);
        this.alwaysLabel.setText(Messages.getString((String)"designer.preview.preference.updateReportParameter.confirmOption.always"));
        this.updateButton = new Button(com, 16);
        this.updateButton.setText(Messages.getString((String)"designer.preview.preference.updateReportParameter.confirmOption.update"));
        this.ignoreButton = new Button(com, 16);
        this.ignoreButton.setText(Messages.getString((String)"designer.preview.preference.updateReportParameter.confirmOption.ignore"));
        if (enableParamUpdate) {
            this.alwaysLabel.setEnabled(true);
            this.updateButton.setEnabled(true);
            this.ignoreButton.setEnabled(true);
        } else {
            this.updateButton.setEnabled(false);
            this.ignoreButton.setEnabled(false);
            this.alwaysLabel.setEnabled(false);
        }
        String option = ReportPlugin.getDefault().getPluginPreferences().getString(PROMPT_PARAM_UPDATE_OPTION);
        if (PROMPT_PARAM_UPDATE_OPTION_UPDATE.equals(option) || option.equals("")) {
            this.updateButton.setSelection(true);
            this.ignoreButton.setSelection(false);
        } else if (PROMPT_PARAM_UPDATE_OPTION_IGNORE.equals(option)) {
            this.ignoreButton.setSelection(true);
            this.updateButton.setSelection(false);
        }
        if (this.getConfigBlock() != null) {
            this.getConfigBlock().createContents(mainComposite);
        }
        return mainComposite;
    }

    @Override
    public void init(IWorkbench workbench) {
    }

    @Override
    protected void performDefaults() {
        this.maxRowEditor.setStringValue(String.valueOf(500));
        this.promptButton.setSelection(false);
        this.paramUpdatePromptButton.setSelection(false);
        this.alwaysLabel.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.ignoreButton.setEnabled(false);
        this.updateButton.setSelection(true);
        this.ignoreButton.setSelection(false);
        if (this.getConfigBlock() != null) {
            this.getConfigBlock().performDefaults();
        }
        super.performDefaults();
    }

    protected void performApply() {
        super.performApply();
        if (this.getConfigBlock() != null) {
            this.getConfigBlock().performApply();
        }
    }

    public boolean performOk() {
        ReportPlugin.getDefault().getPluginPreferences().setValue(USER_MAXROW, this.maxRowEditor.getStringValue());
        ReportPlugin.getDefault().getPluginPreferences().setValue(PROMPT_ENABLE, this.promptButton.getSelection());
        ReportPlugin.getDefault().getPluginPreferences().setValue(PROMPT_PARAM_UPDATE, this.paramUpdatePromptButton.getSelection());
        if (this.updateButton.getSelection()) {
            ReportPlugin.getDefault().getPluginPreferences().setValue(PROMPT_PARAM_UPDATE_OPTION, PROMPT_PARAM_UPDATE_OPTION_UPDATE);
        } else if (this.ignoreButton.getSelection()) {
            ReportPlugin.getDefault().getPluginPreferences().setValue(PROMPT_PARAM_UPDATE_OPTION, PROMPT_PARAM_UPDATE_OPTION_IGNORE);
        }
        ReportPlugin.getDefault().savePluginPreferences();
        if (this.getConfigBlock() != null) {
            this.getConfigBlock().performOk();
        }
        return true;
    }

    private OptionsConfigurationBlock getConfigBlock() {
        if (this.block == null && ExtendedDataModelUIAdapterHelper.getInstance().getAdapter() != null) {
            this.block = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter().getDataModelConfigurationBlock(this.getNewStatusChangedListener(), null);
        }
        return this.block;
    }

    @Override
    protected Control createPreferenceContent(Composite composite) {
        return null;
    }

    @Override
    protected boolean hasProjectSpecificOptions(IProject project) {
        return false;
    }

    @Override
    protected String getPreferencePageID() {
        return null;
    }

    @Override
    protected String getPropertyPageID() {
        return null;
    }
}

