/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.model.attribute.LineDecorator;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractHeadStyleChooserComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class HeadStyleAttributeComposite
extends Composite
implements SelectionListener,
Listener {
    private transient Composite cmpContent = null;
    private transient Label lblHeadStyle = null;
    private transient AbstractHeadStyleChooserComposite cmbHeadStyle = null;
    private transient LineDecorator laCurrent = null;
    private transient Vector<Listener> vListeners = null;
    private EObject eParent;
    private ChartWizardContext context;
    private String sProperty;
    public static final int STYLE_CHANGED_EVENT = 1;

    public HeadStyleAttributeComposite(Composite parent, int style, LineDecorator laCurrent, EObject eParent, String sProperty, ChartWizardContext context) {
        super(parent, style);
        this.laCurrent = laCurrent;
        this.eParent = eParent;
        this.sProperty = sProperty;
        this.context = context;
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        GridLayout glContent = new GridLayout();
        glContent.verticalSpacing = 5;
        glContent.horizontalSpacing = 5;
        glContent.marginHeight = 4;
        glContent.marginWidth = 4;
        glContent.numColumns = 6;
        this.setLayout((Layout)flMain);
        this.cmpContent = new Composite((Composite)this, 0);
        this.cmpContent.setLayout((Layout)glContent);
        this.lblHeadStyle = new Label(this.cmpContent, 0);
        GridData gdLHeadStyle = new GridData(32);
        this.lblHeadStyle.setLayoutData((Object)gdLHeadStyle);
        this.lblHeadStyle.setText(Messages.getString("HeadStyleAttributeComposite.Lbl.HeadStyle"));
        this.cmbHeadStyle = this.context.getUIFactory().createHeadStyleChooserComposite(this.cmpContent, 12, this.laCurrent.getValue(), this.eParent, this.sProperty);
        GridData gdCBHeadStyle = new GridData(768);
        gdCBHeadStyle.horizontalSpan = 5;
        this.cmbHeadStyle.setLayoutData((Object)gdCBHeadStyle);
        this.cmbHeadStyle.addListener(1, (Listener)this);
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    public void setLineDecorator(LineDecorator attributes) {
        this.laCurrent = attributes;
        if (this.laCurrent == null) {
            this.cmbHeadStyle.setHeadStyle(0);
        } else {
            this.cmbHeadStyle.setHeadStyle(attributes.getValue());
        }
        this.redraw();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void fireValueChangedEvent(int iEventType, Object data) {
        int iL = 0;
        while (iL < this.vListeners.size()) {
            Event se = new Event();
            se.widget = this;
            se.data = data;
            se.type = iEventType;
            se.detail = data == null ? ChartUIExtensionUtil.PROPERTY_UNSET : ChartUIExtensionUtil.PROPERTY_UPDATE;
            this.vListeners.get(iL).handleEvent(se);
            ++iL;
        }
    }

    private LineDecorator getModelHeadStyle(int iStyle) {
        switch (iStyle) {
            case 0: {
                return LineDecorator.ARROW_LITERAL;
            }
            case 1: {
                return LineDecorator.CIRCLE_LITERAL;
            }
            case 2: {
                return LineDecorator.NONE_LITERAL;
            }
        }
        return null;
    }

    public void handleEvent(Event event) {
        if (this.cmbHeadStyle != null && this.cmbHeadStyle.equals(event.widget)) {
            this.fireValueChangedEvent(1, this.getModelHeadStyle(this.cmbHeadStyle.getHeadStyle()));
        }
    }
}

