/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.olap;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.ICubeModel;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.Measure;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public abstract class CubeHandle
extends ReportElementHandle
implements ICubeModel {
    public CubeHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public DimensionHandle getDimension(String dimensionName, boolean needLevelForTimeDimension) {
        return this.getDimension(dimensionName);
    }

    public DimensionHandle getDimension(String dimensionName) {
        if (StringUtil.isBlank(dimensionName)) {
            return null;
        }
        if (!this.getElement().canDynamicExtends()) {
            Dimension dimension = this.module.findDimension(dimensionName);
            if (dimension == null) {
                return null;
            }
            if (dimension.isContentOf(this.getElement())) {
                return (DimensionHandle)dimension.getHandle(this.module);
            }
            List<BackRef> clients = dimension.getClientList();
            if (clients != null) {
                for (BackRef ref : clients) {
                    DesignElement client = ref.getElement();
                    if (!client.isContentOf(this.getElement())) continue;
                    return (DimensionHandle)client.getHandle(this.module);
                }
            }
        } else if (this.getElement().getDynamicExtendsElement(this.getModule()) != null) {
            Cube cube = (Cube)this.getElement();
            DesignElement element = cube.findLocalElement(dimensionName, MetaDataDictionary.getInstance().getElement("Dimension"));
            return (DimensionHandle)(element == null ? null : element.getHandle(this.module));
        }
        return null;
    }

    public DimensionHandle getLocalDimension(String dimensionName) {
        DesignElement dimension = this.module.findDimension(dimensionName);
        if (dimension != null && dimension.isContentOf(this.getElement())) {
            return (DimensionHandle)dimension.getHandle(this.module);
        }
        CubeHandle parent = (CubeHandle)this.getExtends();
        if (parent == null) {
            return null;
        }
        dimension = this.doGetLocalDimension(dimensionName, (Cube)parent.element, parent.module);
        if (dimension == null) {
            return null;
        }
        return (DimensionHandle)dimension.getHandle(this.module);
    }

    protected DesignElement doGetLocalDimension(String dimensionName, Cube parent, Module parentModule) {
        Dimension dimension = parentModule.findDimension(dimensionName);
        if (dimension == null) {
            return null;
        }
        int index = dimension.getIndex(parentModule);
        assert (index != -1);
        List dims = (List)this.getElement().getProperty(this.module, "dimensions");
        return (DesignElement)dims.get(index);
    }

    public MeasureHandle getMeasure(String measureName) {
        if (StringUtil.isBlank(measureName)) {
            return null;
        }
        if (!this.getElement().canDynamicExtends()) {
            DesignElement measure = this.module.findOLAPElement(measureName);
            if (measure instanceof Measure && measure.isContentOf(this.getElement())) {
                return (MeasureHandle)measure.getHandle(this.module);
            }
        } else if (this.getElement().getDynamicExtendsElement(this.getModule()) != null) {
            Cube cube = (Cube)this.getElement();
            DesignElement element = cube.findLocalElement(measureName, MetaDataDictionary.getInstance().getElement("Measure"));
            return (MeasureHandle)(element == null ? null : element.getHandle(this.module));
        }
        return null;
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    @Deprecated
    public MeasureGroupHandle getDefaultMeasureGroup() {
        return null;
    }

    @Deprecated
    public void setDefaultMeasureGroup(MeasureGroupHandle defaultMeasureGroup) throws SemanticException {
    }

    public Iterator accessControlsIterator() {
        return Collections.emptyList().iterator();
    }

    public void addFilter(FilterCondition fc) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        propHandle.addItem(fc);
    }

    public void removeFilter(FilterCondition fc) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        propHandle.removeItem(fc);
    }

    public ExpressionHandle getACLExpression() {
        return this.getExpressionProperty("ACLExpression");
    }
}

