/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.providers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.TreeData;
import org.eclipse.birt.data.oda.pojo.util.ClassParser;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ClassTreeContentProvider
implements ITreeContentProvider {
    private String[] chainItems;
    private ClassParser cp;

    public ClassTreeContentProvider(String[] chainItems, ClassLoader cl) {
        this.chainItems = chainItems;
        this.cp = new ClassParser(cl);
    }

    public Object[] getChildren(Object arg0) {
        if (arg0 instanceof TreeData) {
            TreeData td = (TreeData)arg0;
            int level = td.getLevel();
            String filter = this.getFilterString(level);
            Object obj = td.getWrappedObject();
            ++level;
            if (obj instanceof ClassWrapper) {
                Object[] members = ClassParser.getPublicMembers((Class)((ClassWrapper)obj).getWrappedClass(), (String)filter);
                return this.createTreeDataArray(members, level);
            }
            if (obj instanceof Field) {
                return this.createTreeDataArray(this.cp.getPublicMembers((Field)obj, filter), level);
            }
            if (obj instanceof Method) {
                return this.createTreeDataArray(this.cp.getPublicMembers((Method)obj, filter), level);
            }
        }
        return new Object[0];
    }

    private TreeData[] createTreeDataArray(Object[] members, int level) {
        TreeData[] items = new TreeData[members.length];
        int i = 0;
        while (i < items.length) {
            items[i] = new TreeData(members[i], level);
            ++i;
        }
        return items;
    }

    private String getFilterString(int level) {
        return this.chainItems != null && this.chainItems.length > level ? this.chainItems[level].trim() : null;
    }

    public Object getParent(Object arg0) {
        return null;
    }

    public boolean hasChildren(Object arg0) {
        if (arg0 instanceof TreeData) {
            Object obj = ((TreeData)arg0).getWrappedObject();
            if (obj instanceof ClassWrapper) {
                return ClassParser.getPublicMembers((Class)((ClassWrapper)obj).getWrappedClass(), null).length > 0;
            }
            if (obj instanceof Field) {
                return this.cp.getPublicMembers((Field)obj, null).length > 0;
            }
            if (obj instanceof Method) {
                return this.cp.getPublicMembers((Method)obj, null).length > 0;
            }
        }
        return false;
    }

    public Object[] getElements(Object arg0) {
        if (arg0 instanceof TreeData) {
            Object obj = ((TreeData)arg0).getWrappedObject();
            if (obj instanceof Class) {
                return new Object[]{new TreeData(new ClassWrapper((Class)obj), 0)};
            }
            if (obj instanceof String) {
                return new Object[]{obj};
            }
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }

    public static class ClassWrapper {
        private Class c;

        public ClassWrapper(Class c) {
            this.c = c;
        }

        public Class getWrappedClass() {
            return this.c;
        }
    }
}

