/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.svg;

import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.AbstractEventChain;
import org.eclipse.app4mc.amalthea.visualizations.svg.AbstractVisualization;
import org.eclipse.app4mc.amalthea.visualizations.svg.Context;
import org.eclipse.app4mc.amalthea.visualizations.svg.EventChainMapConfig;
import org.eclipse.app4mc.amalthea.visualizations.svg.EventChainMapGenerator;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.app4mc.visualization.util.svg.AbstractDiagram;
import org.eclipse.app4mc.visualization.util.svg.PlantUmlDiagram;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Eventchain Map", "description=Map Visualization for Eventchains"})
public class EventChainMapVisualization
extends AbstractVisualization
implements Visualization {
    @PostConstruct
    public void createVisualization(AbstractEventChain eventChain, VisualizationParameters parameters, Composite parent, IEventBroker broker) {
        EventChainMapConfig config = new EventChainMapConfig(parameters);
        Context context = this.createContext(eventChain, config);
        Composite pane = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(pane);
        Composite buttonArea = new Composite(pane, 0);
        this.addToggleButton(buttonArea, "Show All Event", "Also show events (stimulus and response) of parent chains", config::setShowAllEvents, config.isShowAllEvents());
        this.addToggleButton(buttonArea, "Show Links", "Show links to model elements", config::setShowLinks, config.isShowLinks());
        this.addToggleButton(buttonArea, "Expand Subchain References", null, config::setExpandSubchainReferences, config.isExpandSubchainReferences());
        this.addToggleButton(buttonArea, "Gray out repeating events", null, config::setShowRepeatingEventsGrayed, config.isShowRepeatingEventsGrayed());
        this.addZoomBox(buttonArea, context.config);
        RowLayoutFactory.swtDefaults().fill(true).applyTo(buttonArea);
        Browser browser = this.addBrowser(pane, broker, context);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)browser);
        this.updateBrowserContent(browser, context);
    }

    private Context createContext(AbstractEventChain eventChain, EventChainMapConfig config) {
        return new Context(eventChain, config, (AbstractDiagram)new PlantUmlDiagram());
    }

    @Override
    protected void updateDiagram(Context context) {
        EventChainMapGenerator.updateDiagram(context);
    }
}

