/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters090.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters090.utils.HWCacheBuilder;
import org.eclipse.app4mc.amalthea.converters090.utils.HWTransformationCache;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.3", "output_model_version=0.9.0"}, service={IConverter.class})
public class HwReferencesConverter
extends AbstractConverter {
    private static final String XSI = "xsi";
    private static final String HREF = "href";
    private static final String TYPE = "type";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String AMLT_PREFIX = "amlt:/#";
    private static final String MEMORY = "memory";
    private static final String MEMORIES = "memories";
    private static final String CORES = "cores";
    private static final String CORE_AFFINITY = "coreAffinity";
    private static final String CONSTRAINTS_MODEL = "constraintsModel";
    private static final String MAPPING_MODEL = "mappingModel";
    private static final String INSTRUCTIONS = "Instructions";
    private static final String HARDWARE_CONTEXT = "hardwareContext";
    private static final String RESPONSIBILITY = "responsibility";
    private static final String EXECUTING_CORE = "executingCore";
    private static final String TYPE_PROCESSING_UNIT = "?type=ProcessingUnit";
    private static final String TYPE_MEMORY = "?type=Memory";
    private static final String WARNING_MEMORY_IS_NO_LONGER_A_VALID_TARGET_ELEMENT = "In 0.8.3, Memory : \"{0}\" referred in AffinityConstraint is no longer a valid Target element.\n -- As in 0.9.0 -> this Memory element is transformed to Cache ";
    @Reference
    SessionLogger logger;
    private HWTransformationCache hwTransformationCache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from 0.8.3 to 0.9.0 : Executing HW references converter for model file : {0}", new Object[]{targetFile.getName()});
        this.hwTransformationCache = this.getHWTransformationCache(caches);
        Document root = fileDocumentMapping.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateReferencesInModel(rootElement);
    }

    private void updateReferencesInModel(Element rootElement) {
        this.migrateTargetMemory(rootElement);
        this.migratePhysicalSectionConstraint(rootElement);
        this.migrateMemoryMapping(rootElement);
        this.migratePhysicalSectionMapping(rootElement);
        this.migrateTargetCore(rootElement);
        this.migrateEvents(rootElement);
        this.migrateSchedulerAllocation(rootElement);
        this.migrateTaskAllocation(rootElement);
        this.migrateRunnableInstructionsEntry(rootElement);
        this.migrateCPUPercentageRequirementLimit(rootElement);
    }

    private void migrateRunnableInstructionsEntry(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables//*[@xsi:type=\"am:RunnableInstructions\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/computationItems[@xsi:type=\"am:RunnableInstructions\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/computationItems[@xsi:type=\"am:RunnableInstructions\"]");
        List runnableInstructionsEntries = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        if (!runnableInstructionsEntries.isEmpty() && !this.hwTransformationCache.getNewFeatureCategoriesMap().containsKey(INSTRUCTIONS)) {
            this.checkAndCreateHWFeatureCategory(rootElement);
        }
        for (Element runnableInstruction : runnableInstructionsEntries) {
            Element parentElementOfRunnableInstruction = runnableInstruction.getParentElement();
            String tagName = runnableInstruction.getName();
            int indexOfRunnableInstructions = parentElementOfRunnableInstruction.indexOf((Content)runnableInstruction);
            Element executionNeedElement = new Element(tagName);
            executionNeedElement.setAttribute(TYPE, "am:ExecutionNeed", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            this.migrateValueOfRunnableInstructions(runnableInstruction, executionNeedElement, "default");
            List oldExtendedElements = runnableInstruction.getChildren("extended");
            for (Element oldExtendedElement : oldExtendedElements) {
                Element newExtendedSubElement = new Element("extended");
                Map coresMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)KEY, (Element)oldExtendedElement);
                for (String coreName : coresMap.keySet()) {
                    Element puReference = new Element(KEY);
                    puReference.setAttribute(HREF, AMLT_PREFIX + HelperUtil.encodeNameForReference((String)coreName) + "?type=ProcessingUnitDefinition");
                    newExtendedSubElement.addContent((Content)puReference);
                }
                this.migrateValueOfRunnableInstructions(oldExtendedElement, newExtendedSubElement, VALUE);
                executionNeedElement.addContent((Content)newExtendedSubElement);
            }
            parentElementOfRunnableInstruction.addContent(indexOfRunnableInstructions, (Content)executionNeedElement);
            runnableInstruction.detach();
        }
    }

    private void checkAndCreateHWFeatureCategory(Element rootElement) {
        Element hwModelEleemnt = rootElement.getChild("hwModel");
        if (hwModelEleemnt == null) {
            hwModelEleemnt = new Element("hwModel");
            rootElement.addContent((Content)hwModelEleemnt);
        }
        Element featureCategoriesElement = new Element("featureCategories");
        featureCategoriesElement.setAttribute("name", INSTRUCTIONS);
        featureCategoriesElement.setAttribute("featureType", "performance");
        hwModelEleemnt.addContent((Content)featureCategoriesElement);
    }

    private void migrateValueOfRunnableInstructions(Element runnableInstruction, Element executionNeedElement, String valueTagName) {
        String oldDefaultType;
        Element oldDefaultElement = runnableInstruction.getChild(valueTagName);
        if (oldDefaultElement != null && (oldDefaultType = oldDefaultElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI))) != null) {
            if ("am:InstructionsConstant".equals(oldDefaultType)) {
                String oldDefaultValue = oldDefaultElement.getAttributeValue(VALUE);
                if (oldDefaultValue != null) {
                    Element newDefaultSubElement = new Element(valueTagName);
                    newDefaultSubElement.setAttribute(KEY, INSTRUCTIONS);
                    Element newValueElement = new Element(VALUE);
                    newValueElement.setAttribute(TYPE, "am:NeedConstant", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                    newValueElement.setAttribute(VALUE, oldDefaultValue);
                    newDefaultSubElement.addContent((Content)newValueElement);
                    executionNeedElement.addContent((Content)newDefaultSubElement);
                }
            } else if ("am:InstructionsDeviation".equals(oldDefaultType)) {
                Element newDefaultSubElement = new Element(valueTagName);
                if ("default".equals(valueTagName)) {
                    newDefaultSubElement.setAttribute(KEY, INSTRUCTIONS);
                } else {
                    newDefaultSubElement.setAttribute(new Attribute(KEY, INSTRUCTIONS));
                }
                Element newValueElement = new Element(VALUE);
                newValueElement.setAttribute(TYPE, "am:NeedDeviation", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                Element oldDeviationElement = oldDefaultElement.getChild("deviation");
                if (oldDeviationElement != null) {
                    Element newDeviationElement = oldDeviationElement.clone();
                    newDeviationElement.detach();
                    newValueElement.addContent((Content)newDeviationElement);
                }
                newDefaultSubElement.addContent((Content)newValueElement);
                executionNeedElement.addContent((Content)newDefaultSubElement);
            }
        }
    }

    private void migrateEvents(Element rootElement) {
        Element eventModel = rootElement.getChild("eventModel");
        if (eventModel == null) {
            return;
        }
        List events = eventModel.getChildren("events");
        for (Element event : events) {
            Map coresMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)"core", (Element)event);
            event.removeChildren("core");
            event.removeAttribute("core");
            for (String coreName : coresMap.keySet()) {
                Element memoryElement = new Element("processingUnit");
                memoryElement.setAttribute(HREF, AMLT_PREFIX + HelperUtil.encodeNameForReference((String)coreName) + TYPE_PROCESSING_UNIT);
                event.addContent((Content)memoryElement);
            }
        }
    }

    private void migrateTaskAllocation(Element rootElement) {
        Element mappingModel = rootElement.getChild(MAPPING_MODEL);
        if (mappingModel == null) {
            return;
        }
        List taskAllocations = mappingModel.getChildren("taskAllocation");
        for (Element taskAllocation : taskAllocations) {
            Map coresMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)CORE_AFFINITY, (Element)taskAllocation);
            taskAllocation.removeChildren(CORE_AFFINITY);
            taskAllocation.removeAttribute(CORE_AFFINITY);
            for (String coreName : coresMap.keySet()) {
                Element processingUnitElement = new Element("affinity");
                processingUnitElement.setAttribute(HREF, AMLT_PREFIX + HelperUtil.encodeNameForReference((String)coreName) + TYPE_PROCESSING_UNIT);
                taskAllocation.addContent((Content)processingUnitElement);
            }
        }
    }

    private void migrateSchedulerAllocation(Element rootElement) {
        Element mappingModel = rootElement.getChild(MAPPING_MODEL);
        if (mappingModel == null) {
            return;
        }
        List schedulerAllocations = mappingModel.getChildren("schedulerAllocation");
        for (Element schedulerAllocation : schedulerAllocations) {
            Element memoryElement;
            Map coresMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)RESPONSIBILITY, (Element)schedulerAllocation);
            schedulerAllocation.removeChildren(RESPONSIBILITY);
            schedulerAllocation.removeAttribute(RESPONSIBILITY);
            for (String coreName : coresMap.keySet()) {
                memoryElement = new Element(RESPONSIBILITY);
                memoryElement.setAttribute(HREF, AMLT_PREFIX + coreName + TYPE_PROCESSING_UNIT);
                schedulerAllocation.addContent((Content)memoryElement);
            }
            coresMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)EXECUTING_CORE, (Element)schedulerAllocation);
            schedulerAllocation.removeChildren(EXECUTING_CORE);
            schedulerAllocation.removeAttribute(EXECUTING_CORE);
            for (String coreName : coresMap.keySet()) {
                memoryElement = new Element("executingPU");
                memoryElement.setAttribute(HREF, AMLT_PREFIX + coreName + TYPE_PROCESSING_UNIT);
                schedulerAllocation.addContent((Content)memoryElement);
            }
        }
    }

    private void migratePhysicalSectionMapping(Element rootElement) {
        Element mappingModel = rootElement.getChild(MAPPING_MODEL);
        if (mappingModel == null) {
            return;
        }
        List physicalSectionMappings = mappingModel.getChildren("physicalSectionMapping");
        for (Element physicalSectionMapping : physicalSectionMappings) {
            Map memoriesMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)MEMORY, (Element)physicalSectionMapping);
            physicalSectionMapping.removeChildren(MEMORY);
            physicalSectionMapping.removeAttribute(MEMORY);
            for (String memoryName : memoriesMap.keySet()) {
                if (this.hwTransformationCache.getNewMemoriesMap().containsKey(memoryName)) {
                    Element memoryElement = new Element(MEMORY);
                    memoryElement.setAttribute(HREF, AMLT_PREFIX + memoryName + TYPE_MEMORY);
                    physicalSectionMapping.addContent((Content)memoryElement);
                    continue;
                }
                if (!this.hwTransformationCache.getNewCachesMap().containsKey(memoryName)) continue;
                this.logger.warn(WARNING_MEMORY_IS_NO_LONGER_A_VALID_TARGET_ELEMENT, new Object[]{memoryName});
            }
        }
    }

    private void migrateMemoryMapping(Element rootElement) {
        Element mappingModel = rootElement.getChild(MAPPING_MODEL);
        if (mappingModel == null) {
            return;
        }
        List memoryMappings = mappingModel.getChildren("memoryMapping");
        for (Element memroyMapping : memoryMappings) {
            Map memoriesMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)MEMORY, (Element)memroyMapping);
            memroyMapping.removeChildren(MEMORY);
            memroyMapping.removeAttribute(MEMORY);
            for (String memoryName : memoriesMap.keySet()) {
                if (this.hwTransformationCache.getNewMemoriesMap().containsKey(memoryName)) {
                    Element memoryElement = new Element(MEMORY);
                    memoryElement.setAttribute(HREF, AMLT_PREFIX + memoryName + TYPE_MEMORY);
                    memroyMapping.addContent((Content)memoryElement);
                    continue;
                }
                if (!this.hwTransformationCache.getNewCachesMap().containsKey(memoryName)) continue;
                this.logger.warn(WARNING_MEMORY_IS_NO_LONGER_A_VALID_TARGET_ELEMENT, new Object[]{memoryName});
            }
        }
    }

    private void migratePhysicalSectionConstraint(Element rootElement) {
        Element constraintsModel = rootElement.getChild(CONSTRAINTS_MODEL);
        if (constraintsModel == null) {
            return;
        }
        List physicalSectionConstraints = constraintsModel.getChildren("physicalSectionConstraints");
        for (Element physicalSectionContraint : physicalSectionConstraints) {
            Map memoriesMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)MEMORIES, (Element)physicalSectionContraint);
            physicalSectionContraint.removeChildren(MEMORIES);
            physicalSectionContraint.removeAttribute(MEMORIES);
            for (String memoryName : memoriesMap.keySet()) {
                if (this.hwTransformationCache.getNewMemoriesMap().containsKey(memoryName)) {
                    Element memoryElement = new Element(MEMORIES);
                    memoryElement.setAttribute(HREF, AMLT_PREFIX + memoryName + TYPE_MEMORY);
                    physicalSectionContraint.addContent((Content)memoryElement);
                    continue;
                }
                if (!this.hwTransformationCache.getNewCachesMap().containsKey(memoryName)) continue;
                this.logger.warn(WARNING_MEMORY_IS_NO_LONGER_A_VALID_TARGET_ELEMENT, new Object[]{memoryName});
            }
        }
    }

    private void migrateCPUPercentageRequirementLimit(Element rootElement) {
        Element constraintsModel = rootElement.getChild(CONSTRAINTS_MODEL);
        if (constraintsModel == null) {
            return;
        }
        List requirements = constraintsModel.getChildren("requirements");
        for (Element requirement : requirements) {
            List limitElements = requirement.getChildren("limit");
            for (Element limitElement : limitElements) {
                String limitElementType = limitElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                if (limitElementType == null || !"am:CPUPercentageRequirementLimit".equals(limitElementType)) continue;
                Map complexNodesMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)HARDWARE_CONTEXT, (Element)limitElement);
                limitElement.removeChildren(HARDWARE_CONTEXT);
                limitElement.removeAttribute(HARDWARE_CONTEXT);
                for (Map.Entry entry : complexNodesMap.entrySet()) {
                    String complexNodeName = (String)entry.getKey();
                    String complexNodeType = (String)entry.getValue();
                    if (complexNodeType != null && "Core".equals(complexNodeType)) {
                        Element puElement = new Element(HARDWARE_CONTEXT);
                        puElement.setAttribute(HREF, AMLT_PREFIX + complexNodeName + TYPE_PROCESSING_UNIT);
                        limitElement.addContent((Content)puElement);
                        continue;
                    }
                    this.logger.warn("As per 0.9.0 : Only ProcessingUnit element can be referred inside CPUPercentageRequirementLimit as a hardwareContext.\r\n Reference of : {0} of type : {1} is removed : as it is not valid as per 0.9.0", new Object[]{complexNodeName, complexNodeType});
                }
            }
        }
    }

    private void migrateTargetMemory(Element rootElement) {
        Element constraintsModel = rootElement.getChild(CONSTRAINTS_MODEL);
        if (constraintsModel == null) {
            return;
        }
        List affinityConstraints = constraintsModel.getChildren("affinityConstraints");
        for (Element affinityConstraint : affinityConstraints) {
            List targetMemories = affinityConstraint.getChildren("target");
            for (Element targetMemory : targetMemories) {
                String elementType = targetMemory.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                if (elementType == null || !"am:TargetMemory".equals(elementType)) continue;
                Map memoriesMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)MEMORIES, (Element)targetMemory);
                targetMemory.removeChildren(MEMORIES);
                targetMemory.removeAttribute(MEMORIES);
                for (String memoryName : memoriesMap.keySet()) {
                    if (this.hwTransformationCache.getNewMemoriesMap().containsKey(memoryName)) {
                        Element memoryElement = new Element(MEMORIES);
                        memoryElement.setAttribute(HREF, AMLT_PREFIX + memoryName + TYPE_MEMORY);
                        targetMemory.addContent((Content)memoryElement);
                        continue;
                    }
                    if (!this.hwTransformationCache.getNewCachesMap().containsKey(memoryName)) continue;
                    this.logger.warn(WARNING_MEMORY_IS_NO_LONGER_A_VALID_TARGET_ELEMENT, new Object[]{memoryName});
                }
            }
        }
    }

    private void migrateTargetCore(Element rootElement) {
        Element constraintsModel = rootElement.getChild(CONSTRAINTS_MODEL);
        if (constraintsModel == null) {
            return;
        }
        List affinityConstraints = constraintsModel.getChildren("affinityConstraints");
        for (Element affinityConstraint : affinityConstraints) {
            List targetCores = affinityConstraint.getChildren("target");
            for (Element targetCore : targetCores) {
                Map coresMap = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)CORES, (Element)targetCore);
                targetCore.removeChildren(CORES);
                targetCore.removeAttribute(CORES);
                for (String coreName : coresMap.keySet()) {
                    Element memoryElement = new Element(CORES);
                    memoryElement.setAttribute(HREF, AMLT_PREFIX + coreName + TYPE_PROCESSING_UNIT);
                    targetCore.addContent((Content)memoryElement);
                }
            }
        }
    }

    private HWTransformationCache getHWTransformationCache(List<ICache> caches) {
        if (caches == null) {
            return null;
        }
        for (ICache cache : caches) {
            Map map;
            Map cacheMap;
            if (!(cache instanceof HWCacheBuilder) || (cacheMap = cache.getCacheMap()) == null || cacheMap.isEmpty() || (map = (Map)cacheMap.values().iterator().next()) == null) continue;
            Object object = map.get("globalCache");
            return (HWTransformationCache)object;
        }
        return new HWTransformationCache();
    }
}

