/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.contribution.handler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea.model.editor.contribution.handler.ChangeCommandWithStatusResult;
import org.eclipse.app4mc.amalthea.model.editor.contribution.registry.ProcessingServiceRegistry;
import org.eclipse.app4mc.amalthea.model.editor.contribution.registry.RegistryServiceWrapper;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class ProcessModelStructureHandler {
    @Execute
    public void execute(Shell shell, @Named(value="app4mc.creator.model") @Named(value="app4mc.creator.model") String modelType, @Named(value="app4mc.creator.id") @Named(value="app4mc.creator.id") String creatorId, @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, @Service ProcessingServiceRegistry registry, IEclipseContext context) {
        RegistryServiceWrapper serviceWrapper = registry.getService(modelType, creatorId);
        if (serviceWrapper == null) {
            return;
        }
        List<EObject> objects = this.getModelObjects(selection);
        if (!objects.isEmpty()) {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)objects.get(0));
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)rootContainer);
            ChangeCommandWithStatusResult command = new ChangeCommandWithStatusResult((Notifier)rootContainer, context, String.valueOf(modelType) + " ProcessingModelStructure", serviceWrapper, objects);
            String[] split = serviceWrapper.getName().split("\\|");
            command.setLabel(split[split.length - 1].trim());
            editingDomain.getCommandStack().execute(command);
            if (command.status != null) {
                MessageDialog.openInformation((Shell)shell, (String)"AMALTHEA Model Processing", (String)command.status.toString());
            }
        }
    }

    private List<EObject> getModelObjects(IStructuredSelection selection) {
        if (selection == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(selection.toArray()).filter(EObject.class::isInstance).map(EObject.class::cast).collect(Collectors.toList());
    }
}

