/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.edit.os.container.OsDefinitionContainerIP;
import org.eclipse.app4mc.amalthea.model.edit.os.container.OsSemaphoreContainerIP;
import org.eclipse.app4mc.amalthea.model.provider.OSModelItemProvider;
import org.eclipse.app4mc.amalthea.model.provider.TransientItemProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ExtendedOSModelIP
extends OSModelItemProvider {
    private static final Set<EStructuralFeature> SPECIAL_FEATURES = Set.of(AmaltheaPackage.eINSTANCE.getOSModel_SchedulerDefinitions(), AmaltheaPackage.eINSTANCE.getOSModel_SchedulingParameterDefinitions(), AmaltheaPackage.eINSTANCE.getOSModel_OsOverheads(), AmaltheaPackage.eINSTANCE.getOSModel_Semaphores());
    private static final Set<Integer> SPECIAL_FEATURE_IDS = SPECIAL_FEATURES.stream().mapToInt(EStructuralFeature::getFeatureID).boxed().collect(Collectors.toCollection(HashSet::new));
    protected OsDefinitionContainerIP osDefinitionCIP;
    protected OsSemaphoreContainerIP osSemaphoreCIP;

    public ExtendedOSModelIP(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public OsDefinitionContainerIP getOsDefinitionsContainerIP(OSModel osModel) {
        if (this.osDefinitionCIP == null) {
            this.osDefinitionCIP = new OsDefinitionContainerIP(this.adapterFactory, osModel);
        }
        return this.osDefinitionCIP;
    }

    public OsSemaphoreContainerIP getOsSemaphoresContainerIP(OSModel osModel) {
        if (this.osSemaphoreCIP == null) {
            this.osSemaphoreCIP = new OsSemaphoreContainerIP(this.adapterFactory, osModel);
        }
        return this.osSemaphoreCIP;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        for (EStructuralFeature feature : super.getChildrenFeatures(object)) {
            if (!this.isValidValue(object, child, feature)) continue;
            return feature;
        }
        return null;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        HashSet result = new HashSet(super.getChildrenFeatures(object));
        result.removeAll(SPECIAL_FEATURES);
        return result;
    }

    public Collection<?> getChildren(Object object) {
        ArrayList<TransientItemProvider> children = new ArrayList<TransientItemProvider>(super.getChildren(object));
        OSModel osModel = (OSModel)object;
        if (!osModel.getSemaphores().isEmpty()) {
            children.add(0, this.getOsSemaphoresContainerIP(osModel));
        }
        if (!(osModel.getSchedulerDefinitions().isEmpty() && osModel.getSchedulingParameterDefinitions().isEmpty() && osModel.getOsOverheads().isEmpty())) {
            children.add(0, this.getOsDefinitionsContainerIP(osModel));
        }
        return children;
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return this.createWrappedCommand(super.createAddCommand(domain, owner, feature, collection, index), owner, feature);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        return this.createWrappedCommand(super.createRemoveCommand(domain, owner, feature, collection), owner, feature);
    }

    protected Command createWrappedCommand(Command command, final EObject owner, EStructuralFeature feature) {
        final int featureID = feature.getFeatureID();
        if (!SPECIAL_FEATURE_IDS.contains(featureID)) {
            return command;
        }
        return new CommandWrapper(command){

            public Collection<?> getAffectedObjects() {
                Set<TransientItemProvider> affected = super.getAffectedObjects();
                if (affected.contains(owner)) {
                    if (featureID == 1) {
                        affected = Collections.singleton(ExtendedOSModelIP.this.getOsSemaphoresContainerIP((OSModel)owner));
                    } else if (featureID == 4 || featureID == 5 || featureID == 3) {
                        affected = Collections.singleton(ExtendedOSModelIP.this.getOsDefinitionsContainerIP((OSModel)owner));
                    }
                }
                return affected;
            }
        };
    }

    public void dispose() {
        if (this.osDefinitionCIP != null) {
            this.osDefinitionCIP.dispose();
        }
        if (this.osSemaphoreCIP != null) {
            this.osSemaphoreCIP.dispose();
        }
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        int featureID = notification.getFeatureID(HWModel.class);
        if (SPECIAL_FEATURE_IDS.contains(featureID)) {
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
        } else {
            super.notifyChanged(notification);
        }
    }
}

