/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters100.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.9", "output_model_version=1.0.0"}, service={IConverter.class})
public class MeasurementModelConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from {0} to {1} : Executing MeasurementModel converter for model file : {2}", new Object[]{this.getInputModelVersion(), this.getOutputModelVersion(), targetFile.getName()});
        this.basicConvert(targetFile, fileDocumentMapping);
    }

    private void basicConvert(File file, Map<File, Document> map) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.removeMeasurementModel(rootElement);
    }

    private void removeMeasurementModel(Element rootElement) {
        Namespace am = AmaltheaNamespaceRegistry.getNamespace((String)this.getInputModelVersion(), (String)"am");
        Namespace xsi = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
        String xpathStr = "./measurementModel";
        List models = HelperUtil.getXpathResult((Element)rootElement, (String)"./measurementModel", Element.class, (Namespace[])new Namespace[]{am, xsi});
        if (models == null) {
            return;
        }
        for (Element m : models) {
            this.logger.warn("Measurement Model has been removed. It is no longer supported in version {0}.", new Object[]{this.getOutputModelVersion()});
            rootElement.removeContent((Content)m);
        }
    }
}

