/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.eclipse.app4mc.atdb.DBConnection;
import org.eclipse.app4mc.atdb.EntityProperty;
import org.eclipse.app4mc.atdb.EntityType;
import org.eclipse.app4mc.atdb.MetaInformation;
import org.eclipse.app4mc.atdb.MetricAggregation;

public class ATDBConnection
extends DBConnection<ATDBConnection> {
    private static final String EC = "EC";
    private static final String METAINFORMATION_QUERY = "SELECT value FROM metaInformation WHERE name = ?;";
    private static final String ENTITY_BY_TYPE_QUERY = "SELECT name FROM entity WHERE entityTypeId = (SELECT id FROM entityType WHERE entityType.name = ?);";
    private static final String ENTITY_INSTANCES_QUERY = "SELECT sqcnr FROM entityInstance WHERE entityId = (SELECT id FROM entity WHERE name = ?);";
    private static final String EVENTS_QUERY = "SELECT event.name FROM event;";
    private static final String EVENT_BY_TYPE_QUERY = String.valueOf("SELECT event.name FROM event;".substring(0, "SELECT event.name FROM event;".length() - 1)) + " WHERE eventTypeId = (SELECT id FROM eventType WHERE eventType.name = ?);";
    private static final String EVENT_BY_ENTITY_TYPE_QUERY = String.valueOf("SELECT event.name FROM event;".substring(0, "SELECT event.name FROM event;".length() - 1)) + ", entity " + "WHERE event.entityId = entity.id AND entity.entityTypeId = (SELECT id FROM entityType WHERE entityType.name = ?);";
    private static final String EVENT_TYPE_OF_EVENT_QUERY = "SELECT eventType.name FROM event, eventType WHERE event.eventTypeId = eventType.id AND event.name = ?;";
    private static final String ENTITY_OF_EVENT_QUERY = "SELECT entity.name FROM event, entity WHERE event.entityId = entity.id AND event.name = ?;";
    private static final String SOURCE_ENTITY_OF_EVENT_QUERY = "SELECT entity.name FROM event, entity WHERE event.sourceEntityId = entity.id AND event.name = ?;";
    private static final String ENTITY_PROPERTY_ENTITYREF_QUERY = "SELECT (SELECT name FROM entity WHERE id = value) AS entities FROM entity AS sourceEntity, propertyValue WHERE sourceEntity.name = ? AND entityTypeId = (SELECT id FROM entityType WHERE entityType.name = ?) AND propertyValue.entityId = sourceEntity.id AND propertyValue.propertyId = (SELECT id FROM property WHERE name = ?);";
    private static final String ENTITY_PROPERTY_VALUE_QUERY = "SELECT propertyValue.value FROM entity AS sourceEntity, propertyValue WHERE sourceEntity.name = ? AND entityTypeId = (SELECT id FROM entityType WHERE entityType.name = ?) AND propertyValue.entityId = sourceEntity.id AND propertyValue.propertyId = (SELECT id FROM property WHERE name = ?);";
    private static final String EVENTCHAIN_EVENTREF_QUERY = "SELECT (SELECT GROUP_CONCAT((SELECT name FROM event WHERE id = value), ', ') FROM propertyValue WHERE entityId = ecEntity.id AND propertyId = (SELECT id FROM property WHERE name = ?)) AS evName FROM entity AS ecEntity WHERE ecEntity.name = ? AND entityTypeId = (SELECT id FROM entityType WHERE entityType.name = 'EC');";
    private static final String METRICS_QUERY = "SELECT name FROM metric;";
    private static final String METRICVALUE_QUERY = "SELECT value FROM entityMetricValue WHERE entityId = (SELECT id FROM entity WHERE name = ?) AND metricId = (SELECT id FROM metric WHERE name = ?);";
    private static final String METAINFORMATION_INSERT = "INSERT OR IGNORE INTO metaInformation VALUES(?, ?);";
    private static final String ENTITYTYPE_INSERT = "INSERT OR IGNORE INTO entityType(name) VALUES(?);";
    private static final String ENTITY_INSERT = "INSERT OR IGNORE INTO entity(name, entityTypeId) VALUES(?, (SELECT id FROM entityType WHERE name = ?));";
    private static final String ENTITY_INSERT_WITH_TYPE_ID = "INSERT OR IGNORE INTO entity(name, entityTypeId) VALUES(?, ?);";
    private static final String ENTITYINSTANCE_INSERT = "INSERT OR IGNORE INTO entityInstance VALUES((SELECT id FROM entity WHERE name = ?), ?);";
    private static final String EVENTTYPE_INSERT = "INSERT OR IGNORE INTO eventType(name) VALUES(?);";
    private static final String EVENT_INSERT = "INSERT OR IGNORE INTO event(name, eventTypeId, entityId, sourceEntityId) VALUES(?, (SELECT id FROM eventType WHERE name = ?), (SELECT id FROM entity WHERE name = ?), (SELECT id FROM entity WHERE name = ?));";
    private static final String METRIC_INSERT = "INSERT OR IGNORE INTO metric(name, dimension) VALUES(?, ?);";
    private static final String ENTITYMETRICVALUE_INSERT = "INSERT OR IGNORE INTO entityMetricValue VALUES((SELECT id FROM entity WHERE name = ?), (SELECT id FROM metric WHERE name = ?), ?);";
    private static final String ENTITYINSTANCEMETRICVALUE_INSERT = "INSERT OR IGNORE INTO entityInstanceMetricValue VALUES((SELECT id FROM entity WHERE name = ?), ?, (SELECT id FROM metric WHERE name = ?), ?);";
    private static final String PROPERTY_INSERT = "INSERT OR IGNORE INTO property(name, type) VALUES(?, ?);";
    private static final String PROPERTYVALUE_INSERT = "INSERT OR IGNORE INTO propertyValue VALUES((SELECT id FROM entity WHERE name = ?), (SELECT id FROM property WHERE name = ?), ?, ?);";
    private static final String ENTITYIDREFPROPERTYVALUE_INSERT = "INSERT OR IGNORE INTO propertyValue VALUES((SELECT id FROM entity WHERE name = ?), (SELECT id FROM property WHERE name = ?), ?, (SELECT id FROM entity WHERE name = ?));";
    private static final String EVENTIDREFPROPERTYVALUE_NO_SOURCE_INSERT = "INSERT OR IGNORE INTO propertyValue VALUES(\n(SELECT id FROM entity WHERE name = ?),\n(SELECT id FROM property WHERE name = ?),\n0,\n(IFNULL((SELECT id FROM event WHERE eventTypeId = (SELECT id FROM eventType WHERE name = ?) AND\n  entityId = (SELECT id FROM entity WHERE name = ?)), (SELECT id FROM event WHERE name = ?))));";
    private static final String EVENTIDREFPROPERTYVALUE_WITH_SOURCE_INSERT = "INSERT OR IGNORE INTO propertyValue VALUES(\n(SELECT id FROM entity WHERE name = ?),\n(SELECT id FROM property WHERE name = ?),\n0,\n(IFNULL((SELECT id FROM event WHERE eventTypeId = (SELECT id FROM eventType WHERE name = ?) AND\n  entityId = (SELECT id FROM entity WHERE name = ?) AND\n  sourceEntityId = (SELECT id FROM entity WHERE name = ?)), (SELECT id FROM event WHERE name = ?))));";
    private static final String TRACEEVENT_INSERT = "INSERT OR IGNORE INTO traceEvent VALUES(?, ?, (SELECT id FROM entity WHERE name = ?), ?, (SELECT id FROM entity WHERE name = ?), ?, (SELECT id FROM eventType WHERE name = ?), ?);";
    private static final String ENTITYINSTANCEMETRICVALUES_INSERT = "INSERT OR IGNORE INTO entityInstanceMetricValue SELECT\n  entityId,\n  entityInstance,\n  (SELECT id FROM metric WHERE name = ?),\n  metricValue FROM (SELECT\n    entityId,\n    entityInstance,\n    IFNULL(SUM(CASE\n      WHEN eventTypeId IN (SELECT id FROM eventType WHERE name IN (%1$s)) THEN -timestamp\n      WHEN eventTypeId IN (SELECT id FROM eventType WHERE name IN (%2$s)) THEN timestamp\n    END), 0) metricValue\n  FROM %3$sInstanceRuntimeTraceEvent GROUP BY entityId, entityInstance\n  HAVING (SELECT isComplete FROM %3$sInstanceTraceInfo WHERE\n    entityId       = %3$sInstanceRuntimeTraceEvent.entityId AND\n    entityInstance = %3$sInstanceRuntimeTraceEvent.entityInstance)\n  );";
    private static final String COMBINEDENTITYINSTANCEMETRICVALUES_INSERT = "INSERT OR IGNORE INTO entityInstanceMetricValue SELECT\n  entityId,\n  entityInstance,\n  (SELECT id FROM metric WHERE name = ?),\n  SUM(value)\nFROM entityInstanceMetricValue WHERE\n  metricId IN (SELECT id FROM metric WHERE name IN (%1$s)) AND\n  (SELECT isComplete\n    FROM %2$sInstanceTraceInfo\n    WHERE entityId = entityInstanceMetricValue.entityId AND\n      entityInstance = entityInstanceMetricValue.entityInstance\n  ) = 1\nGROUP BY entityId, entityInstance;";
    private static final String INTERENTITYINSTANCEMETRICVALUES_INSERT = "INSERT OR IGNORE INTO entityInstanceMetricValue SELECT\n  entityId,\n  entityInstance,\n  (SELECT id FROM metric WHERE name = ?),\n  metricValue FROM (SELECT\n    A.entityId,\n    A.entityInstance,\n    SUM(B.timestamp - A.timestamp) AS metricValue\n  FROM (SELECT * FROM %1$sInstanceRuntimeTraceEvent) AS A INNER JOIN %1$sInstanceRuntimeTraceEvent AS B ON\n    B.entityId = A.entityId AND B.entityInstance = A.entityInstance + 1\n  WHERE A.eventTypeId = (SELECT id FROM eventType WHERE name = ?) AND\n        B.eventTypeId = (SELECT id FROM eventType WHERE name = ?)\n  GROUP BY A.entityId, A.entityInstance HAVING\n    (SELECT isComplete FROM %1$sInstanceTraceInfo WHERE\n      entityId       = A.entityId AND\n      entityInstance = A.entityInstance) AND\n    (SELECT isComplete FROM %1$sInstanceTraceInfo WHERE\n      entityId       = B.entityId AND\n      entityInstance = B.entityInstance)\n  );";
    private static final String INTERSOURCEENTITYINSTANCEMETRICVALUES_INSERT = "INSERT OR IGNORE INTO entityInstanceMetricValue SELECT\n  sourceEntityId,\n  sourceEntityInstance,\n  (SELECT id FROM metric WHERE name = ?),\n  metricValue FROM (SELECT\n    A.sourceEntityId,\n    A.sourceEntityInstance,\n    SUM(B.timestamp - A.timestamp) AS metricValue\n  FROM (SELECT * FROM %1$sInstanceRuntimeTraceEvent) AS A INNER JOIN %1$sInstanceRuntimeTraceEvent AS B ON\n    B.entityId = A.entityId AND B.entityInstance = A.entityInstance + 1\n  WHERE A.eventTypeId = (SELECT id FROM eventType WHERE name = ?) AND\n        B.eventTypeId = (SELECT id FROM eventType WHERE name = ?) AND\n        A.sourceEntityId = B.sourceEntityId\n  GROUP BY A.sourceEntityId, A.sourceEntityInstance HAVING\n    (SELECT isComplete FROM %1$sInstanceTraceInfo WHERE\n      entityId       = A.entityId AND\n      entityInstance = A.entityInstance) AND\n    (SELECT isComplete FROM %1$sInstanceTraceInfo WHERE\n      entityId       = B.entityId AND\n      entityInstance = B.entityInstance)\n  );";
    private static final String AGGREGATEDMETRICS_INSERT = "INSERT OR IGNORE INTO metric(name, dimension) SELECT name || '_' || ?, dimension FROM metric WHERE dimension = ? AND EXISTS(SELECT * FROM entityInstanceMetricValue WHERE metricId = metric.id LIMIT 1);";
    private static final String AGGREGATEDMETRICVALUE_INSERT = "INSERT OR IGNORE INTO entityMetricValue SELECT entityId, (SELECT id FROM metric WHERE name = (SELECT name FROM metric WHERE id = metricId) || '_' || ?), %1$s FROM entityInstanceMetricValue WHERE metricId IN (SELECT id FROM metric WHERE dimension = ?) GROUP BY entityId, metricId;";
    private static final String EVENTCOUNTMETRICVALUES_INSERT = "INSERT OR IGNORE INTO entityMetricValue SELECT\n  entityId,\n  (SELECT id FROM metric WHERE name = ?) AS metricId,\n  SUM(%1$sEventCount) AS value\nFROM %2$sInstanceTraceInfo GROUP BY entityId;";

    public ATDBConnection(String dbFile) throws SQLException {
        this(dbFile, DBConnection.AccessMode.ReadOnly);
    }

    public ATDBConnection(String dbFile, DBConnection.AccessMode accessMode) throws SQLException {
        super(dbFile, accessMode);
    }

    private String getFirstStringFromPreparedQuery(String query, List<String> parameters, String defaultValue) throws SQLException {
        return this.getStringStreamFromPreparedQuery(query, parameters).findFirst().orElse(defaultValue);
    }

    private <T> Stream<T> getStreamFromPreparedQuery(String query, List<String> parameters, DBConnection.ThrowingFunction<ResultSet, T, SQLException> rowMapper) throws SQLException {
        PreparedStatement prepStmt = super.getPrepareQueryFor(query);
        int i = 0;
        while (i < parameters.size()) {
            prepStmt.setString(i + 1, parameters.get(i));
            ++i;
        }
        return super.queryAndMapToStream(prepStmt, rowMapper).filter(Objects::nonNull);
    }

    private Stream<String> getStringStreamFromPreparedQuery(String query, List<String> parameters) throws SQLException {
        return this.getStreamFromPreparedQuery(query, parameters, rs -> rs.getString(1));
    }

    private List<String> getStringListFromPreparedQuery(String query, List<String> parameters) throws SQLException {
        return this.getStringStreamFromPreparedQuery(query, parameters).collect(Collectors.toList());
    }

    private Stream<Long> getLongStreamFromPreparedQuery(String query, List<String> parameters) throws SQLException {
        return this.getStreamFromPreparedQuery(query, parameters, rs -> rs.getLong(1));
    }

    private List<Long> getLongListFromPreparedQuery(String query, List<String> parameters) throws SQLException {
        return this.getLongStreamFromPreparedQuery(query, parameters).collect(Collectors.toList());
    }

    private String getMetaInfo(String metaInfoKey, String defaultValue) throws SQLException {
        return this.getFirstStringFromPreparedQuery(METAINFORMATION_QUERY, Arrays.asList(metaInfoKey), defaultValue);
    }

    public String getTimeBase() throws SQLException {
        return this.getMetaInfo(MetaInformation.TIME_BASE.camelName, "?");
    }

    public List<String> getAllEntitiesByType(String entityTypeName) throws SQLException {
        return this.getStringListFromPreparedQuery(ENTITY_BY_TYPE_QUERY, Arrays.asList(entityTypeName));
    }

    public List<Long> getAllInstancesForEntity(String entityName) throws SQLException {
        return this.getLongListFromPreparedQuery(ENTITY_INSTANCES_QUERY, Arrays.asList(entityName));
    }

    public List<String> getAllECUs() throws SQLException {
        return this.getAllEntitiesByType("ECU");
    }

    public List<String> getProcessorsOfECU(String ecuName) throws SQLException {
        return this.getStringListFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(ecuName, "ECU", EntityProperty.PROCESSORS.camelName));
    }

    public List<String> getAllProcessors() throws SQLException {
        return this.getAllEntitiesByType("Processor");
    }

    public List<String> getCoresOfProcessor(String processorName) throws SQLException {
        return this.getStringListFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(processorName, "Processor", EntityProperty.CORES.camelName));
    }

    public List<String> getAllCores() throws SQLException {
        return this.getAllEntitiesByType("C");
    }

    public long getCoreFrequencyInHz(String coreName) throws SQLException {
        return Long.parseLong(this.getFirstStringFromPreparedQuery(ENTITY_PROPERTY_VALUE_QUERY, Arrays.asList(coreName, "C", EntityProperty.FREQUENCY_IN_HZ.camelName), "0"));
    }

    public List<String> getAllProcesses() throws SQLException {
        return Stream.concat(this.getStringStreamFromPreparedQuery(ENTITY_BY_TYPE_QUERY, List.of("T")), this.getStringStreamFromPreparedQuery(ENTITY_BY_TYPE_QUERY, List.of("I"))).collect(Collectors.toList());
    }

    public List<String> getAllTasks() throws SQLException {
        return this.getAllEntitiesByType("T");
    }

    public List<String> getAllISRs() throws SQLException {
        return this.getAllEntitiesByType("I");
    }

    public String getExecutingCoreOfProcess(String processName) throws SQLException {
        Optional<String> coreOfTask = this.getStringStreamFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(processName, "T", EntityProperty.EXECUTING_CORE.camelName)).findFirst();
        if (!coreOfTask.isPresent()) {
            return this.getFirstStringFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(processName, "I", EntityProperty.EXECUTING_CORE.camelName), "");
        }
        return coreOfTask.get();
    }

    public List<String> getRunnablesOfProcess(String processName) throws SQLException {
        return Stream.concat(this.getStringStreamFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(processName, "T", EntityProperty.RUNNABLES.camelName)), this.getStringStreamFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(processName, "I", EntityProperty.RUNNABLES.camelName))).collect(Collectors.toList());
    }

    public List<String> getStimuliOfProcess(String processName) throws SQLException {
        return Stream.concat(this.getStringStreamFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(processName, "T", EntityProperty.STIMULI.camelName)), this.getStringStreamFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(processName, "I", EntityProperty.STIMULI.camelName))).collect(Collectors.toList());
    }

    public List<String> getAllRunnables() throws SQLException {
        return this.getAllEntitiesByType("R");
    }

    public List<String> getLabelsReadByRunnable(String runnableName) throws SQLException {
        return this.getStringListFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(runnableName, "R", EntityProperty.READ_SIGNALS.camelName));
    }

    public List<String> getLabelsWrittenByRunnable(String runnableName) throws SQLException {
        return this.getStringListFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(runnableName, "R", EntityProperty.WRITTEN_SIGNALS.camelName));
    }

    public List<String> getAllStimuli() throws SQLException {
        return this.getAllEntitiesByType("STI");
    }

    public List<String> getAllLabels() throws SQLException {
        return this.getAllEntitiesByType("SIG");
    }

    public String getLabelInitialValue(String labelName) throws SQLException {
        return this.getFirstStringFromPreparedQuery(ENTITY_PROPERTY_VALUE_QUERY, Arrays.asList(labelName, "SIG", EntityProperty.INITIAL_VALUE.camelName), "");
    }

    public List<String> getAllEventChains() throws SQLException {
        return this.getAllEntitiesByType(EC);
    }

    public List<String> getAllEvents() throws SQLException {
        return this.getStringListFromPreparedQuery(EVENTS_QUERY, Collections.emptyList());
    }

    public List<String> getAllEventsByType(String eventTypeName) throws SQLException {
        return this.getStringListFromPreparedQuery(EVENT_BY_TYPE_QUERY, Arrays.asList(eventTypeName));
    }

    public List<String> getAllProcessEvents() throws SQLException {
        return Stream.concat(this.getStringStreamFromPreparedQuery(EVENT_BY_ENTITY_TYPE_QUERY, List.of("T")), this.getStringStreamFromPreparedQuery(EVENT_BY_ENTITY_TYPE_QUERY, List.of("I"))).collect(Collectors.toList());
    }

    public List<String> getAllRunnableEvents() throws SQLException {
        return this.getStringListFromPreparedQuery(EVENT_BY_ENTITY_TYPE_QUERY, List.of("R"));
    }

    public List<String> getAllLabelEvents() throws SQLException {
        return this.getStringListFromPreparedQuery(EVENT_BY_ENTITY_TYPE_QUERY, List.of("SIG"));
    }

    public List<String> getAllStimulusEvents() throws SQLException {
        return this.getStringListFromPreparedQuery(EVENT_BY_ENTITY_TYPE_QUERY, List.of("STI"));
    }

    public String getEventTypeForEvent(String eventName) throws SQLException {
        return this.getFirstStringFromPreparedQuery(EVENT_TYPE_OF_EVENT_QUERY, Arrays.asList(eventName), "");
    }

    public String getEntityForEvent(String eventName) throws SQLException {
        return this.getFirstStringFromPreparedQuery(ENTITY_OF_EVENT_QUERY, Arrays.asList(eventName), "");
    }

    public String getSourceEntityForEvent(String eventName) throws SQLException {
        return this.getFirstStringFromPreparedQuery(SOURCE_ENTITY_OF_EVENT_QUERY, Arrays.asList(eventName), "");
    }

    public String getEventChainStimulus(String eventChainName) throws SQLException {
        return this.getFirstStringFromPreparedQuery(EVENTCHAIN_EVENTREF_QUERY, Arrays.asList(EntityProperty.EC_STIMULUS.camelName, eventChainName), "");
    }

    public String getEventChainResponse(String eventChainName) throws SQLException {
        return this.getFirstStringFromPreparedQuery(EVENTCHAIN_EVENTREF_QUERY, Arrays.asList(EntityProperty.EC_RESPONSE.camelName, eventChainName), "");
    }

    public List<String> getEventChainItems(String eventChainName) throws SQLException {
        return this.getStringListFromPreparedQuery(ENTITY_PROPERTY_ENTITYREF_QUERY, Arrays.asList(eventChainName, EC, EntityProperty.EC_ITEMS.camelName));
    }

    public int getEventChainMinItemsCompleted(String eventChainName) throws SQLException {
        return Integer.parseInt(this.getFirstStringFromPreparedQuery(ENTITY_PROPERTY_VALUE_QUERY, Arrays.asList(eventChainName, EC, EntityProperty.EC_MIN_ITEMS_COMPLETED.camelName), "0"));
    }

    public List<String> getAllMetrics() throws SQLException {
        return this.getStringListFromPreparedQuery(METRICS_QUERY, Collections.emptyList());
    }

    public String getValueForMetricAndEntity(String entityName, String metricName) throws SQLException {
        return this.getFirstStringFromPreparedQuery(METRICVALUE_QUERY, Arrays.asList(entityName, metricName), "");
    }

    public void insertMetaInformation(String infoName, String infoValue) throws SQLException {
        this.executeBatchablePrepStmt(METAINFORMATION_INSERT, Arrays.asList(infoName, infoValue));
    }

    public void setTimeBase(String newTimeBase) throws SQLException {
        this.insertMetaInformation(MetaInformation.TIME_BASE.camelName, newTimeBase);
    }

    public void insertEntityType(String name) throws SQLException {
        this.executeBatchablePrepStmt(ENTITYTYPE_INSERT, Arrays.asList(name));
    }

    public long immediateInsertEntityType(String name) throws SQLException {
        return this.executePrepStmtAndGetGeneratedId(ENTITYTYPE_INSERT, Arrays.asList(name));
    }

    public void insertEntity(String name, String entityTypeName) throws SQLException {
        this.executeBatchablePrepStmt(ENTITY_INSERT, Arrays.asList(name, entityTypeName));
    }

    public long immediateInsertEntity(String name, long entityTypeId) throws SQLException {
        return this.executePrepStmtAndGetGeneratedId(ENTITY_INSERT_WITH_TYPE_ID, Arrays.asList(name, entityTypeId == -1L ? null : Long.valueOf(entityTypeId)));
    }

    public void insertEntityInstance(String entityName, long instNumber) throws SQLException {
        this.executeBatchablePrepStmt(ENTITYINSTANCE_INSERT, Arrays.asList(entityName, instNumber));
    }

    public void insertEntityInstances(String entityName, LongStream instNumbers) throws SQLException {
        PrimitiveIterator.OfLong numberIter = instNumbers.iterator();
        while (numberIter.hasNext()) {
            this.insertEntityInstance(entityName, numberIter.nextLong());
        }
    }

    public void insertEventType(String name) throws SQLException {
        this.executeBatchablePrepStmt(EVENTTYPE_INSERT, Arrays.asList(name));
    }

    public long immediateInsertEventType(String name) throws SQLException {
        return this.executePrepStmtAndGetGeneratedId(EVENTTYPE_INSERT, Arrays.asList(name));
    }

    public void insertEvent(String name, String eventTypeName, String entityName, String sourceEntityName) throws SQLException {
        this.executeBatchablePrepStmt(EVENT_INSERT, Arrays.asList(name, eventTypeName, entityName, sourceEntityName));
    }

    public void insertMetric(String name, String dimension) throws SQLException {
        this.executeBatchablePrepStmt(METRIC_INSERT, Arrays.asList(name, dimension));
    }

    public void insertEntityMetricValue(String entityName, String metricName, Object value) throws SQLException {
        this.executeBatchablePrepStmt(ENTITYMETRICVALUE_INSERT, Arrays.asList(entityName, metricName, value));
    }

    public void insertEntityInstanceMetricValue(String entityName, int entityInstNumber, String metricName, Object value) throws SQLException {
        this.executeBatchablePrepStmt(ENTITYINSTANCEMETRICVALUE_INSERT, Arrays.asList(entityName, entityInstNumber, metricName, value));
    }

    public void insertProperty(String name, String propertyType) throws SQLException {
        this.executeBatchablePrepStmt(PROPERTY_INSERT, Arrays.asList(name, propertyType));
    }

    public void insertPropertyValue(String entityName, String propertyName, Object value) throws SQLException {
        if (value instanceof Collection) {
            int sqcnr = 0;
            for (Object collectionElement : (Collection)value) {
                this.executeBatchablePrepStmt(PROPERTYVALUE_INSERT, Arrays.asList(entityName, propertyName, sqcnr, collectionElement));
                ++sqcnr;
            }
        } else {
            this.executeBatchablePrepStmt(PROPERTYVALUE_INSERT, Arrays.asList(entityName, propertyName, 0, value));
        }
    }

    public void insertEntityRefPropertyValue(String entityName, String propertyName, String referredEntityName) throws SQLException {
        this.insertEntityRefsPropertyValue(entityName, propertyName, Collections.singletonList(referredEntityName));
    }

    public void insertEntityRefsPropertyValue(String entityName, String propertyName, List<String> referredEntityNames) throws SQLException {
        if (referredEntityNames.isEmpty()) {
            return;
        }
        if (referredEntityNames.size() > 1) {
            int sqcnr = 0;
            for (String referredEntityName : referredEntityNames) {
                this.executeBatchablePrepStmt(ENTITYIDREFPROPERTYVALUE_INSERT, Arrays.asList(entityName, propertyName, sqcnr, referredEntityName));
                ++sqcnr;
            }
        } else {
            this.executeBatchablePrepStmt(ENTITYIDREFPROPERTYVALUE_INSERT, Arrays.asList(entityName, propertyName, 0, (Serializable)((Object)referredEntityNames.get(0))));
        }
    }

    public void insertEventRefPropertyValue(String entityName, String propertyName, String eventName, String eventTypeName, String subjectEntityName, String sourceEntityName) throws SQLException {
        if (sourceEntityName.length() == 0) {
            this.executeBatchablePrepStmt(EVENTIDREFPROPERTYVALUE_NO_SOURCE_INSERT, Arrays.asList(entityName, propertyName, eventTypeName, subjectEntityName, eventName));
        } else {
            this.executeBatchablePrepStmt(EVENTIDREFPROPERTYVALUE_WITH_SOURCE_INSERT, Arrays.asList(entityName, propertyName, eventTypeName, subjectEntityName, sourceEntityName, eventName));
        }
    }

    public void insertTraceEvent(long timestamp, int sqcnr, String entityName, int entityInstNumber, String sourceEntityName, int sourceEntityInstNumber, String eventTypeName, Object value) throws SQLException {
        this.executeBatchablePrepStmt(TRACEEVENT_INSERT, Arrays.asList(timestamp, sqcnr, entityName, entityInstNumber, sourceEntityName, sourceEntityInstNumber, eventTypeName, value));
    }

    public void insertEntityInstanceStateMetricValuesForEntityType(String metricName, EntityType<?> entityType, Collection<String> stateEnteringEvents, Collection<String> stateleavingEvents) throws SQLException {
        this.insertMetric(metricName, "time");
        String enteringEvents = stateEnteringEvents.stream().map(e -> "'" + e.toLowerCase() + "'").collect(Collectors.joining(", "));
        String leavingEvents = stateleavingEvents.stream().map(e -> "'" + e.toLowerCase() + "'").collect(Collectors.joining(", "));
        this.executeBatchablePrepStmt(String.format(ENTITYINSTANCEMETRICVALUES_INSERT, enteringEvents, leavingEvents, entityType.getName()), Arrays.asList(metricName));
    }

    public void insertCombinedEntityInstanceStateMetricValuesForEntityType(String metricName, EntityType<?> entityType, List<String> metricNamesToCombine) throws SQLException {
        this.insertMetric(metricName, "time");
        String cStates = metricNamesToCombine.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "));
        this.executeBatchablePrepStmt(String.format(COMBINEDENTITYINSTANCEMETRICVALUES_INSERT, cStates, entityType.getName()), Arrays.asList(metricName));
    }

    public void insertInterEntityInstanceMetricValuesForEntityType(String metricName, EntityType<?> entityType, String firstInstanceEvent, String secondInstanceEvent) throws SQLException {
        this.insertMetric(metricName, "time");
        this.executeBatchablePrepStmt(String.format(INTERENTITYINSTANCEMETRICVALUES_INSERT, entityType.getName()), Arrays.asList(metricName, firstInstanceEvent, secondInstanceEvent));
    }

    public void insertInterSourceEntityInstanceMetricValuesForEntityType(String metricName, EntityType<?> entityType, String entityInstanceEvent) throws SQLException {
        this.insertMetric(metricName, "time");
        this.executeBatchablePrepStmt(String.format(INTERSOURCEENTITYINSTANCEMETRICVALUES_INSERT, entityType.getName()), Arrays.asList(metricName, entityInstanceEvent, entityInstanceEvent));
    }

    public void insertAggregatedEntityInstanceMetricsForDimension(String dimension) throws SQLException {
        MetricAggregation[] metricAggregationArray = MetricAggregation.values();
        int n = metricAggregationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetricAggregation ma = metricAggregationArray[n2];
            this.executeBatchablePrepStmt(AGGREGATEDMETRICS_INSERT, Arrays.asList(ma.name(), dimension));
            this.executeBatchablePrepStmt(String.format(AGGREGATEDMETRICVALUE_INSERT, ma.getSQLStr("value")), Arrays.asList(ma.name(), dimension));
            ++n2;
        }
    }

    public void insertCountsForEntityTypeAndEvent(String metricName, EntityType<?> entityType, String eventType) throws SQLException {
        this.insertMetric(metricName, "count");
        this.executeBatchablePrepStmt(String.format(EVENTCOUNTMETRICVALUES_INSERT, eventType, entityType.getName()), Arrays.asList(metricName));
    }

    public void insertEventChain(String name) throws SQLException {
        this.insertEntityType(EC);
        this.insertEntity(name, EC);
    }

    public void insertEventChain(String name, String stimulusEventName, String responseEventName) throws SQLException {
        this.insertEventChain(name);
        this.insertEventRefPropertyValue(name, EntityProperty.EC_STIMULUS.camelName, stimulusEventName, "", "", "");
        this.insertEventRefPropertyValue(name, EntityProperty.EC_RESPONSE.camelName, responseEventName, "", "", "");
    }
}

