/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.os;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.ISRAllocation;
import org.eclipse.app4mc.amalthea.model.InterruptController;
import org.eclipse.app4mc.amalthea.model.ParameterType;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAssociation;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.xbase.lib.Pair;

@Validation(id="AM-OS-Mandatory-Scheduling-Parameters-Set", checks={"Mandatory scheduling parameters must be set"})
public class AmOSMandatorySchedulingParametersSet
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getScheduler();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof Scheduler) {
            Scheduler sc = (Scheduler)object;
            if (sc.getDefinition() == null) {
                return;
            }
            LinkedHashMap<Pair, List> missingSPs = new LinkedHashMap<Pair, List>();
            List missingMandatoryAlgorithmParameterDefs = sc.getDefinition().getAlgorithmParameters().stream().filter(SchedulingParameterDefinition::isMandatory).collect(Collectors.toList());
            sc.getSchedulingParameters().stream().map(Map.Entry::getKey).forEach(missingMandatoryAlgorithmParameterDefs::remove);
            missingSPs.put(new Pair((Object)sc, (Object)ePackage.getISchedulingParameterContainer_SchedulingParameters()), missingMandatoryAlgorithmParameterDefs);
            List mandatoryProcessParameterDefs = sc.getDefinition().getProcessParameters().stream().filter(SchedulingParameterDefinition::isMandatory).collect(Collectors.toList());
            if (sc instanceof TaskScheduler) {
                TaskScheduler ts = (TaskScheduler)sc;
                for (TaskAllocation ta : ts.getTaskAllocations()) {
                    ArrayList perTAMissing = new ArrayList(mandatoryProcessParameterDefs);
                    ta.getSchedulingParameters().stream().map(Map.Entry::getKey).forEach(perTAMissing::remove);
                    missingSPs.put(new Pair((Object)ta, (Object)ePackage.getISchedulingParameterContainer_SchedulingParameters()), perTAMissing);
                }
                for (SchedulerAssociation sa : ts.getChildAssociations()) {
                    ArrayList perSAMissing = new ArrayList(mandatoryProcessParameterDefs);
                    sa.getSchedulingParameters().stream().map(Map.Entry::getKey).forEach(perSAMissing::remove);
                    missingSPs.put(new Pair((Object)sa, (Object)ePackage.getISchedulingParameterContainer_SchedulingParameters()), perSAMissing);
                }
            } else if (sc instanceof InterruptController) {
                InterruptController ic = (InterruptController)sc;
                for (ISRAllocation ia : ic.getIsrAllocations()) {
                    List perIAMissing = mandatoryProcessParameterDefs.stream().filter(spd -> !spd.getName().equals("priority") || spd.getType() != ParameterType.INTEGER).collect(Collectors.toList());
                    missingSPs.put(new Pair((Object)ia, (Object)ePackage.getISRAllocation_Priority()), perIAMissing);
                }
            }
            missingSPs.forEach((eo, missingList) -> missingList.forEach(missing -> this.addIssue(results, (EObject)eo.getKey(), (EStructuralFeature)eo.getValue(), "Mandatory scheduling parameter \"" + missing.getName() + "\" is not set for " + this.objectInfo((EObject)eo.getKey()))));
        }
    }
}

