/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.sim.basic;

import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="Sim-Basic-Identifiers", checks={"All names of IReferable objects must be valid C++ identifier names"})
public class SimBasicIdentifiers
extends AmaltheaValidation {
    private static final Set<String> KEYWORDS = Set.of("alignas", "alignof", "and", "and_eq", "asm", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char8_t", "char16_t", "char32_t", "class", "compl", "concept", "const", "consteval", "constexpr", "constinit", "const_cast", "continue", "co_await", "co_return", "co_yield", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "long", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "requires", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq");

    public EClassifier getEClassifier() {
        return ePackage.getIReferable();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        IReferable ref;
        if (eObject instanceof IReferable && !this.validIdentifier((ref = (IReferable)eObject).getName())) {
            this.addIssue(results, (EObject)ref, (EStructuralFeature)ePackage.getINamed_Name(), String.valueOf(this.objectInfo((EObject)ref)) + ": Invalid name (not a valid C++ identifier)");
        }
    }

    private boolean validIdentifier(String name) {
        if (name == null || name.isEmpty() || KEYWORDS.contains(name)) {
            return false;
        }
        char firstChar = name.charAt(0);
        if (firstChar != '_' && !Character.isLetter(firstChar)) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c != '_' && !Character.isLetter(c) && !Character.isDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

