/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class AmaltheaExtensions {
    private static final String ARG_STRING_MESSAGE = "Argument is null, expected: String";
    private static final String ARG_LIST_MESSAGE = "Argument is null, expected: EList";
    private static final String ARG_LIST_ITEM_MESSAGE = "List argument contains null";

    private AmaltheaExtensions() {
        throw new IllegalStateException("Utility class");
    }

    public static String toPlainString(@NonNull EList<@NonNull String> segments, @NonNull String delimiter) {
        Preconditions.checkArgument((segments != null ? 1 : 0) != 0, (Object)ARG_LIST_MESSAGE);
        Preconditions.checkArgument((!segments.contains(null) ? 1 : 0) != 0, (Object)ARG_LIST_ITEM_MESSAGE);
        Preconditions.checkArgument((delimiter != null ? 1 : 0) != 0, (Object)ARG_STRING_MESSAGE);
        if (segments.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder((String)segments.get(0));
        int i = 1;
        while (i < segments.size()) {
            result.append(delimiter);
            result.append((String)segments.get(i));
            ++i;
        }
        return result.toString();
    }

    public static String toEncodedString(@NonNull EList<@NonNull String> segments) {
        Preconditions.checkArgument((segments != null ? 1 : 0) != 0, (Object)ARG_LIST_MESSAGE);
        Preconditions.checkArgument((!segments.contains(null) ? 1 : 0) != 0, (Object)ARG_LIST_ITEM_MESSAGE);
        if (segments.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(AmaltheaExtensions.encode((String)segments.get(0)));
        int i = 1;
        while (i < segments.size()) {
            result.append("/");
            result.append(AmaltheaExtensions.encode((String)segments.get(i)));
            ++i;
        }
        return result.toString();
    }

    public static String encode(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return "no-name";
        }
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }
}

