/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.converter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class AbstractRootElementConverter
extends AbstractConverter {
    protected static final Map<String, String> SUB_MODEL_REPLACEMENT_NAMES;

    static {
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        tmpMap.put("CommonElements", "commonElements");
        tmpMap.put("ComponentsModel", "componentsModel");
        tmpMap.put("ConfigModel", "configModel");
        tmpMap.put("ConstraintsModel", "constraintsModel");
        tmpMap.put("EventModel", "eventModel");
        tmpMap.put("HWModel", "hwModel");
        tmpMap.put("MappingModel", "mappingModel");
        tmpMap.put("OSModel", "osModel");
        tmpMap.put("PropertyConstraintsModel", "propertyConstraintsModel");
        tmpMap.put("StimuliModel", "stimuliModel");
        tmpMap.put("SWModel", "swModel");
        SUB_MODEL_REPLACEMENT_NAMES = Collections.unmodifiableMap(tmpMap);
    }

    protected void updateCurrentRootTagProps(Element rootElement) {
        HelperUtil.removeDefaultAttribs(rootElement);
        String oldName = rootElement.getName();
        String newName = SUB_MODEL_REPLACEMENT_NAMES.get(oldName);
        if (newName != null) {
            rootElement.setName(newName);
        }
    }

    protected void doConvert(Document document) {
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        String rootTagName = rootElement.getName();
        if (!"Amalthea".equals(rootTagName) && SUB_MODEL_REPLACEMENT_NAMES.containsKey(rootTagName)) {
            Element newRootElement = new Element("Amalthea");
            HelperUtil.copyAllNameSpaces(rootElement, newRootElement);
            this.updateCurrentRootTagProps(rootElement);
            document.removeContent();
            newRootElement.addContent((Content)rootElement);
            document.addContent((Content)newRootElement);
        }
    }
}

