/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.standard;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.embed.swt.FXCanvas;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.visualizations.standard.util.ArrowPainter;
import org.eclipse.app4mc.amalthea.visualizations.standard.util.RunnableFilterDialog;
import org.eclipse.app4mc.amalthea.visualizations.standard.util.RunnableHelper;
import org.eclipse.app4mc.amalthea.visualizations.standard.util.RunnablePainter;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Shared Runnable Label Dependencies", "description=Visualize the selected Runnables and the shared Labels"}, service={Visualization.class, RunnableSharedDependencyVisualization.class})
public class RunnableSharedDependencyVisualization
implements Visualization {
    private ArrowPainter arrowPainter = new ArrowPainter();

    @PostConstruct
    public void createVisualization(List<Runnable> runnables, VisualizationParameters parameters, Composite parent, IEventBroker broker) {
        parent.setLayout((Layout)new GridLayout());
        FXCanvas fxCanvas = new FXCanvas(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fxCanvas);
        BorderPane layout = new BorderPane();
        layout.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        Scene scene = new Scene((Parent)layout);
        fxCanvas.setScene(scene);
        List<Object> toRender = runnables;
        RunnableFilterDialog dialog = new RunnableFilterDialog(parent.getShell(), runnables);
        if (runnables.size() > 100) {
            toRender = dialog.open() == 0 ? dialog.getSelectedRunnables() : Collections.emptyList();
        }
        List<RunnablePainter> painters = toRender.stream().map(r -> new RunnablePainter((Runnable)r, false)).collect(Collectors.toList());
        Button zoomIn = new Button("+");
        zoomIn.setPrefSize(40.0, 40.0);
        Button zoomOut = new Button("-");
        zoomOut.setPrefSize(40.0, 40.0);
        Button filter = new Button("F");
        filter.setPrefSize(40.0, 40.0);
        filter.setOnAction(event -> {
            if (dialog.open() == 0) {
                painters.clear();
                painters.addAll(dialog.getSelectedRunnables().stream().map(r -> new RunnablePainter((Runnable)r, false)).collect(Collectors.toList()));
                RunnableHelper.setMaxScaleFactor(painters);
                RunnableHelper.setInitialScaleFactor(painters, parameters);
                parent.redraw();
            }
        });
        zoomIn.setOnAction(event -> {
            if (!zoomIn.isDisabled()) {
                painters.forEach(RunnablePainter::zoomIn);
                double scaleFactor = ((RunnablePainter)painters.get(0)).getScaleFactor();
                RunnableHelper.persistScaleFactor(scaleFactor, parameters);
                if (scaleFactor >= ((RunnablePainter)painters.get(0)).getMaxScaleFactor()) {
                    zoomIn.setDisable(true);
                }
                if (zoomOut.isDisabled()) {
                    zoomOut.setDisable(false);
                }
            }
            parent.redraw();
        });
        zoomOut.setOnAction(event -> {
            if (!zoomOut.isDisabled()) {
                painters.forEach(RunnablePainter::zoomOut);
                double scaleFactor = ((RunnablePainter)painters.get(0)).getScaleFactor();
                RunnableHelper.persistScaleFactor(scaleFactor, parameters);
                if (scaleFactor <= 0.1) {
                    zoomOut.setDisable(true);
                }
                if (zoomIn.isDisabled()) {
                    zoomIn.setDisable(false);
                }
            }
            parent.redraw();
        });
        VBox vBox = new VBox(5.0);
        vBox.setPadding(new Insets(5.0));
        vBox.getChildren().addAll((Object[])new Node[]{zoomIn, zoomOut, filter});
        layout.setLeft((Node)vBox);
        RunnableHelper.setMaxScaleFactor(painters);
        RunnableHelper.setInitialScaleFactor(painters, parameters);
        if (!painters.isEmpty()) {
            if (painters.get(0).getScaleFactor() >= painters.get(0).getMaxScaleFactor()) {
                zoomIn.setDisable(true);
            }
            if (painters.get(0).getScaleFactor() <= 0.1) {
                zoomOut.setDisable(true);
            }
        }
        Canvas canvas = new Canvas();
        ScrollPane scrollable = new ScrollPane();
        scrollable.setStyle("-fx-background: rgb(255,255,255);\n -fx-background-color: rgb(255,255,255)");
        scrollable.setContent((Node)canvas);
        layout.setCenter((Node)scrollable);
        canvas.setOnMouseClicked(event -> {
            for (RunnablePainter p : painters) {
                if (!p.getRunnableRectangle().contains(event.getX(), event.getY())) continue;
                HashMap<String, List<Runnable>> data = new HashMap<String, List<Runnable>>();
                data.put("modelElements", Arrays.asList(p.getRunnable()));
                broker.send("org/eclipse/app4mc/amalthea/editor/SELECT", data);
            }
        });
        canvas.setOnScroll(event -> {
            if (event.isControlDown()) {
                double deltaY = event.getDeltaY();
                if (deltaY < 0.0) {
                    zoomOut.fire();
                } else {
                    zoomIn.fire();
                }
                event.consume();
            }
        });
        canvas.setOnMouseMoved(event -> {
            Point2D screenToLocal = canvas.screenToLocal(event.getScreenX(), event.getScreenY());
            double x = screenToLocal.getX();
            double y = screenToLocal.getY();
            boolean activate = false;
            for (RunnablePainter p : painters) {
                if (!p.getRunnableRectangle().contains(x, y)) continue;
                activate = true;
                break;
            }
            if (activate) {
                scene.setCursor(Cursor.HAND);
            } else {
                scene.setCursor(Cursor.DEFAULT);
            }
        });
        GraphicsContext gc = canvas.getGraphicsContext2D();
        parent.addPaintListener(e -> {
            double parentBoundsHeight;
            org.eclipse.swt.graphics.Rectangle parentBounds = parent.getBounds();
            double[] grid = RunnableHelper.calculateGrid(painters.size());
            double[] minDim = RunnableHelper.calculateMinimumCellDimensions(grid, painters);
            double minWidth = grid[0] * minDim[0];
            double minHeight = grid[1] * minDim[1];
            double canvasWidth = minWidth;
            double canvasHeight = minHeight;
            double width = minWidth / grid[0];
            double height = minHeight / grid[1];
            double parentBoundsWidth = (double)parentBounds.width - 35.0 - vBox.getWidth();
            if (parentBoundsWidth > minWidth) {
                canvasWidth = parentBoundsWidth;
            }
            if ((parentBoundsHeight = (double)parentBounds.height - 30.0) > minHeight) {
                canvasHeight = parentBoundsHeight;
            }
            canvasWidth = Math.min(6000.0, canvasWidth);
            canvasHeight = Math.min(6000.0, canvasHeight);
            canvas.setWidth(canvasWidth);
            canvas.setHeight(canvasHeight);
            gc.clearRect(0.0, 0.0, canvasWidth, canvasHeight);
            double xStart = parentBounds.x;
            double yStart = parentBounds.y;
            int count = 0;
            RunnablePainter p = null;
            int row = 0;
            while ((double)row < grid[1]) {
                int column = 0;
                while ((double)column < grid[0]) {
                    if (count >= painters.size()) break;
                    p = (RunnablePainter)painters.get(count);
                    Rectangle bounds = new Rectangle(Double.valueOf(xStart).doubleValue(), Double.valueOf(yStart).doubleValue(), Double.valueOf(width).doubleValue(), Double.valueOf(height).doubleValue());
                    p.paint(gc, bounds);
                    ++count;
                    xStart += width;
                    ++column;
                }
                xStart = parentBounds.x;
                yStart += height;
                ++row;
            }
            for (RunnablePainter rp : painters) {
                Map<Label, Rectangle> writeRectangles = rp.getWriteRectangles();
                writeRectangles.entrySet().forEach(entry -> {
                    for (RunnablePainter rp2 : painters) {
                        Rectangle readRect = rp2.getReadRectangle((Label)entry.getKey());
                        if (readRect == null) continue;
                        Rectangle writeRect = (Rectangle)entry.getValue();
                        double startX = writeRect.getX() + writeRect.getWidth();
                        double startY = writeRect.getY() + writeRect.getHeight() / 10.0 * 9.0;
                        double endX = readRect.getX();
                        double endY = readRect.getY() + readRect.getHeight() / 10.0 * 9.0;
                        this.arrowPainter.paint(gc, startX, startY, endX, endY);
                    }
                });
            }
        });
    }
}

