/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf.model;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.app4mc.amalthea.model.ProcessEventType;
import org.eclipse.app4mc.amalthea.model.RunnableEventType;
import org.eclipse.app4mc.atdb._import.btf.model.BTFCountMetric;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityType;

public enum BTFEntityState {
    notInitialized(new AbstractMap.SimpleEntry<List<T>, List<Enum>>(Collections.emptyList(), Arrays.asList(RunnableEventType.START)), new AbstractMap.SimpleEntry<List<T>, List<Enum>>(Collections.emptyList(), Arrays.asList(ProcessEventType.ACTIVATE))),
    startDelay(new AbstractMap.SimpleEntry<List<Enum>, List<Enum>>(Arrays.asList(ProcessEventType.ACTIVATE), Arrays.asList(ProcessEventType.START))),
    running(new AbstractMap.SimpleEntry<List<Enum>, List<Enum>>(Arrays.asList(RunnableEventType.START, RunnableEventType.RESUME), Arrays.asList(RunnableEventType.TERMINATE, RunnableEventType.SUSPEND)), new AbstractMap.SimpleEntry<List<Enum>, List<Enum>>(Arrays.asList(ProcessEventType.START, ProcessEventType.RESUME, ProcessEventType.RUN), Arrays.asList(ProcessEventType.TERMINATE, ProcessEventType.PREEMPT, ProcessEventType.POLL, ProcessEventType.WAIT))),
    polling(new AbstractMap.SimpleEntry<List<Enum>, List<Enum>>(Arrays.asList(ProcessEventType.POLL, ProcessEventType.POLL_PARKING), Arrays.asList(ProcessEventType.RUN, ProcessEventType.PARK))),
    parking(new AbstractMap.SimpleEntry<List<Enum>, List<Enum>>(Arrays.asList(ProcessEventType.PARK), Arrays.asList(ProcessEventType.POLL_PARKING, ProcessEventType.RELEASE_PARKING))),
    waiting(new AbstractMap.SimpleEntry<List<Enum>, List<Enum>>(Arrays.asList(ProcessEventType.WAIT), Arrays.asList(ProcessEventType.RELEASE))),
    ready(new AbstractMap.SimpleEntry<List<Enum>, List<Enum>>(Arrays.asList(RunnableEventType.SUSPEND), Arrays.asList(RunnableEventType.RESUME)), new AbstractMap.SimpleEntry<List<Enum>, List<Enum>>(Arrays.asList(ProcessEventType.PREEMPT, ProcessEventType.RELEASE, ProcessEventType.RELEASE_PARKING), Arrays.asList(ProcessEventType.RESUME))),
    response(new AbstractMap.SimpleEntry<List<Enum>, List<Enum>>(Arrays.asList(ProcessEventType.ACTIVATE), Arrays.asList(ProcessEventType.TERMINATE))),
    terminated(new AbstractMap.SimpleEntry<List<Enum>, List<T>>(Arrays.asList(RunnableEventType.TERMINATE), Collections.emptyList()), new AbstractMap.SimpleEntry<List<Enum>, List<T>>(Arrays.asList(ProcessEventType.TERMINATE), Collections.emptyList()));

    public final Map<BTFEntityType, Map.Entry<List<Enum<?>>, List<Enum<?>>>> entityType2InOutEvents = new LinkedHashMap();
    public static final List<BTFEntityState> actStates;

    static {
        actStates = Stream.of(BTFEntityState.values()).filter(p -> p.entityType2InOutEvents.values().stream().noneMatch(e -> ((List)e.getKey()).isEmpty())).filter(p -> p.entityType2InOutEvents.values().stream().noneMatch(e -> ((List)e.getValue()).isEmpty())).collect(Collectors.toList());
    }

    @SafeVarargs
    private BTFEntityState(Map.Entry<List<Enum<?>>, List<Enum<?>>> ... inOutEvents) {
        Stream.of(inOutEvents).forEach(e -> {
            String entityTypeName = ((List)e.getKey()).stream().findFirst().orElseGet(((List)e.getValue()).stream().findFirst()::get).getClass().getSimpleName();
            entityTypeName = entityTypeName.substring(0, entityTypeName.indexOf("EventType")).toLowerCase();
            this.entityType2InOutEvents.put(BTFEntityType.getForName(entityTypeName), (Map.Entry<List<Enum<?>>, List<Enum<?>>>)e);
        });
    }

    public static List<String> getValidityConstraints(BTFEntityType entityType) {
        ArrayList<String> validityConstraints = new ArrayList<String>();
        Stream.of(BTFEntityState.values()).filter(s -> !actStates.contains(s)).map(s -> s.entityType2InOutEvents.get((Object)entityType)).filter(Objects::nonNull).forEach(entry -> {
            ((List)entry.getKey()).forEach(e -> {
                boolean bl = validityConstraints.add(String.valueOf(e.toString().toLowerCase()) + "EventCount = 1");
            });
            ((List)entry.getValue()).forEach(e -> {
                boolean bl = validityConstraints.add(String.valueOf(e.toString().toLowerCase()) + "EventCount = 1");
            });
        });
        actStates.stream().map(s -> s.entityType2InOutEvents.get((Object)entityType)).filter(Objects::nonNull).forEach(entry -> {
            LinkedHashSet loopEvents = new LinkedHashSet((Collection)entry.getKey());
            loopEvents.retainAll((Collection)entry.getValue());
            String left = ((List)entry.getKey()).stream().filter(e -> !loopEvents.contains(e)).map(e -> String.valueOf(e.toString().toLowerCase()) + "EventCount").collect(Collectors.joining(" + "));
            String right = ((List)entry.getValue()).stream().filter(e -> !loopEvents.contains(e)).map(e -> String.valueOf(e.toString().toLowerCase()) + "EventCount").collect(Collectors.joining(" + "));
            validityConstraints.add(String.valueOf(left) + " = " + right);
        });
        return validityConstraints;
    }

    public static Set<Enum<?>> getPossibleEventsFor(BTFEntityType entityType) {
        LinkedHashSet result = new LinkedHashSet(BTFCountMetric.getInvolvedBTFEventsForEntityType(entityType));
        Stream.of(BTFEntityState.values()).map(s -> s.entityType2InOutEvents.get((Object)entityType)).filter(Objects::nonNull).flatMap(e -> Stream.concat(((List)e.getKey()).stream(), ((List)e.getValue()).stream())).distinct().forEach(result::add);
        return result;
    }
}

