/**
 ********************************************************************************
 * Copyright (c) 2020 Eclipse APP4MC contributors.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 ********************************************************************************
 */

package org.eclipse.app4mc.amalthea._import.atdb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.Event;
import org.eclipse.app4mc.amalthea.model.EventChain;
import org.eclipse.app4mc.amalthea.model.EventChainContainer;
import org.eclipse.app4mc.amalthea.model.EventChainItemType;
import org.eclipse.app4mc.amalthea.model.EventChainReference;
import org.eclipse.app4mc.amalthea.model.SubEventChain;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.atdb.ATDBConnection;

public class EventChainConverter extends AConverter {

	public EventChainConverter(final Amalthea model, final ATDBConnection con) {
		super(model, con, "event chains");
	}

	@Override
	protected void execute() throws SQLException {
		final ConstraintsModel constrModel = ModelUtil.getOrCreateConstraintsModel(this.model);
		
		final List<EventChain> eventChains = new ArrayList<>();
		this.con.getAllEventChains().forEach(ecName -> {
			final EventChain eventChain = AmaltheaModelUtil.getOrAddNew(constrModel,
					AmaltheaPackage.eINSTANCE.getConstraintsModel_EventChains(), ecName, EventChain.class,
					AmaltheaPackage.eINSTANCE.getEventChain());
			eventChains.add(eventChain);
		});
		
		for(final EventChain eventChain:eventChains) {
			final String stimulusEventName = this.con.getEventChainStimulus(eventChain.getName());
			if (stimulusEventName.length() > 0) {
				AmaltheaModelUtil.getOrAddNew(eventChain, AmaltheaPackage.eINSTANCE.getAbstractEventChain_Stimulus(),
						stimulusEventName, Event.class);
			}
			
			final String responseEventName = this.con.getEventChainResponse(eventChain.getName());
			if (responseEventName.length() > 0) {
				AmaltheaModelUtil.getOrAddNew(eventChain, AmaltheaPackage.eINSTANCE.getAbstractEventChain_Response(),
						responseEventName, Event.class);
			}
			
			final List<String> items = this.con.getEventChainItems(eventChain.getName());
			for(final String subECName:items) {
				if (subECName.length() == 0) continue;
				final boolean isReference = !AmaltheaIndex.getElements(constrModel, subECName, EventChain.class).isEmpty();
				if (isReference) {
					AmaltheaModelUtil.getOrAddNewWithContainer(eventChain,
							AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EventChainReference.class,
							AmaltheaPackage.eINSTANCE.getEventChainReference(),
							AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), EventChain.class,
							AmaltheaPackage.eINSTANCE.getEventChain(), subECName);
				} else {
					AmaltheaModelUtil.getOrAddNewWithContainer(eventChain,
							AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EventChainContainer.class,
							AmaltheaPackage.eINSTANCE.getEventChainContainer(),
							AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), SubEventChain.class,
							AmaltheaPackage.eINSTANCE.getSubEventChain(), subECName);
				}
			}
			
			final int minItemsComplete = this.con.getEventChainMinItemsCompleted(eventChain.getName());
			if (minItemsComplete > 0) {
				eventChain.setMinItemsCompleted(minItemsComplete);
				eventChain.setItemType(EventChainItemType.PARALLEL);
			} else {
				eventChain.setItemType(EventChainItemType.SEQUENCE);
			}
		}
	}

}
