/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.EntityType;
import org.eclipse.app4mc.atdb._import.btf.model.BTFCombiState;
import org.eclipse.app4mc.atdb._import.btf.model.BTFCountMetric;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityState;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityType;
import org.eclipse.app4mc.atdb._import.btf.model.BTFInterInstanceMetric;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ATDBMetricCalculator
implements IRunnableWithProgress {
    private final ATDBConnection con;

    public ATDBMetricCalculator(ATDBConnection con) {
        this.con = con;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException {
        progressMonitor.beginTask("Calculating metrics...", 5 + BTFEntityState.actStates.size());
        try {
            try {
                for (BTFEntityState state : BTFEntityState.actStates) {
                    this.con.executeBatchUpdate(atdbCon -> {
                        for (Map.Entry<BTFEntityType, Map.Entry<List<Enum<?>>, List<Enum<?>>>> et2io : bTFEntityState.entityType2InOutEvents.entrySet()) {
                            BTFEntityType entityType = et2io.getKey();
                            List<String> incomingEvents = et2io.getValue().getKey().stream().map(e -> e.toString().toLowerCase()).toList();
                            List<String> outgoingEvents = et2io.getValue().getValue().stream().map(e -> e.toString().toLowerCase()).toList();
                            atdbCon.insertEntityInstanceStateMetricValuesForEntityType((Object)((Object)state) + "Time", (EntityType)entityType, incomingEvents, outgoingEvents);
                        }
                    });
                    progressMonitor.worked(1);
                }
                this.con.executeBatchUpdate(atdbCon -> {
                    BTFCombiState[] bTFCombiStateArray = BTFCombiState.values();
                    int n = bTFCombiStateArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BTFCombiState cState = bTFCombiStateArray[n2];
                        List<String> relevantStates = cState.getStates().stream().map(s -> (Object)s + "Time").toList();
                        atdbCon.insertCombinedEntityInstanceStateMetricValuesForEntityType((Object)((Object)cState) + "Time", (EntityType)BTFEntityType.PROCESS, relevantStates);
                        ++n2;
                    }
                });
                progressMonitor.worked(1);
                this.con.executeBatchUpdate(atdbCon -> {
                    BTFInterInstanceMetric[] bTFInterInstanceMetricArray = BTFInterInstanceMetric.values();
                    int n = bTFInterInstanceMetricArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BTFInterInstanceMetric metric = bTFInterInstanceMetricArray[n2];
                        for (Map.Entry<BTFEntityType, Map.Entry<Enumerator, Enumerator>> et2fs : metric.entityType2FirstAndSecond.entrySet()) {
                            BTFEntityType entityType = et2fs.getKey();
                            String firstInstanceEvent = et2fs.getValue().getKey().toString();
                            String secondInstanceEvent = et2fs.getValue().getValue().toString();
                            atdbCon.insertInterEntityInstanceMetricValuesForEntityType(metric.toString(), (EntityType)entityType, firstInstanceEvent, secondInstanceEvent);
                        }
                        ++n2;
                    }
                });
                progressMonitor.worked(1);
                this.con.executeBatchUpdate(atdbCon -> {
                    String activateEvent = BTFInterInstanceMetric.activateToActivate.entityType2FirstAndSecond.entrySet().iterator().next().getValue().getKey().toString();
                    atdbCon.insertInterSourceEntityInstanceMetricValuesForEntityType(BTFInterInstanceMetric.activateToActivate.toString(), (EntityType)BTFEntityType.PROCESS, activateEvent);
                });
                progressMonitor.worked(1);
                this.con.executeBatchUpdate(atdbCon -> atdbCon.insertAggregatedEntityInstanceMetricsForDimension("time"));
                progressMonitor.worked(1);
                this.con.executeBatchUpdate(atdbCon -> {
                    BTFCountMetric[] bTFCountMetricArray = BTFCountMetric.values();
                    int n = bTFCountMetricArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BTFCountMetric cm = bTFCountMetricArray[n2];
                        atdbCon.insertMetric(cm.toString(), "count");
                        atdbCon.insertCountsForEntityTypeAndEvent(cm.toString(), (EntityType)cm.entityType, cm.eventToCount.toString().toLowerCase());
                        ++n2;
                    }
                });
                progressMonitor.worked(1);
            }
            catch (SQLException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

