/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.builder;

import java.util.function.Consumer;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.InterruptController;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.OsAPIOverhead;
import org.eclipse.app4mc.amalthea.model.OsDataConsistency;
import org.eclipse.app4mc.amalthea.model.OsISROverhead;
import org.eclipse.app4mc.amalthea.model.OsOverhead;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAssociation;
import org.eclipse.app4mc.amalthea.model.SchedulerDefinition;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.Semaphore;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.VendorOperatingSystem;

public class OperatingSystemBuilder {
    public OSModel osModelRoot(Consumer<OSModel> initializer) {
        OSModel obj = AmaltheaFactory.eINSTANCE.createOSModel();
        initializer.accept(obj);
        return obj;
    }

    public void operatingSystem(OSModel container, Consumer<OperatingSystem> initializer) {
        OperatingSystem obj = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        container.getOperatingSystems().add((Object)obj);
        initializer.accept(obj);
    }

    public void operatingSystem_Vendor(OSModel container, Consumer<VendorOperatingSystem> initializer) {
        VendorOperatingSystem obj = AmaltheaFactory.eINSTANCE.createVendorOperatingSystem();
        container.getOperatingSystems().add((Object)obj);
        initializer.accept(obj);
    }

    public void semaphore(OSModel container, Consumer<Semaphore> initializer) {
        Semaphore obj = AmaltheaFactory.eINSTANCE.createSemaphore();
        container.getSemaphores().add((Object)obj);
        initializer.accept(obj);
    }

    public void osOverhead(OSModel container, Consumer<OsOverhead> initializer) {
        OsOverhead obj = AmaltheaFactory.eINSTANCE.createOsOverhead();
        container.getOsOverheads().add((Object)obj);
        initializer.accept(obj);
    }

    public void schedulerDefinition(OSModel container, Consumer<SchedulerDefinition> initializer) {
        SchedulerDefinition obj = AmaltheaFactory.eINSTANCE.createSchedulerDefinition();
        container.getSchedulerDefinitions().add((Object)obj);
        initializer.accept(obj);
    }

    public void parameterDefinition(OSModel container, Consumer<SchedulingParameterDefinition> initializer) {
        SchedulingParameterDefinition obj = AmaltheaFactory.eINSTANCE.createSchedulingParameterDefinition();
        container.getSchedulingParameterDefinitions().add((Object)obj);
        initializer.accept(obj);
    }

    public void taskScheduler(OperatingSystem container, Consumer<TaskScheduler> initializer) {
        TaskScheduler obj = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        container.getTaskSchedulers().add((Object)obj);
        initializer.accept(obj);
    }

    public void schedulingParameter(Scheduler container, String parameterName, Value parameterValue) {
        SchedulerDefinition sd = container.getDefinition();
        sd.getAlgorithmParameters().stream().filter(pad -> pad.getName().equals(parameterName)).findFirst().ifPresent(spd -> {
            Object object = container.getSchedulingParameters().put(spd, (Object)parameterValue);
        });
    }

    public void interruptController(OperatingSystem container, Consumer<InterruptController> initializer) {
        InterruptController obj = AmaltheaFactory.eINSTANCE.createInterruptController();
        container.getInterruptControllers().add((Object)obj);
        initializer.accept(obj);
    }

    public void dataConsistency(OperatingSystem container, Consumer<OsDataConsistency> initializer) {
        OsDataConsistency obj = AmaltheaFactory.eINSTANCE.createOsDataConsistency();
        container.setOsDataConsistency(obj);
        initializer.accept(obj);
    }

    public void labelAccess(Scheduler container, Consumer<LabelAccess> initializer) {
        LabelAccess obj = AmaltheaFactory.eINSTANCE.createLabelAccess();
        container.getComputationItems().add((Object)obj);
        initializer.accept(obj);
    }

    public void parentAssociation(TaskScheduler container, Consumer<SchedulerAssociation> initializer) {
        SchedulerAssociation obj = AmaltheaFactory.eINSTANCE.createSchedulerAssociation();
        container.setParentAssociation(obj);
        initializer.accept(obj);
    }

    public void schedulingParameter(SchedulerAssociation container, String parameterName, Value parameterValue) {
        TaskScheduler sched = container.getParent();
        SchedulerDefinition sd = sched.getDefinition();
        sd.getProcessParameters().stream().filter(pad -> pad.getName().equals(parameterName)).findFirst().ifPresent(spd -> {
            Object object = container.getSchedulingParameters().put(spd, (Object)parameterValue);
        });
    }

    public void apiOverhead(OsOverhead container, Consumer<OsAPIOverhead> initializer) {
        OsAPIOverhead obj = AmaltheaFactory.eINSTANCE.createOsAPIOverhead();
        container.setApiOverhead(obj);
        initializer.accept(obj);
    }

    public void isrOverheadCat1(OsOverhead container, Consumer<OsISROverhead> initializer) {
        OsISROverhead obj = AmaltheaFactory.eINSTANCE.createOsISROverhead();
        container.setIsrCategory1Overhead(obj);
        initializer.accept(obj);
    }

    public void isrOverheadCat2(OsOverhead container, Consumer<OsISROverhead> initializer) {
        OsISROverhead obj = AmaltheaFactory.eINSTANCE.createOsISROverhead();
        container.setIsrCategory2Overhead(obj);
        initializer.accept(obj);
    }
}

