/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SamplingType implements Enumerator
{
    DEFAULT(0, "default", "default"),
    BEST_CASE(0, "BestCase", "BestCase"),
    WORST_CASE(0, "WorstCase", "WorstCase"),
    AVERAGE_CASE(0, "AverageCase", "AverageCase"),
    CORNER_CASE(0, "CornerCase", "CornerCase"),
    UNIFORM(0, "Uniform", "Uniform");

    public static final int DEFAULT_VALUE = 0;
    public static final int BEST_CASE_VALUE = 0;
    public static final int WORST_CASE_VALUE = 0;
    public static final int AVERAGE_CASE_VALUE = 0;
    public static final int CORNER_CASE_VALUE = 0;
    public static final int UNIFORM_VALUE = 0;
    private static final SamplingType[] VALUES_ARRAY;
    public static final List<SamplingType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SamplingType[]{DEFAULT, BEST_CASE, WORST_CASE, AVERAGE_CASE, CORNER_CASE, UNIFORM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SamplingType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SamplingType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SamplingType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SamplingType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SamplingType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
        }
        return null;
    }

    private SamplingType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

