/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb.wizard;

import java.io.File;
import org.eclipse.app4mc.amalthea._import.atdb.wizard.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ImportPage
extends WizardResourceImportPage {
    private Text sourceNameField;
    private Button extractLabelsAndAccesses;
    private Button extractRunnableRuntimes;
    private Composite handleExistingGroup;
    private boolean overwriteExisting = false;

    protected ImportPage(IStructuredSelection selection) {
        this("atdbImportPage", selection);
        this.setTitle(Messages.ImportPage_title);
        this.setMessage(Messages.ImportPage_message);
    }

    protected ImportPage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(Messages.ImportPage_fromATDB);
        groupLabel.setFont(parent.getFont());
        this.sourceNameField = new Text(sourceContainerGroup, 2056);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parent.getFont());
        Button sourceBrowseButton = new Button(sourceContainerGroup, 8);
        sourceBrowseButton.setText(IDEWorkbenchMessages.WizardImportPage_browse2);
        sourceBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportPage.this.selectFile();
            }
        });
        sourceBrowseButton.setLayoutData((Object)new GridData(256));
        sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(sourceBrowseButton);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.extractLabelsAndAccesses = new Button((Composite)optionsGroup, 32);
        this.extractLabelsAndAccesses.setFont(optionsGroup.getFont());
        this.extractLabelsAndAccesses.setText(Messages.ImportPage_optionExtractLabelsAndAccesses);
        this.extractLabelsAndAccesses.setSelection(true);
        this.extractRunnableRuntimes = new Button((Composite)optionsGroup, 32);
        this.extractRunnableRuntimes.setFont(optionsGroup.getFont());
        this.extractRunnableRuntimes.setText(Messages.ImportPage_optionExtractRunableRuntimes);
        this.extractRunnableRuntimes.setSelection(true);
        this.handleExistingGroup = new Composite((Composite)optionsGroup, 0);
        this.handleExistingGroup.setLayout((Layout)new RowLayout(256));
        Button updateExisting = new Button(this.handleExistingGroup, 16);
        updateExisting.setFont(optionsGroup.getFont());
        updateExisting.setText("Update existing");
        updateExisting.setSelection(true);
        updateExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    ImportPage.this.overwriteExisting = false;
                }
            }
        });
        Button localOverwriteExisting = new Button(this.handleExistingGroup, 16);
        localOverwriteExisting.setFont(optionsGroup.getFont());
        localOverwriteExisting.setText("Overwrite existing");
        localOverwriteExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    ImportPage.this.overwriteExisting = true;
                }
            }
        });
        this.handleExistingGroup.setVisible(false);
    }

    protected ITreeContentProvider getFileProvider() {
        return null;
    }

    protected ITreeContentProvider getFolderProvider() {
        return null;
    }

    protected boolean determinePageCompletion() {
        boolean result = super.determinePageCompletion();
        String path = this.sourceNameField.getText();
        File file = new File(path);
        return result &= file.exists();
    }

    private void selectFile() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText(Messages.ImportPage_selectFile);
        fileDialog.setFilterExtensions(new String[]{"*.atdb"});
        String open = fileDialog.open();
        if (open != null) {
            this.sourceNameField.setText(open);
            this.updateWidgetEnablements();
        }
    }

    protected void updateWidgetEnablements() {
        if (this.handleExistingGroup != null) {
            IFile target = this.getAMXMITarget();
            this.handleExistingGroup.setVisible(target != null && target.exists());
        }
        super.updateWidgetEnablements();
    }

    String getATDBSource() {
        return this.sourceNameField.getText();
    }

    IFile getAMXMITarget() {
        String source = this.getATDBSource();
        IContainer target = this.getTargetContainer();
        if (target == null || source.length() == 0) {
            return null;
        }
        int from = Math.max(source.lastIndexOf(47), source.lastIndexOf(92));
        int to = source.lastIndexOf(".atdb");
        String name = source.substring(from + 1, to);
        return target.getFile(target.getProjectRelativePath().append(name).addFileExtension("amxmi"));
    }

    IContainer getTargetContainer() {
        return this.getSpecifiedContainer();
    }

    boolean isExtractLabelsAndAccesses() {
        return this.extractLabelsAndAccesses == null || this.extractLabelsAndAccesses.getSelection();
    }

    boolean isExtractRunnableRuntimes() {
        return this.extractRunnableRuntimes == null || this.extractRunnableRuntimes.getSelection();
    }

    boolean isOverwriteExisting() {
        return this.overwriteExisting;
    }
}

