/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.util.Map;
import org.eclipse.core.externaltools.internal.model.BuilderCoreUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsModelMessages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class BuilderUtils {
    private static final String TAG_CONFIGURATION_MAP = "configurationMap";
    private static final String TAG_SOURCE_TYPE = "sourceType";
    private static final String TAG_BUILDER_TYPE = "builderType";

    public static ILaunchConfiguration configFromBuildCommandArgs(IProject project, Map commandArgs, String[] version) {
        return BuilderCoreUtils.configFromBuildCommandArgs((IProject)project, (Map)commandArgs, (String[])version);
    }

    public static ICommand commandFromLaunchConfig(IProject project, ILaunchConfiguration config) {
        ICommand newCommand = null;
        try {
            newCommand = project.getDescription().newCommand();
            newCommand = BuilderUtils.toBuildCommand(project, config, newCommand);
            BuilderUtils.configureTriggers(config, newCommand);
        }
        catch (CoreException coreException) {
            Shell shell = ExternalToolsPlugin.getActiveWorkbenchShell();
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)ExternalToolsModelMessages.BuilderUtils_5, (String)ExternalToolsModelMessages.BuilderUtils_6);
            }
            return null;
        }
        return newCommand;
    }

    public static void configureTriggers(ILaunchConfiguration config, ICommand newCommand) throws CoreException {
        BuilderCoreUtils.configureTriggers((ILaunchConfiguration)config, (ICommand)newCommand);
    }

    public static boolean isUnmigratedConfig(ILaunchConfiguration config) {
        return BuilderCoreUtils.isUnmigratedConfig((ILaunchConfiguration)config);
    }

    public static ICommand toBuildCommand(IProject project, ILaunchConfiguration config, ICommand command) throws CoreException {
        return BuilderCoreUtils.toBuildCommand((IProject)project, (ILaunchConfiguration)config, (ICommand)command);
    }

    public static ILaunchConfigurationType getConfigurationDuplicationType(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationType type;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.externaltools", "configurationDuplicationMaps");
        IConfigurationElement[] elements = ep.getConfigurationElements();
        String sourceType = config.getType().getIdentifier();
        String builderType = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(TAG_CONFIGURATION_MAP) && sourceType.equals(element.getAttribute(TAG_SOURCE_TYPE))) {
                builderType = element.getAttribute(TAG_BUILDER_TYPE);
                break;
            }
            ++i;
        }
        if (builderType != null && (type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(builderType)) != null) {
            return type;
        }
        return config.getType();
    }

    public static IFolder getBuilderFolder(IProject project, boolean create) {
        return BuilderCoreUtils.getBuilderFolder((IProject)project, (boolean)create);
    }

    public static ILaunchConfiguration duplicateConfiguration(IProject project, ILaunchConfiguration config) throws CoreException {
        Map attributes = config.getAttributes();
        String newName = config.getName() + ExternalToolsModelMessages.BuilderUtils_7;
        newName = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(newName);
        ILaunchConfigurationType newType = BuilderUtils.getConfigurationDuplicationType(config);
        ILaunchConfigurationWorkingCopy newWorkingCopy = newType.newInstance((IContainer)BuilderUtils.getBuilderFolder(project, true), newName);
        newWorkingCopy.setAttributes(attributes);
        return newWorkingCopy.doSave();
    }

    public static ILaunchConfiguration migrateBuilderConfiguration(IProject project, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        return BuilderCoreUtils.migrateBuilderConfiguration((IProject)project, (ILaunchConfigurationWorkingCopy)workingCopy);
    }

    public static int[] buildTypesToArray(String buildTypes) {
        return BuilderCoreUtils.buildTypesToArray((String)buildTypes);
    }
}

