/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.datafeed.IDataPointDefinition;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.internal.log.JavaUtilLoggerImpl;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.IExtChartModelLoader;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginSettings {
    private static final String PLUGIN = "org.eclipse.birt.chart.engine";
    public static final String PROP_STANDALONE = "STANDALONE";
    public static final String PROP_LOGGING_LEVEL = "LOGGING_LEVEL";
    public static final String PROP_LOGGING_DIR = "LOGGING_DIR";
    private static String[] saSeries = new String[]{"org.eclipse.birt.chart.model.component.impl.SeriesImpl", "org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl", "org.eclipse.birt.chart.model.type.impl.BarSeriesImpl", "org.eclipse.birt.chart.model.type.impl.DialSeriesImpl", "org.eclipse.birt.chart.model.type.impl.LineSeriesImpl", "org.eclipse.birt.chart.model.type.impl.PieSeriesImpl", "org.eclipse.birt.chart.model.type.impl.StockSeriesImpl", "org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl", "org.eclipse.birt.chart.model.type.impl.BubbleSeriesImpl", "org.eclipse.birt.chart.model.type.impl.GanttSeriesImpl", "org.eclipse.birt.chart.model.type.impl.DifferenceSeriesImpl"};
    private static String[] saDataSetProcessors = new String[]{"org.eclipse.birt.chart.extension.datafeed.DataSetProcessorImpl", "org.eclipse.birt.chart.extension.datafeed.DataSetProcessorImpl", "org.eclipse.birt.chart.extension.datafeed.DataSetProcessorImpl", "org.eclipse.birt.chart.extension.datafeed.DataSetProcessorImpl", "org.eclipse.birt.chart.extension.datafeed.DataSetProcessorImpl", "org.eclipse.birt.chart.extension.datafeed.DataSetProcessorImpl", "org.eclipse.birt.chart.extension.datafeed.StockDataSetProcessorImpl", "org.eclipse.birt.chart.extension.datafeed.DataSetProcessorImpl", "org.eclipse.birt.chart.extension.datafeed.BubbleDataSetProcessorImpl", "org.eclipse.birt.chart.extension.datafeed.GanttDataSetProcessorImpl", "org.eclipse.birt.chart.extension.datafeed.DifferenceDataSetProcessorImpl"};
    private static String[] saRenderers;
    private static String[][] saDevices;
    private static String[][] saDisplayServers;
    private static String[][] saBaseAggregateFunctions;
    private static String[] saDataPointDefinitions;
    private static PluginSettings ps;
    private boolean bStandalone = false;
    private static ILogger logger;
    private Map<String, Object> chartModelPackagesMap = null;

    static {
        String[] stringArray = new String[11];
        stringArray[1] = "org.eclipse.birt.chart.extension.render.Area";
        stringArray[2] = "org.eclipse.birt.chart.extension.render.Bar";
        stringArray[3] = "org.eclipse.birt.chart.extension.render.Dial";
        stringArray[4] = "org.eclipse.birt.chart.extension.render.Line";
        stringArray[5] = "org.eclipse.birt.chart.extension.render.Pie";
        stringArray[6] = "org.eclipse.birt.chart.extension.render.Stock";
        stringArray[7] = "org.eclipse.birt.chart.extension.render.Scatter";
        stringArray[8] = "org.eclipse.birt.chart.extension.render.Bubble";
        stringArray[9] = "org.eclipse.birt.chart.extension.render.Gantt";
        stringArray[10] = "org.eclipse.birt.chart.extension.render.Difference";
        saRenderers = stringArray;
        String[][] stringArrayArray = new String[11][];
        String[] stringArray2 = new String[4];
        stringArray2[0] = "dv.SWING";
        stringArray2[1] = "org.eclipse.birt.chart.device.swing.SwingRendererImpl";
        stringArrayArray[0] = stringArray2;
        String[] stringArray3 = new String[4];
        stringArray3[0] = "dv.SWT";
        stringArray3[1] = "org.eclipse.birt.chart.device.swt.SwtRendererImpl";
        stringArrayArray[1] = stringArray3;
        String[] stringArray4 = new String[4];
        stringArray4[0] = "dv.PNG24";
        stringArray4[1] = "org.eclipse.birt.chart.device.image.PngRendererImpl";
        stringArray4[3] = "Deprecated, use PNG instead";
        stringArrayArray[2] = stringArray4;
        String[] stringArray5 = new String[4];
        stringArray5[0] = "dv.GIF8";
        stringArray5[1] = "org.eclipse.birt.chart.device.image.GifRendererImpl";
        stringArray5[3] = "Deprecated, use PNG instead";
        stringArrayArray[3] = stringArray5;
        stringArrayArray[4] = new String[]{"dv.PNG", "org.eclipse.birt.chart.device.image.PngRendererImpl", "PNG", "Portable Network Graphics"};
        String[] stringArray6 = new String[4];
        stringArray6[0] = "dv.GIF";
        stringArray6[1] = "org.eclipse.birt.chart.device.image.GifRendererImpl";
        stringArray6[3] = "Deprecated, use PNG instead";
        stringArrayArray[5] = stringArray6;
        String[] stringArray7 = new String[4];
        stringArray7[0] = "dv.JPEG";
        stringArray7[1] = "org.eclipse.birt.chart.device.image.JpegRendererImpl";
        stringArrayArray[6] = stringArray7;
        String[] stringArray8 = new String[4];
        stringArray8[0] = "dv.JPG";
        stringArray8[1] = "org.eclipse.birt.chart.device.image.JpegRendererImpl";
        stringArray8[2] = "JPG";
        stringArrayArray[7] = stringArray8;
        String[] stringArray9 = new String[4];
        stringArray9[0] = "dv.BMP";
        stringArray9[1] = "org.eclipse.birt.chart.device.image.BmpRendererImpl";
        stringArray9[2] = "BMP";
        stringArrayArray[8] = stringArray9;
        String[] stringArray10 = new String[4];
        stringArray10[0] = "dv.SVG";
        stringArray10[1] = "org.eclipse.birt.chart.device.svg.SVGRendererImpl";
        stringArray10[2] = "SVG";
        stringArrayArray[9] = stringArray10;
        String[] stringArray11 = new String[4];
        stringArray11[0] = "dv.PDF";
        stringArray11[1] = "org.eclipse.birt.chart.device.pdf.PDFRendererImpl";
        stringArray11[2] = "PDF";
        stringArrayArray[10] = stringArray11;
        saDevices = stringArrayArray;
        saDisplayServers = new String[][]{{"ds.SWING", "org.eclipse.birt.chart.device.swing.SwingDisplayServer"}, {"ds.SWT", "org.eclipse.birt.chart.device.swt.SwtDisplayServer"}, {"ds.SVG", "org.eclipse.birt.chart.device.svg.SVGDisplayServer"}, {"ds.PDF", "org.eclipse.birt.chart.device.pdf.PDFDisplayServer"}};
        saBaseAggregateFunctions = new String[][]{{"Sum", "Sum", "org.eclipse.birt.chart.extension.aggregate.Sum"}, {"Average", "Average", "org.eclipse.birt.chart.extension.aggregate.Average"}, {"Count", "Count", "org.eclipse.birt.chart.extension.aggregate.Count"}, {"DistinctCount", "DistinctCount", "org.eclipse.birt.chart.extension.aggregate.DistinctCount"}, {"First", "First", "org.eclipse.birt.chart.extension.aggregate.First"}, {"Last", "Last", "org.eclipse.birt.chart.extension.aggregate.Last"}, {"Min", "Min", "org.eclipse.birt.chart.extension.aggregate.Min"}, {"Max", "Max", "org.eclipse.birt.chart.extension.aggregate.Max"}};
        String[] stringArray12 = new String[11];
        stringArray12[6] = "org.eclipse.birt.chart.extension.datafeed.StockDataPointDefinition";
        stringArray12[8] = "org.eclipse.birt.chart.extension.datafeed.BubbleDataPointDefinition";
        stringArray12[9] = "org.eclipse.birt.chart.extension.datafeed.GanttDataPointDefinition";
        stringArray12[10] = "org.eclipse.birt.chart.extension.datafeed.DifferenceDataPointDefinition";
        saDataPointDefinitions = stringArray12;
        ps = null;
        logger = Logger.getLogger("org.eclipse.birt.chart.engine/util");
    }

    private PluginSettings() {
    }

    public static PluginSettings instance() {
        return PluginSettings.instance(null);
    }

    public static synchronized PluginSettings instance(PlatformConfig config) {
        if (ps == null) {
            ps = new PluginSettings();
            String loggingDir = null;
            Level loggingLevel = null;
            if (config != null) {
                PluginSettings.ps.bStandalone = config.getProperty(PROP_STANDALONE) != null;
                loggingDir = (String)config.getProperty(PROP_LOGGING_DIR);
                loggingLevel = (Level)config.getProperty(PROP_LOGGING_LEVEL);
            }
            if (!PluginSettings.ps.bStandalone) {
                try {
                    Platform.startup((PlatformConfig)config);
                }
                catch (BirtException e) {
                    logger.log((Exception)((Object)e));
                }
            }
            ps.initFileLogger(loggingDir, loggingLevel);
        }
        return ps;
    }

    private void initFileLogger(String loggingDir, Level loggingLevel) {
        if (loggingLevel != null && loggingLevel == Level.OFF) {
            return;
        }
        try {
            String dir = null;
            if (loggingDir != null) {
                dir = loggingDir;
            }
            JavaUtilLoggerImpl.initFileHandler(dir, loggingLevel);
        }
        catch (SecurityException e) {
            logger.log(e);
        }
        catch (IOException e) {
            logger.log(e);
        }
    }

    public final IDataSetProcessor getDataSetProcessor(Class<?> cSeries) throws ChartException {
        String sFQClassName = cSeries.getName();
        if (this.inEclipseEnv()) {
            Object oDSP = PluginSettings.getPluginXmlObject("datasetprocessors", "datasetProcessor", "series", "processor", sFQClassName);
            if (oDSP != null) {
                logger.log(1, Messages.getString("info.eclenv.creating.dsp", new Object[]{oDSP.getClass().getName()}, ULocale.getDefault()));
                return (IDataSetProcessor)oDSP;
            }
            logger.log(8, Messages.getString("error.eclenv.cannot.find.dsp", new Object[]{sFQClassName}, ULocale.getDefault()));
        } else {
            int i = 0;
            while (i < saSeries.length) {
                if (sFQClassName.equals(saSeries[i])) {
                    logger.log(1, Messages.getString("info.stdenv.creating.dsp", new Object[]{saDataSetProcessors[i]}, ULocale.getDefault()));
                    return (IDataSetProcessor)PluginSettings.newInstance(saDataSetProcessors[i]);
                }
                ++i;
            }
            logger.log(8, Messages.getString("error.stdenv.cannot.find.dsp", new Object[]{sFQClassName}, ULocale.getDefault()));
        }
        return null;
    }

    public final Map<String, Object> getExtChartModelPackages() throws ChartException {
        if (this.chartModelPackagesMap != null) {
            return this.chartModelPackagesMap;
        }
        this.chartModelPackagesMap = new LinkedHashMap<String, Object>();
        if (!this.inEclipseEnv()) {
            return this.chartModelPackagesMap;
        }
        String sXsdListName = "charttypes";
        String sXsdComplexName = "chartType";
        String sXsdElementName = "namespaceURI";
        String sXsdElementValue = "modelLoader";
        IExtensionRegistry ier = Platform.getExtensionRegistry();
        IExtensionPoint iep = ier.getExtensionPoint(PLUGIN, sXsdListName);
        if (iep == null) {
            throw new ChartException(PLUGIN, 10, "exception.cannot.find.plugin.entry", new Object[]{"", sXsdElementName, sXsdElementValue}, Messages.getResourceBundle());
        }
        IExtension[] iea = iep.getExtensions();
        int i = 0;
        while (i < iea.length) {
            IConfigurationElement[] icea = iea[i].getConfigurationElements();
            int j = 0;
            while (j < icea.length) {
                if (icea[j].getName().equals(sXsdComplexName)) {
                    try {
                        this.chartModelPackagesMap.put(icea[j].getAttribute(sXsdElementName), ((IExtChartModelLoader)icea[j].createExecutableExtension(sXsdElementValue)).getChartTypePackage());
                    }
                    catch (FrameworkException cex) {
                        throw new ChartException(PLUGIN, 10, cex);
                    }
                }
                ++j;
            }
            ++i;
        }
        return this.chartModelPackagesMap;
    }

    public final BaseRenderer getRenderer(Class<?> cSeries) throws ChartException {
        String sFQClassName = cSeries.getName();
        if (this.inEclipseEnv()) {
            Object oSeriesRenderer = PluginSettings.getPluginXmlObject("modelrenderers", "modelRenderer", "series", "renderer", sFQClassName);
            if (oSeriesRenderer != null) {
                logger.log(1, Messages.getString("info.eclenv.creating.series.renderer", new Object[]{oSeriesRenderer.getClass().getName()}, ULocale.getDefault()));
                return (BaseRenderer)oSeriesRenderer;
            }
            logger.log(4, Messages.getString("error.eclenv.cannot.find.series.renderer", new Object[]{sFQClassName}, ULocale.getDefault()));
        } else {
            int i = 0;
            while (i < saSeries.length) {
                if (sFQClassName.equals(saSeries[i])) {
                    if (saRenderers[i] == null) break;
                    logger.log(1, Messages.getString("info.stdenv.creating.series.renderer", new Object[]{saRenderers[i]}, ULocale.getDefault()));
                    return (BaseRenderer)PluginSettings.newInstance(saRenderers[i]);
                }
                ++i;
            }
            logger.log(4, Messages.getString("error.stdenv.cannot.find.series.renderer", new Object[]{sFQClassName}, ULocale.getDefault()));
        }
        return null;
    }

    public final IDeviceRenderer getDevice(String sName) throws ChartException {
        if (this.inEclipseEnv()) {
            Object oDeviceRenderer = PluginSettings.getPluginXmlObject("devicerenderers", "deviceRenderer", "name", "device", sName);
            if (oDeviceRenderer != null) {
                logger.log(1, Messages.getString("info.eclenv.creating.device", new Object[]{sName, oDeviceRenderer.getClass().getName()}, ULocale.getDefault()));
                String sFormat = PluginSettings.getPluginXmlAttribute("devicerenderers", "deviceRenderer", "name", "format", sName);
                if (sFormat != null && sFormat.length() > 0) {
                    ((IDeviceRenderer)oDeviceRenderer).setProperty("device.output.format.identifier", sFormat);
                }
                return (IDeviceRenderer)oDeviceRenderer;
            }
            logger.log(8, Messages.getString("error.eclenv.cannot.find.device", new Object[]{sName}, ULocale.getDefault()));
        } else {
            int i = 0;
            while (i < saDevices.length) {
                if (saDevices[i][0].equalsIgnoreCase(sName)) {
                    logger.log(1, Messages.getString("info.stdenv.creating.device", new Object[]{sName, saDevices[i][1]}, ULocale.getDefault()));
                    IDeviceRenderer idr = (IDeviceRenderer)PluginSettings.newInstance(saDevices[i][1]);
                    if (saDevices[i][2] != null && saDevices[i][2].length() > 0) {
                        idr.setProperty("device.output.format.identifier", saDevices[i][2]);
                    }
                    return idr;
                }
                ++i;
            }
            logger.log(8, Messages.getString("error.stdenv.cannot.find.device", new Object[]{sName}, ULocale.getDefault()));
        }
        return null;
    }

    public final IDisplayServer getDisplayServer(String sName) throws ChartException {
        if (this.inEclipseEnv()) {
            Object oDisplayServer = PluginSettings.getPluginXmlObject("displayservers", "displayserver", "name", "server", sName);
            if (oDisplayServer != null) {
                logger.log(1, Messages.getString("info.eclenv.creating.display", new Object[]{sName, oDisplayServer.getClass().getName()}, ULocale.getDefault()));
                return (IDisplayServer)oDisplayServer;
            }
            logger.log(8, Messages.getString("error.eclenv.cannot.find.display", new Object[]{sName}, ULocale.getDefault()));
        } else {
            int i = 0;
            while (i < saDisplayServers.length) {
                if (saDisplayServers[i][0].equalsIgnoreCase(sName)) {
                    logger.log(1, Messages.getString("info.stdenv.creating.display", new Object[]{sName, saDisplayServers[i][1]}, ULocale.getDefault()));
                    return (IDisplayServer)PluginSettings.newInstance(saDisplayServers[i][1]);
                }
                ++i;
            }
            logger.log(8, Messages.getString("error.stdenv.cannot.find.display", new Object[]{sName}, ULocale.getDefault()));
        }
        return null;
    }

    public final IAggregateFunction getAggregateFunction(String sName) throws ChartException {
        if (this.inEclipseEnv()) {
            Object oAggregateFunction = PluginSettings.getPluginXmlObject("aggregatefunctions", "aggregateFunction", "name", "function", sName);
            if (oAggregateFunction != null) {
                logger.log(1, Messages.getString("info.eclenv.creating.function", new Object[]{sName, oAggregateFunction.getClass().getName()}, ULocale.getDefault()));
                return (IAggregateFunction)oAggregateFunction;
            }
            logger.log(8, Messages.getString("error.eclenv.cannot.find.function", new Object[]{sName}, ULocale.getDefault()));
        } else {
            int i = 0;
            while (i < saBaseAggregateFunctions.length) {
                if (saBaseAggregateFunctions[i][0].equalsIgnoreCase(sName)) {
                    logger.log(1, Messages.getString("info.stdenv.creating.function", new Object[]{sName, saBaseAggregateFunctions[i][1]}, ULocale.getDefault()));
                    return (IAggregateFunction)PluginSettings.newInstance(saBaseAggregateFunctions[i][2]);
                }
                ++i;
            }
            logger.log(8, Messages.getString("error.stdenv.cannot.find.function", new Object[]{sName}, ULocale.getDefault()));
        }
        return null;
    }

    public final IDataPointDefinition getDataPointDefinition(Class<?> cSeries) throws ChartException {
        String sFQClassName = cSeries.getName();
        if (this.inEclipseEnv()) {
            Object oDefinition = PluginSettings.getPluginXmlObject("datapointdefinitions", "datapointDefinition", "series", "definition", sFQClassName);
            if (oDefinition != null) {
                logger.log(1, Messages.getString("info.eclenv.creating.datapoint.definition", new Object[]{oDefinition.getClass().getName()}, ULocale.getDefault()));
                return (IDataPointDefinition)oDefinition;
            }
            logger.log(4, Messages.getString("error.stdenv.cannot.find.datapoint.definition", new Object[]{sFQClassName}, ULocale.getDefault()));
        } else {
            int i = 0;
            while (i < saDataPointDefinitions.length) {
                if (sFQClassName.equals(saSeries[i])) {
                    if (saDataPointDefinitions[i] == null) break;
                    logger.log(1, Messages.getString("info.eclenv.creating.datapoint.definition", new Object[]{saRenderers[i]}, ULocale.getDefault()));
                    return (IDataPointDefinition)PluginSettings.newInstance(saDataPointDefinitions[i]);
                }
                ++i;
            }
            logger.log(4, Messages.getString("error.stdenv.cannot.find.datapoint.definition", new Object[]{sFQClassName}, ULocale.getDefault()));
        }
        return null;
    }

    public final String getSeriesDisplayName(final String seriesClassName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String sDisplayName = seriesClassName;
                try {
                    Class<?> seriesClass = Class.forName(seriesClassName);
                    Method createMethod = seriesClass.getDeclaredMethod("create", new Class[0]);
                    Series newSeries = (Series)createMethod.invoke(seriesClass, new Object[0]);
                    Method mDisplayName = seriesClass.getDeclaredMethod("getDisplayName", new Class[0]);
                    Object oName = mDisplayName.invoke((Object)newSeries, new Object[0]);
                    sDisplayName = (String)oName;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                return sDisplayName;
            }
        });
    }

    public final String[] getRegisteredSeries() throws ChartException {
        if (this.inEclipseEnv()) {
            String[][] sers = PluginSettings.getPluginXmlStrings("modelrenderers", "modelRenderer", "series", "renderer");
            String[] saSeries = new String[sers.length];
            int i = 0;
            while (i < saSeries.length) {
                saSeries[i] = sers[i][0];
                ++i;
            }
            return saSeries;
        }
        return saSeries;
    }

    public final String[][] getRegisteredOutputFormats() throws ChartException {
        if (this.inEclipseEnv()) {
            String[][] formats = PluginSettings.getPluginXmlStrings("devicerenderers", "deviceRenderer", "format", "displayName");
            ArrayList<String[]> al = new ArrayList<String[]>();
            int i = 0;
            while (i < formats.length) {
                if (formats[i][0] != null && formats[i][0].length() > 0) {
                    al.add(formats[i]);
                }
                ++i;
            }
            return (String[][])al.toArray((T[])new String[0][0]);
        }
        ArrayList<String[]> al = new ArrayList<String[]>();
        int i = 0;
        while (i < saDevices.length) {
            if (saDevices[i][2] != null && saDevices[i][2].length() > 0) {
                al.add(new String[]{saDevices[i][2], saDevices[i][3]});
            }
            ++i;
        }
        return (String[][])al.toArray((T[])new String[0][0]);
    }

    public final String[] getRegisteredAggregateFunctions() throws ChartException {
        if (this.inEclipseEnv()) {
            String[][] aggs = PluginSettings.getPluginXmlStrings("aggregatefunctions", "aggregateFunction", "name", "function");
            String[] saFunctions = new String[aggs.length];
            int i = 0;
            while (i < saFunctions.length) {
                saFunctions[i] = aggs[i][0];
                ++i;
            }
            return saFunctions;
        }
        String[] saFunctions = new String[saBaseAggregateFunctions.length];
        int i = 0;
        while (i < saFunctions.length) {
            saFunctions[i] = saBaseAggregateFunctions[i][0];
            ++i;
        }
        return saFunctions;
    }

    public final String[] getRegisteredAggregateFunctions(int aggregateType) throws ChartException {
        if (this.inEclipseEnv()) {
            String[][] aggs = PluginSettings.getPluginXmlStrings("aggregatefunctions", "aggregateFunction", "name", "function");
            ArrayList<String> funcList = new ArrayList<String>();
            int i = 0;
            while (i < aggs.length) {
                IAggregateFunction aFunc = this.getAggregateFunction(aggs[i][0]);
                if (aFunc.getType() == aggregateType) {
                    funcList.add(aggs[i][0]);
                }
                ++i;
            }
            String[] saFunctions = new String[funcList.size()];
            int i2 = 0;
            while (i2 < saFunctions.length) {
                saFunctions[i2] = (String)funcList.get(i2);
                ++i2;
            }
            return saFunctions;
        }
        String[] saFunctions = new String[saBaseAggregateFunctions.length];
        int i = 0;
        while (i < saFunctions.length) {
            saFunctions[i] = saBaseAggregateFunctions[i][0];
            ++i;
        }
        return saFunctions;
    }

    public final String[] getRegisteredAggregateFunctionDisplayNames() throws ChartException {
        if (this.inEclipseEnv()) {
            String[][] aggs = PluginSettings.getPluginXmlStrings("aggregatefunctions", "aggregateFunction", "name", "displayName");
            String[] saFunctions = new String[aggs.length];
            int i = 0;
            while (i < saFunctions.length) {
                saFunctions[i] = aggs[i][1];
                ++i;
            }
            return saFunctions;
        }
        String[] saFunctions = new String[saBaseAggregateFunctions.length];
        int i = 0;
        while (i < saFunctions.length) {
            saFunctions[i] = saBaseAggregateFunctions[i][1];
            ++i;
        }
        return saFunctions;
    }

    public final String[] getRegisteredAggregateFunctionDisplayNames(int aggregateType) throws ChartException {
        if (this.inEclipseEnv()) {
            String[][] aggs = PluginSettings.getPluginXmlStrings("aggregatefunctions", "aggregateFunction", "name", "displayName");
            ArrayList<String> funcList = new ArrayList<String>();
            int i = 0;
            while (i < aggs.length) {
                IAggregateFunction aFunc = this.getAggregateFunction(aggs[i][0]);
                if (aFunc.getType() == aggregateType) {
                    funcList.add(aggs[i][1]);
                }
                ++i;
            }
            String[] saFunctions = new String[funcList.size()];
            int i2 = 0;
            while (i2 < saFunctions.length) {
                saFunctions[i2] = (String)funcList.get(i2);
                ++i2;
            }
            return saFunctions;
        }
        String[] saFunctions = new String[saBaseAggregateFunctions.length];
        int i = 0;
        while (i < saFunctions.length) {
            saFunctions[i] = saBaseAggregateFunctions[i][1];
            ++i;
        }
        return saFunctions;
    }

    private static final Object newInstance(String sFQClassName) throws ChartException {
        try {
            Class<?> c = Class.forName(sFQClassName);
            return SecurityUtil.newClassInstance(c);
        }
        catch (Exception ex) {
            throw new ChartException(PLUGIN, 10, ex);
        }
    }

    private static final Object getPluginXmlObject(String sXsdListName, String sXsdComplexName, String sXsdElementName, String sXsdElementValue, String sLookupName) throws ChartException {
        IExtensionRegistry ier = Platform.getExtensionRegistry();
        IExtensionPoint iep = ier.getExtensionPoint(PLUGIN, sXsdListName);
        if (iep == null) {
            throw new ChartException(PLUGIN, 10, "exception.cannot.find.plugin.entry", new Object[]{sLookupName, sXsdElementName, sXsdElementValue}, Messages.getResourceBundle());
        }
        IExtension[] iea = iep.getExtensions();
        int i = 0;
        while (i < iea.length) {
            IConfigurationElement[] icea = iea[i].getConfigurationElements();
            int j = 0;
            while (j < icea.length) {
                if (icea[j].getName().equals(sXsdComplexName) && icea[j].getAttribute(sXsdElementName).equals(sLookupName)) {
                    try {
                        return icea[j].createExecutableExtension(sXsdElementValue);
                    }
                    catch (FrameworkException cex) {
                        throw new ChartException(PLUGIN, 10, cex);
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static final String getPluginXmlAttribute(String sXsdListName, String sXsdComplexName, String sXsdElementName, String sXsdElementValue, String sLookupName) throws ChartException {
        IExtensionRegistry ier = Platform.getExtensionRegistry();
        IExtensionPoint iep = ier.getExtensionPoint(PLUGIN, sXsdListName);
        if (iep == null) {
            throw new ChartException(PLUGIN, 10, "exception.cannot.find.plugin.entry", new Object[]{sLookupName, sXsdElementName, sXsdElementValue}, Messages.getResourceBundle());
        }
        IExtension[] iea = iep.getExtensions();
        int i = 0;
        while (i < iea.length) {
            IConfigurationElement[] icea = iea[i].getConfigurationElements();
            int j = 0;
            while (j < icea.length) {
                if (icea[j].getName().equals(sXsdComplexName) && icea[j].getAttribute(sXsdElementName).equals(sLookupName)) {
                    return icea[j].getAttribute(sXsdElementValue);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static final String[][] getPluginXmlStrings(String sXsdListName, String sXsdComplexName, String sXsdElementName, String sXsdElementValue) throws ChartException {
        IExtensionRegistry ier = Platform.getExtensionRegistry();
        IExtensionPoint iep = ier.getExtensionPoint(PLUGIN, sXsdListName);
        if (iep == null) {
            throw new ChartException(PLUGIN, 10, "exception.cannot.find.plugin.entry", new Object[]{"", sXsdElementName, sXsdElementValue}, Messages.getResourceBundle());
        }
        IExtension[] iea = iep.getExtensions();
        ArrayList<String[]> lst = new ArrayList<String[]>();
        int i = 0;
        while (i < iea.length) {
            IConfigurationElement[] icea = iea[i].getConfigurationElements();
            int j = 0;
            while (j < icea.length) {
                if (icea[j].getName().equals(sXsdComplexName)) {
                    lst.add(new String[]{icea[j].getAttribute(sXsdElementName), icea[j].getAttribute(sXsdElementValue)});
                }
                ++j;
            }
            ++i;
        }
        return (String[][])lst.toArray((T[])new String[0][0]);
    }

    public boolean inEclipseEnv() {
        if (this.bStandalone) {
            return false;
        }
        return Platform.getExtensionRegistry() != null;
    }

    public final void registerAggregateFunction(String sName, String sAggregateFunctionClass) {
        this.registerAggregateFunction(sName, sName, sAggregateFunctionClass);
    }

    public final synchronized void registerAggregateFunction(String sName, String sDisplayName, String sAggregateFunctionClass) {
        String[][] newAggFuncs = new String[saBaseAggregateFunctions.length + 1][3];
        int i = 0;
        while (i < saBaseAggregateFunctions.length) {
            newAggFuncs[i][0] = saBaseAggregateFunctions[i][0];
            newAggFuncs[i][1] = saBaseAggregateFunctions[i][1];
            newAggFuncs[i][2] = saBaseAggregateFunctions[i][2];
            ++i;
        }
        newAggFuncs[PluginSettings.saBaseAggregateFunctions.length][0] = sName;
        newAggFuncs[PluginSettings.saBaseAggregateFunctions.length][1] = sDisplayName;
        newAggFuncs[PluginSettings.saBaseAggregateFunctions.length][2] = sAggregateFunctionClass;
        saBaseAggregateFunctions = newAggFuncs;
    }

    public final synchronized void registerDevice(String sName, String sDeviceClass) {
        String[][] newDevs = new String[saDevices.length + 1][4];
        int i = 0;
        while (i < saDevices.length) {
            newDevs[i][0] = saDevices[i][0];
            newDevs[i][1] = saDevices[i][1];
            newDevs[i][2] = saDevices[i][2];
            newDevs[i][3] = saDevices[i][3];
            ++i;
        }
        newDevs[PluginSettings.saDevices.length][0] = sName;
        newDevs[PluginSettings.saDevices.length][1] = sDeviceClass;
        saDevices = newDevs;
    }

    public final synchronized void registerOutputFormat(String sDeviceName, String sFormat, String sDescription) {
        int i = 0;
        while (i < saDevices.length) {
            if (saDevices[i][0].equals(sDeviceName)) {
                if (sFormat != null && sFormat.length() > 0) {
                    PluginSettings.saDevices[i][2] = sFormat;
                }
                if (sDescription == null || sDescription.length() <= 0) break;
                PluginSettings.saDevices[i][3] = sDescription;
                break;
            }
            ++i;
        }
    }

    public final synchronized void registerDisplayServer(String sName, String sServerClass) {
        String[][] newSvrs = new String[saDisplayServers.length + 1][2];
        int i = 0;
        while (i < saDisplayServers.length) {
            newSvrs[i][0] = saDisplayServers[i][0];
            newSvrs[i][1] = saDisplayServers[i][1];
            ++i;
        }
        newSvrs[PluginSettings.saDisplayServers.length][0] = sName;
        newSvrs[PluginSettings.saDisplayServers.length][1] = sServerClass;
        saDisplayServers = newSvrs;
    }

    public final synchronized void registerSeriesRenderer(String sSeriesClass, String sDataSetProcessorClass, String sRendererClass) {
        String[] newSeries = new String[saSeries.length + 1];
        String[] newDSPs = new String[saSeries.length + 1];
        String[] newRenderers = new String[saSeries.length + 1];
        int i = 0;
        while (i < saSeries.length) {
            newSeries[i] = saSeries[i];
            newDSPs[i] = saDataSetProcessors[i];
            newRenderers[i] = saRenderers[i];
            ++i;
        }
        newSeries[PluginSettings.saSeries.length] = sSeriesClass;
        newDSPs[PluginSettings.saSeries.length] = sDataSetProcessorClass;
        newRenderers[PluginSettings.saSeries.length] = sRendererClass;
        saSeries = newSeries;
        saDataSetProcessors = newDSPs;
        saRenderers = newRenderers;
    }

    public static final class DefaultAggregations {
        public static final String SUM = "Sum";
        public static final String AVERAGE = "Average";
        public static final String COUNT = "Count";
        public static final String DISTINCT_COUNT = "DistinctCount";
        public static final String FIRST = "First";
        public static final String LAST = "Last";
        public static final String MIN = "Min";
        public static final String MAX = "Max";
        public static final String WEIGHTED_AVERAGE = "WeightedAverage";
        public static final String MEDIAN = "Median";
        public static final String MODE = "Mode";
        public static final String STDDEV = "STDDEV";
        public static final String VARIANCE = "Variance";
        public static final String IRR = "Irr";
        public static final String MIRR = "Mirr";
        public static final String NPV = "NPV";
        public static final String PERCENTILE = "Percentile";
        public static final String QUARTILE = "Quartile";
        public static final String MOVING_AVERAGE = "MovingAverage";
        public static final String RUNNING_SUM = "RunningSum";
        public static final String RUNNING_NPV = "RunningNPV";
        public static final String RANK = "Rank";
        public static final String TOP = "Top";
        public static final String TOP_PERCENT = "TopPercent";
        public static final String BOTTOM = "Bottom";
        public static final String BOTTOM_PERCENT = "BottomPercent";
        public static final String PERCENT_RANK = "PercentRank";
        public static final String PERCENT_SUM = "PercentSum";
        public static final String RUNNING_COUNT = "RunningCount";
    }
}

