/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import java.io.File;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mylyn.commons.core.XmlMemento;
import org.eclipse.mylyn.commons.ui.Messages;
import org.eclipse.mylyn.commons.ui.TableColumnDescriptor;
import org.eclipse.mylyn.commons.ui.TableColumnDescriptorDialog;
import org.eclipse.mylyn.commons.ui.TableViewerSupport;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class ConfigurableColumnTableViewerSupport
extends TableViewerSupport {
    private static final String xmlChildName = "TableColumnDescriptors";
    private static final String xmlFieldAlignment = "alignment";
    private static final String xmlFieldSortDirection = "sortDirection";
    private static final String xmlFieldWidth = "width";
    private static final String xmlFieldAutoSize = "autoSize";
    private static final String xmlFieldDefaultSortColumn = "defaultSortColumn";
    private final TableViewer viewer;
    private final TableColumnDescriptor[] columnDescriptors;

    public ConfigurableColumnTableViewerSupport(TableViewer viewer, TableColumnDescriptor[] columnDescriptors, File stateFile) {
        super(viewer, stateFile);
        this.columnDescriptors = columnDescriptors;
        this.viewer = viewer;
        this.createConfigureColumnsAction(this.getHeaderMenu());
    }

    public ConfigurableColumnTableViewerSupport(TableViewer viewer, TableColumnDescriptor[] columnDescriptors, File stateFile, boolean[] defaultVisibilities) {
        super(viewer, stateFile, defaultVisibilities);
        this.viewer = viewer;
        this.columnDescriptors = columnDescriptors;
        this.createConfigureColumnsAction(this.getHeaderMenu());
    }

    private void createConfigureColumnsAction(Menu parent) {
        new MenuItem(parent, 2);
        MenuItem configureColumns = new MenuItem(parent, 8);
        configureColumns.setText(Messages.ConfigurableColumnTableViewerSupport_Configure_Columns);
        configureColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnDescriptor[] tempColumnDescriptors = new TableColumnDescriptor[ConfigurableColumnTableViewerSupport.this.columnDescriptors.length];
                int i = tempColumnDescriptors.length - 1;
                while (i >= 0) {
                    tempColumnDescriptors[i] = new TableColumnDescriptor(ConfigurableColumnTableViewerSupport.this.columnDescriptors[i]);
                    --i;
                }
                TableColumnDescriptorDialog selectionDialog = new TableColumnDescriptorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), tempColumnDescriptors);
                selectionDialog.create();
                int resultCode = selectionDialog.open();
                if (resultCode == 0) {
                    int i2 = 0;
                    while (i2 < tempColumnDescriptors.length) {
                        TableColumnDescriptor tempTableColumnDescriptor = tempColumnDescriptors[i2];
                        TableColumnDescriptor orgTableColumnDescriptor = ConfigurableColumnTableViewerSupport.this.columnDescriptors[i2];
                        if (!orgTableColumnDescriptor.equals(tempTableColumnDescriptor)) {
                            TableColumn tableColumn = ConfigurableColumnTableViewerSupport.this.viewer.getTable().getColumn(i2);
                            orgTableColumnDescriptor.setAlignment(tempTableColumnDescriptor.getAlignment());
                            tableColumn.setAlignment(tempTableColumnDescriptor.getAlignment());
                            orgTableColumnDescriptor.setWidth(tempTableColumnDescriptor.getWidth());
                            tableColumn.setWidth(tempTableColumnDescriptor.getWidth());
                            orgTableColumnDescriptor.setSortDirection(tempTableColumnDescriptor.getSortDirection());
                            orgTableColumnDescriptor.setDefaultSortColumn(tempTableColumnDescriptor.isDefaultSortColumn());
                            if (tempTableColumnDescriptor.isDefaultSortColumn()) {
                                ConfigurableColumnTableViewerSupport.this.viewer.getTable().setSortColumn(tableColumn);
                                ConfigurableColumnTableViewerSupport.this.viewer.getTable().setSortDirection(tempTableColumnDescriptor.getSortDirection());
                            }
                            orgTableColumnDescriptor.setAutoSize(tempTableColumnDescriptor.isAutoSize());
                        }
                        ++i2;
                    }
                }
            }
        });
    }

    @Override
    protected void saveAdditionalChildInfo(XmlMemento child, TableColumn column) {
        TableColumnDescriptor desc = (TableColumnDescriptor)column.getData("org.eclipse.mylyn.commons.ui.TableColumnDescriptors");
        XmlMemento descriptor = child.createChild(xmlChildName);
        descriptor.putInteger(xmlFieldAlignment, desc.getAlignment());
        descriptor.putInteger(xmlFieldSortDirection, desc.getSortDirection());
        descriptor.putInteger(xmlFieldWidth, desc.getWidth());
        descriptor.putBoolean(xmlFieldAutoSize, desc.isAutoSize());
        descriptor.putBoolean(xmlFieldDefaultSortColumn, desc.isDefaultSortColumn());
    }

    @Override
    protected void restoreAdditionalChildInfo(XmlMemento xmlMemento, TableColumn column) {
        TableColumnDescriptor desc = (TableColumnDescriptor)column.getData("org.eclipse.mylyn.commons.ui.TableColumnDescriptors");
        XmlMemento mementoDesc = xmlMemento.getChild(xmlChildName);
        desc.setAlignment(mementoDesc.getInteger(xmlFieldAlignment));
        desc.setSortDirection(mementoDesc.getInteger(xmlFieldSortDirection));
        desc.setWidth(mementoDesc.getInteger(xmlFieldWidth));
        desc.setAutoSize(mementoDesc.getBoolean(xmlFieldAutoSize));
        desc.setDefaultSortColumn(mementoDesc.getBoolean(xmlFieldDefaultSortColumn));
    }
}

