/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.I4diacTableUtil;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class TableCutAction
extends Action {
    private final Object part;

    public TableCutAction(Object part) {
        this.part = part;
        this.setId(ActionFactory.CUT.getId());
        this.setText(FordiacMessages.TableCopyPaste_TEXT_Cut);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
    }

    public void run() {
        I4diacTableUtil editor = TableWidgetFactory.getTableEditor(this.part);
        if (editor != null) {
            CellEditor[] cellEditorArray = editor.getViewer().getCellEditors();
            int n = cellEditorArray.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor cell = cellEditorArray[n2];
                if (cell != null && cell.isActivated()) {
                    cell.performCut();
                    return;
                }
                ++n2;
            }
            TableCutAction.cutItems(editor);
        }
    }

    private static void cutItems(I4diacTableUtil editor) {
        Grid table = ((GridTableViewer)editor.getViewer()).getGrid();
        int[] indices = table.getSelectionIndices();
        if (indices.length != 0) {
            Object[] entries = new Object[indices.length];
            CompoundCommand cmpCommand = new CompoundCommand();
            int i = 0;
            while (i < indices.length) {
                entries[i] = editor.removeEntry(indices[i], cmpCommand);
                ++i;
            }
            editor.executeCompoundCommand(cmpCommand);
            Clipboard.getDefault().setContents((Object)entries);
        }
    }
}

