/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.hierarchymanager.ui.util.HierarchyManagerUtil;
import org.eclipse.fordiac.ide.hierarchymanager.ui.view.PlantHierarchyView;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenLeafAction
extends BaseSelectionListenerAction {
    public static final String OPEN_LEAF_ACTION_ID = "org.eclipse.fordiac.ide.hierarchymanager.ui.openLeafAction";
    final PlantHierarchyView phView;

    public OpenLeafAction(PlantHierarchyView phView) {
        super(Messages.OpenEditorAction_text);
        this.setId(OPEN_LEAF_ACTION_ID);
        this.phView = phView;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (this.getProject() == null || selection.size() != 1) {
            return false;
        }
        Object model = this.getStructuredSelection().getFirstElement();
        return model instanceof Leaf;
    }

    public void run() {
        Object object = this.getStructuredSelection().getFirstElement();
        if (object instanceof Leaf) {
            Leaf leaf = (Leaf)object;
            EObject refObj = HierarchyManagerUtil.getElementReferencedbyLeaf(leaf, this.getProject());
            OpenListenerManager.openEditor((EObject)refObj);
        }
    }

    private IProject getProject() {
        return this.phView.getCurrentProject();
    }
}

