/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.structures;

import java.util.List;
import org.eclipse.elk.alg.common.polyomino.structures.Direction;
import org.eclipse.elk.alg.common.polyomino.structures.Polyomino;
import org.eclipse.elk.alg.disco.graph.DCComponent;
import org.eclipse.elk.alg.disco.graph.DCDirection;
import org.eclipse.elk.alg.disco.graph.DCElement;
import org.eclipse.elk.alg.disco.graph.DCExtension;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;

public class DCPolyomino
extends Polyomino {
    private DCComponent representee;
    private int pWidth;
    private int pHeight;
    private double cellSizeX;
    private double cellSizeY;

    public DCPolyomino(DCComponent comp, double csX, double csY) {
        this.cellSizeX = csX;
        this.cellSizeY = csY;
        this.representee = comp;
        KVector compDims = comp.getDimensionsOfBoundingRectangle();
        this.pWidth = this.computeLowResDimension(compDims.x, this.cellSizeX);
        this.pHeight = this.computeLowResDimension(compDims.y, this.cellSizeY);
        this.reinitialize(this.pWidth, this.pHeight);
        this.fillCells();
        for (DCElement elem : this.representee.getElements()) {
            if (elem.getExtensions().size() <= 0) continue;
            this.addExtensionsToPoly(elem);
        }
    }

    public KVector getOffset() {
        double halfNeg = -0.5;
        return this.representee.getDimensionsOfBoundingRectangle().clone().sub((double)this.pWidth * this.cellSizeX, (double)this.pHeight * this.cellSizeY).scale(-0.5);
    }

    public KVector getMinCornerOnCanvas() {
        return this.representee.getMinCorner().clone().sub(this.getOffset());
    }

    public double getCellSizeX() {
        return this.cellSizeX;
    }

    public double getCellSizeY() {
        return this.cellSizeY;
    }

    public int getId() {
        return this.representee.getId();
    }

    public void setId(int id) {
        this.representee.setId(id);
    }

    public DCComponent getRepresentee() {
        return this.representee;
    }

    private int computeLowResDimension(double dim, double cellSize) {
        double cellFit = dim / cellSize;
        int fitTruncated = (int)cellFit;
        if (cellFit > (double)fitTruncated) {
            ++fitTruncated;
        }
        return fitTruncated;
    }

    private void fillCells() {
        KVector compCorner = this.representee.getMinCorner();
        KVector polyoOffset = this.getOffset();
        double baseX = compCorner.x - polyoOffset.x;
        double curY = compCorner.y - polyoOffset.y;
        int y = 0;
        while (y < this.pHeight) {
            double curX = baseX;
            int x = 0;
            while (x < this.pWidth) {
                if (this.representee.intersects(new ElkRectangle(curX, curY, this.cellSizeX, this.cellSizeY))) {
                    this.setBlocked(x, y);
                }
                curX += this.cellSizeX;
                ++x;
            }
            curY += this.cellSizeY;
            ++y;
        }
    }

    private void addExtensionsToPoly(DCElement elem) {
        List<DCExtension> extensions = elem.getExtensions();
        KVector compCorner = this.representee.getMinCorner();
        KVector polyoOffset = this.getOffset();
        double baseX = compCorner.x - polyoOffset.x;
        double baseY = compCorner.y - polyoOffset.y;
        ElkRectangle elemPos = elem.getBounds();
        baseX = elemPos.x - baseX;
        baseY = elemPos.y - baseY;
        for (DCExtension extension : extensions) {
            KVector pos = extension.getOffset();
            double xe = baseX + pos.x;
            double ye = baseY + pos.y;
            int xp = (int)(xe / this.cellSizeX);
            int yp = (int)(ye / this.cellSizeY);
            DCDirection dir = extension.getDirection();
            Direction polyDir = switch (dir) {
                case DCDirection.NORTH -> Direction.NORTH;
                case DCDirection.EAST -> Direction.EAST;
                case DCDirection.SOUTH -> Direction.SOUTH;
                default -> Direction.WEST;
            };
            if (dir.isHorizontal()) {
                int ypPlusWidth = (int)((ye + extension.getWidth()) / this.cellSizeY);
                this.addExtension(polyDir, yp, ypPlusWidth);
                if (dir.equals((Object)DCDirection.WEST)) {
                    this.weaklyBlockArea(0, yp, xp, ypPlusWidth);
                    continue;
                }
                this.weaklyBlockArea(xp, yp, this.pWidth - 1, ypPlusWidth);
                continue;
            }
            int xpPlusWidth = (int)((xe + extension.getWidth()) / this.cellSizeX);
            this.addExtension(polyDir, xp, xpPlusWidth);
            if (dir.equals((Object)DCDirection.NORTH)) {
                this.weaklyBlockArea(xp, 0, xpPlusWidth, yp);
                continue;
            }
            this.weaklyBlockArea(xp, yp, xpPlusWidth, this.pHeight - 1);
        }
    }
}

