/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.gef.commands.Command;

class ChangeInterfaceAdapterFBCommand
extends Command {
    private final AdapterDeclaration adpDecl;
    private final AdapterFB oldAdapterFB;
    protected AdapterFB newAdapterFB;

    public ChangeInterfaceAdapterFBCommand(AdapterDeclaration adpDecl) {
        this.adpDecl = Objects.requireNonNull(adpDecl);
        this.oldAdapterFB = adpDecl.getInterfaceOnlyAdapterFB();
    }

    public void execute() {
        this.newAdapterFB = ChangeInterfaceAdapterFBCommand.createAdapterFB(this.adpDecl);
        this.setAdapterFB(this.newAdapterFB);
    }

    public void undo() {
        this.setAdapterFB(this.oldAdapterFB);
    }

    public void redo() {
        this.setAdapterFB(this.newAdapterFB);
    }

    private void setAdapterFB(AdapterFB fb) {
        this.adpDecl.setAdapterFB(fb);
        this.adpDecl.setInterfaceOnlyAdapterFB(fb);
    }

    private static AdapterFB createAdapterFB(AdapterDeclaration adpDecl) {
        AdapterType adpType = adpDecl.getType();
        AdapterFB adapterFB = LibraryElementFactory.eINSTANCE.createAdapterFB();
        adapterFB.setAdapterDecl(adpDecl);
        adapterFB.setTypeEntry(adpType.getTypeEntry());
        InterfaceList typeInterface = adapterFB.isPlug() ? adpType.getPlugType().getInterfaceList() : adpType.getInterfaceList();
        adapterFB.setInterface(typeInterface.instanceCopy());
        adapterFB.setName(adpDecl.getName());
        return adapterFB;
    }
}

