/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppCrossingConnectionsCommand;
import org.eclipse.fordiac.ide.application.handlers.AbstractMarkerHandler;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.UtilityMarkerHelper;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class MarkConnectionSourceHandler
extends AbstractMarkerHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (event.getTrigger() != null) {
            return super.execute(event);
        }
        IInterfaceElement conTarget = MarkConnectionSourceHandler.getConnectionTarget(event);
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (conTarget == null || editor == null) {
            return null;
        }
        EObject eObject = UtilityMarkerHelper.getMarkedElement((String)this.getMarkerId(), (EObject)conTarget);
        if (eObject instanceof IInterfaceElement) {
            IInterfaceElement connectionSource = (IInterfaceElement)eObject;
            ConEndpointMarkerCommandWrapper cmd = new ConEndpointMarkerCommandWrapper(CreateSubAppCrossingConnectionsCommand.createProcessBorderCrossingConnection(connectionSource, conTarget), connectionSource);
            HandlerHelper.getCommandStack((IEditorPart)editor).execute((Command)cmd);
        }
        return null;
    }

    private static IInterfaceElement getConnectionTarget(ExecutionEvent event) {
        IInterfaceElement iInterfaceElement;
        IStructuredSelection sel;
        Object object;
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (object = (sel = selection).getFirstElement()) instanceof InterfaceEditPart) {
            InterfaceEditPart ep = (InterfaceEditPart)object;
            iInterfaceElement = ep.getModel();
        } else {
            iInterfaceElement = null;
        }
        return iInterfaceElement;
    }

    @Override
    protected String getMarkerId() {
        return "org.eclipse.fordiac.ide.model.ui.connectionSource";
    }

    @Override
    protected String getMarkerName() {
        return Messages.UtilityMarker_ConnectionSource;
    }

    @Override
    protected EObject getValidSelectedElement(Object selectedObject) {
        IInterfaceElement iInterfaceElement;
        if (selectedObject instanceof InterfaceEditPart) {
            InterfaceEditPart iep = (InterfaceEditPart)selectedObject;
            iInterfaceElement = iep.getModel();
        } else {
            iInterfaceElement = null;
        }
        return iInterfaceElement;
    }

    private class ConEndpointMarkerCommandWrapper
    extends Command {
        private final Command cmd;
        IInterfaceElement conEndpoint;

        public ConEndpointMarkerCommandWrapper(Command cmd, IInterfaceElement conEndpoint) {
            this.cmd = cmd;
            this.conEndpoint = conEndpoint;
        }

        public boolean canExecute() {
            return this.cmd.canExecute();
        }

        public boolean canUndo() {
            return this.cmd.canUndo();
        }

        public boolean canRedo() {
            return this.cmd.canRedo();
        }

        public void execute() {
            this.cmd.execute();
            this.removeMarker();
        }

        public void undo() {
            this.cmd.undo();
            UtilityMarkerHelper.setMarkedElement((String)MarkConnectionSourceHandler.this.getMarkerId(), (EObject)this.conEndpoint);
        }

        public void redo() {
            this.cmd.redo();
            this.removeMarker();
        }

        private void removeMarker() {
            LibraryElement le;
            EObject root = EcoreUtil.getRootContainer((EObject)this.conEndpoint);
            if (root instanceof LibraryElement && (le = (LibraryElement)root).getTypeEntry() != null && le.getTypeEntry().getFile() != null) {
                UtilityMarkerHelper.deleteElementMarker((String)MarkConnectionSourceHandler.this.getMarkerId(), (IResource)le.getTypeEntry().getFile());
            }
        }
    }
}

