/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.library.DependencyNode;
import org.eclipse.fordiac.ide.library.LibraryMarkerFactory;
import org.eclipse.fordiac.ide.library.LibraryPermission;
import org.eclipse.fordiac.ide.library.LibraryRecord;
import org.eclipse.fordiac.ide.library.Messages;
import org.eclipse.fordiac.ide.library.ResolveNode;
import org.eclipse.fordiac.ide.library.download.DownloadResult;
import org.eclipse.fordiac.ide.library.download.IArchiveDownloader;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.library.model.util.VersionComparator;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.preferences.PreferenceProvider;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public enum LibraryManager {
    INSTANCE;

    public static final String LIB_TYPELIB_FOLDER_NAME = "typelib";
    public static final String PACKAGE_DOWNLOAD_DIRECTORY = ".download";
    public static final String EXTRACTED_LIB_DIRECTORY = ".lib";
    public static final String MANIFEST = "MANIFEST.MF";
    public static final String DOWNLOADER_EXTENSION = "org.eclipse.fordiac.ide.library.ArchiveDownloaderExtension";
    private final URI workspaceLibraryURI = URI.create("WORKSPACE_LOC/.lib");
    private final Path workspacePath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toPath();
    private final Path libraryPath = this.workspacePath.resolve(".lib");
    private final Path archivePath = this.workspacePath.resolve(".download");
    private final URI standardLibraryUri = URI.create("ECLIPSE_HOME/typelibrary");
    private final Path standardLibraryPath = LibraryManager.getStandardLibPath();
    public static final Set<String> LIBRARY_FOLDERS;
    public static final String ZIP_SUFFIX = ".zip";
    public static final Set<String> TYPE_ENDINGS;
    private static final DirectoryStream.Filter<Path> ARCHIVE_DIR_FILTER;
    private static final Path[] EMPTY_PATH_ARRAY;
    public static final VersionRange ALL_RANGE;
    private WatchService watchService;
    private final HashMap<String, List<LibraryRecord>> stdlibraries = new HashMap();
    private final HashMap<String, List<LibraryRecord>> libraries = new HashMap();
    public static final Object FAMILY_FORDIAC_LIBRARY;

    static {
        LIBRARY_FOLDERS = Set.of("External Libraries", "Standard Libraries");
        TYPE_ENDINGS = Set.of("ADP", "ATP", "DTP", "DEV", "FBT", "FCT", "GCF", "RES", "SEG", "SUB", "SYS");
        ARCHIVE_DIR_FILTER = entry -> Files.isDirectory(entry, new LinkOption[0]) || entry.getFileName().toString().endsWith(ZIP_SUFFIX);
        EMPTY_PATH_ARRAY = new Path[0];
        ALL_RANGE = new VersionRange('[', Version.emptyVersion, null, ']');
        FAMILY_FORDIAC_LIBRARY = new Object();
    }

    private LibraryManager() {
        LibraryManager.initLibraryMap(this.stdlibraries, this.standardLibraryPath, this.standardLibraryUri);
        if (!Files.exists(this.libraryPath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.libraryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                FordiacLogHelper.logError((String)"Cannot create lib path!", (Throwable)e);
            }
        }
        LibraryManager.initLibraryMap(this.libraries, this.libraryPath, this.workspaceLibraryURI);
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            this.libraryPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (IOException e) {
            FordiacLogHelper.logError((String)"Cannot register watch watch service!", (Throwable)e);
        }
        LibraryPermission.setLibReadOnly(this.standardLibraryPath);
    }

    private void checkLibChanges(SubMonitor progress) {
        progress.beginTask(Messages.LibraryManager_ChekForLibraryChanges, 10);
        if (this.watchService == null) {
            return;
        }
        WatchKey watchKey = this.watchService.poll();
        if (watchKey == null) {
            return;
        }
        List<WatchEvent<?>> events = watchKey.pollEvents();
        progress.setWorkRemaining(events.size());
        events.forEach(event -> {
            try {
                if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                    LibraryManager.addLibrary(this.libraries, this.libraryPath.resolve((Path)event.context()), this.workspaceLibraryURI);
                } else if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                    LibraryManager.removeLibrary(this.libraries, this.libraryPath.resolve((Path)event.context()));
                } else {
                    LibraryManager.initLibraryMap(this.libraries, this.libraryPath, this.workspaceLibraryURI);
                    return;
                }
                progress.worked(1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        watchKey.reset();
    }

    private static void initLibraryMap(Map<String, List<LibraryRecord>> map, Path path2, URI baseURI) {
        map.clear();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path2, path -> Files.isDirectory(path, new LinkOption[0]));){
                for (Path folder : stream) {
                    LibraryManager.addLibrary(map, folder, baseURI);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addLibrary(Map<String, List<LibraryRecord>> map, Path path, URI baseUri) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> folderStream = Files.newDirectoryStream(path, MANIFEST);){
            Manifest manifest;
            Iterator<Path> it = folderStream.iterator();
            if (it.hasNext() && (manifest = ManifestHelper.getManifest((Path)it.next())) != null && ManifestHelper.isLibrary((Manifest)manifest) && manifest.getProduct() != null && manifest.getProduct().getSymbolicName() != null) {
                map.computeIfAbsent(manifest.getProduct().getSymbolicName(), s -> new ArrayList()).add(new LibraryRecord(manifest.getProduct().getSymbolicName(), manifest.getProduct().getName(), manifest.getProduct().getVersionInfo().getVersion(), manifest.getProduct().getComment(), path, URIUtil.append((URI)baseUri, (String)path.getFileName().toString())));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void removeLibrary(Map<String, List<LibraryRecord>> map, Path path) {
        List<LibraryRecord> records;
        String folderName = path.getFileName().toString();
        int pos = folderName.lastIndexOf(45);
        if (pos > 0) {
            folderName = folderName.substring(0, pos);
        }
        if ((records = map.get(folderName)) != null) {
            records.removeIf(r -> r.path().equals(path));
            if (records.isEmpty()) {
                map.remove(folderName);
            }
        } else {
            map.values().forEach(rl -> {
                boolean bl = rl.removeIf(r -> r.path().equals(path));
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI extractLibrary(Path path, IProject project, boolean autoImport, boolean resolve) throws IOException {
        String folderName;
        block30: {
            if (path == null) return null;
            if (Files.notExists(path, new LinkOption[0])) {
                return null;
            }
            FordiacLogHelper.logInfo((String)("Extracting library at " + String.valueOf(path)));
            byte[] buffer = new byte[1024];
            Throwable throwable = null;
            Object var8_8 = null;
            try {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                        ZipEntry entry = zipInputStream.getNextEntry();
                        folderName = "";
                        if (entry != null) {
                            folderName = entry.getName();
                            LibraryManager.deleteLibFolder(LibraryManager.newPath(this.libraryPath, entry));
                        }
                        while (entry != null) {
                            Path newFile = LibraryManager.newPath(this.libraryPath, entry);
                            if (entry.isDirectory()) {
                                if (!Files.isDirectory(newFile, new LinkOption[0])) {
                                    Files.createDirectories(newFile, new FileAttribute[0]);
                                }
                            } else {
                                Path parent = newFile.getParent();
                                if (!Files.isDirectory(parent, new LinkOption[0])) {
                                    Files.createDirectories(parent, new FileAttribute[0]);
                                }
                                Throwable throwable2 = null;
                                Object var15_19 = null;
                                try (OutputStream fileOutputStream = Files.newOutputStream(newFile, new OpenOption[0]);){
                                    int len;
                                    while ((len = zipInputStream.read(buffer)) > 0) {
                                        fileOutputStream.write(buffer, 0, len);
                                    }
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable3) throw throwable2;
                                    throwable2.addSuppressed(throwable3);
                                    throw throwable2;
                                }
                                LibraryPermission.setPathReadOnly(newFile);
                            }
                            entry = zipInputStream.getNextEntry();
                        }
                    }
                    if (inputStream == null) break block30;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        this.checkLibChanges(SubMonitor.convert(null));
        if (folderName.endsWith("/")) {
            folderName = folderName.substring(0, folderName.length() - 1);
        }
        URI importURI = URIUtil.append((URI)this.workspaceLibraryURI, (String)folderName);
        if (!autoImport) return importURI;
        if (project == null) return importURI;
        this.importLibrary(project, importURI, true, resolve);
        return importURI;
    }

    private static void deleteLibFolder(Path folder) throws IOException {
        if (Files.exists(folder, new LinkOption[0])) {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    LibraryPermission.setPathEditable(file);
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    LibraryPermission.setPathEditable(dir);
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static Path newPath(Path destinationDir, ZipEntry zipEntry) throws IOException {
        String entryName;
        Path normalizedDestinationDir = destinationDir.toAbsolutePath().normalize();
        Path destPath = normalizedDestinationDir.resolve(entryName = zipEntry.getName().replace('\\', '/')).normalize();
        if (!destPath.startsWith(normalizedDestinationDir)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destPath;
    }

    public boolean importLibrary(IProject project, URI uri, boolean update, boolean resolve) {
        boolean imported = false;
        FordiacLogHelper.logInfo((String)("Importing library at " + String.valueOf(uri) + " into project " + project.getName() + " (update=" + update + ", resolve=" + resolve + ")"));
        this.checkLibChanges(SubMonitor.convert(null));
        IPathVariableManager varMan = project.getPathVariableManager();
        URI resolvedUri = varMan.resolveURI(uri);
        Path path = Paths.get(resolvedUri);
        if (!Files.isDirectory(path, new LinkOption[0]) || Files.notExists(path.resolve(LIB_TYPELIB_FOLDER_NAME), new LinkOption[0])) {
            return false;
        }
        Manifest libManifest = ManifestHelper.getFolderManifest((Path)path);
        if (libManifest == null) {
            return false;
        }
        Manifest projManifest = ManifestHelper.getOrCreateProjectManifest((IProject)project);
        if (projManifest == null) {
            return false;
        }
        IFolder libDirectory = project.getFolder(uri.getPath().startsWith(this.standardLibraryUri.getPath()) ? "Standard Libraries" : "External Libraries").getFolder(libManifest.getProduct().getSymbolicName());
        URI libUri = URIUtil.append((URI)uri, (String)LIB_TYPELIB_FOLDER_NAME);
        URI manUri = URIUtil.append((URI)uri, (String)MANIFEST);
        try {
            libDirectory.createLink(libUri, 256, null);
            IFile man = libDirectory.getFile(MANIFEST);
            man.createLink(manUri, 4352, null);
            if (update) {
                ManifestHelper.updateDependency((Manifest)projManifest, (Required)ManifestHelper.createRequired((String)libManifest.getProduct().getSymbolicName(), (String)libManifest.getProduct().getVersionInfo().getVersion()));
                projManifest.eResource().save(null);
            }
            imported = true;
        }
        catch (IOException | CoreException e) {
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.ImportFailedOnLinkCreation, e.getMessage()), (Throwable)e);
        }
        return imported;
    }

    public void importLibraries(IProject project, Collection<URI> uris, boolean resolve) {
        for (URI uri : uris) {
            this.importLibrary(project, uri, true, resolve);
        }
    }

    public Path[] listDirectoriesContainingArchives() {
        return this.listArchiveFolders(this.archivePath);
    }

    public Path[] listArchiveFolders(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return EMPTY_PATH_ARRAY;
        }
        LinkedList content = new LinkedList();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, ARCHIVE_DIR_FILTER);){
                stream.forEach(content::add);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return content.toArray(EMPTY_PATH_ARRAY);
    }

    public Map<String, List<LibraryRecord>> getStandardLibraries() {
        return new HashMap<String, List<LibraryRecord>>(this.stdlibraries);
    }

    public Map<String, List<LibraryRecord>> getExtractedLibraries() {
        this.checkLibChanges(SubMonitor.convert(null));
        return new HashMap<String, List<LibraryRecord>>(this.libraries);
    }

    private DownloadResult<URI> libraryDownload(String symbolicName, VersionRange versionRange, Version preferred, IProject project, boolean autoImport, boolean resolve, SubMonitor progress) throws OperationCanceledException {
        progress.setTaskName(MessageFormat.format(Messages.LibraryManager_LibraryDownload, symbolicName));
        FordiacLogHelper.logInfo((String)("Attempting to download library " + symbolicName + " with version " + String.valueOf(versionRange) + " preferring " + String.valueOf(preferred)));
        List downloaders = TypeLibraryManager.listExtensions((String)DOWNLOADER_EXTENSION, IArchiveDownloader.class);
        StringBuilder errors = new StringBuilder();
        VersionRange range = versionRange == null || versionRange.isEmpty() ? ALL_RANGE : versionRange;
        Version pref = preferred != null && range.includes(preferred) ? preferred : null;
        progress.setWorkRemaining(downloaders.size());
        for (IArchiveDownloader downloader : downloaders) {
            if (!downloader.isActive()) {
                progress.worked(1);
                continue;
            }
            try {
                DownloadResult<Path> dlResult = downloader.downloadLibrary(symbolicName, range, pref, (IProgressMonitor)progress.split(1));
                if (dlResult.status() == DownloadResult.Status.OK) {
                    return new DownloadResult<URI>(this.extractLibrary(dlResult.result(), project, autoImport, resolve));
                }
                if (dlResult.status() != DownloadResult.Status.NOT_FOUND && dlResult.status() != DownloadResult.Status.CONFIG_ERROR && dlResult.status() != DownloadResult.Status.ERROR) continue;
                errors.append(" | ");
                errors.append(downloader.getName());
                errors.append(": ");
                errors.append(dlResult.message());
            }
            catch (IOException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        return new DownloadResult<URI>(DownloadResult.Status.ERROR, errors.toString());
    }

    public void updateLibrary(final IProject project, final String symbolicName, final String versionRange) {
        WorkspaceJob job = new WorkspaceJob(MessageFormat.format(Messages.LibraryManager_UpdateLibraryPackage, symbolicName, versionRange)){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                LibraryManager.this.libraryDownload(symbolicName, VersionComparator.parseVersionRange((String)versionRange), null, project, true, true, SubMonitor.convert((IProgressMonitor)monitor));
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == FAMILY_FORDIAC_LIBRARY;
            }
        };
        job.setRule((ISchedulingRule)project);
        job.setPriority(30);
        job.schedule();
    }

    public void resolveDependencies(IProject project, Manifest projectManifest, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        LibraryManagerData libManagerData = LibraryManagerData.init();
        LinkedList<String> queue = new LinkedList<String>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LibraryManager_ResolvingLibraryDependencies, (int)100);
        if (projectManifest == null) {
            return;
        }
        this.checkLibChanges(progress.split(4));
        if (projectManifest.getDependencies() == null) {
            return;
        }
        LibraryManager.collectReferencedDependencies(project, libManagerData.referenced());
        LibraryManager.findPreferred(project, libManagerData, progress.split(5));
        projectManifest.getDependencies().getRequired().forEach(req -> {
            libManagerData.dependencyNodes().put(req.getSymbolicName(), new DependencyNode(req.getSymbolicName(), "Project", VersionComparator.parseVersionRange((String)req.getVersion())));
            queue.add(req.getSymbolicName());
        });
        this.buildDependencies(project, libManagerData, queue, progress.split(70));
        LinkedList<ErrorMarkerBuilder> markerList = new LinkedList<ErrorMarkerBuilder>();
        this.importDependencyNodes(project, libManagerData, projectManifest, markerList, progress.split(15));
        LibraryManager.cleanupLinks(libManagerData.linked(), progress.split(2));
        LibraryManager.checkLinkedLibraries(project, progress.split(1));
        if (PreferenceProvider.getBoolean((String)"org.eclipse.fordiac.ide.library", (String)"ForceLoadDependencies", (boolean)false, (IProject)project)) {
            List<Required> explicitDeps = projectManifest.getDependencies().getRequired().stream().filter(r -> !r.getVersion().contains("-") && !libManagerData.dependencyNodes().get(r.getSymbolicName()).isValid()).toList();
            progress.setWorkRemaining(explicitDeps.size());
            for (Required req2 : explicitDeps) {
                libManagerData.linked().remove(req2.getSymbolicName());
                Version version = Version.parseVersion((String)req2.getVersion());
                LibraryRecord lib = LibraryManager.getLibraryRecord(this.stdlibraries, req2.getSymbolicName(), version);
                if (lib != null) {
                    this.importLibrary(project, lib.uri(), false, false);
                    continue;
                }
                lib = LibraryManager.getLibraryRecord(this.libraries, req2.getSymbolicName(), version);
                if (lib != null) {
                    this.importLibrary(project, lib.uri(), false, false);
                    continue;
                }
                this.libraryDownload(req2.getSymbolicName(), (VersionRange)new org.eclipse.osgi.service.resolver.VersionRange(version, true, version, true), null, project, true, false, progress.split(1));
            }
        } else {
            progress.worked(3);
        }
        int maxSeverity = markerList.stream().mapToInt(ErrorMarkerBuilder::getSeverity).max().orElse(-1);
        if (maxSeverity >= 2) {
            markerList.add(ErrorMarkerBuilder.createErrorMarkerBuilder((String)Messages.LibraryManager_UnresolvableDependencies).setType("org.eclipse.fordiac.ide.model.library"));
        }
        FordiacMarkerHelper.updateMarkers((IResource)project.getFile(MANIFEST), (String)"org.eclipse.fordiac.ide.model.library", markerList, (boolean)true);
        TypeLibraryManager.INSTANCE.getTypeLibrary(project).refresh();
        if (maxSeverity >= 2) {
            throw new OperationCanceledException("Unresolvable dependencies");
        }
    }

    private static void checkLinkedLibraries(IProject project, SubMonitor progress) {
        progress.setTaskName(Messages.LibraryManager_CheckLinks);
        progress.setWorkRemaining(10);
        LIBRARY_FOLDERS.stream().map(arg_0 -> ((IProject)project).getFolder(arg_0)).forEach(folder -> {
            try {
                folder.accept(resource -> {
                    IFolder libFolder;
                    if (resource.equals(folder)) {
                        return true;
                    }
                    if (resource instanceof IFolder && (libFolder = (IFolder)resource).exists() && libFolder.isLinked()) {
                        if (libFolder.getModificationStamp() == -1L) {
                            FordiacMarkerHelper.updateMarkers((IResource)resource, (String)"org.eclipse.fordiac.ide.model.library", List.of(LibraryMarkerFactory.createBrokenLinkMarker(libFolder)), (boolean)true);
                            throw new OperationCanceledException();
                        }
                        progress.worked(1);
                    }
                    return false;
                });
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        });
    }

    private void buildDependencies(IProject project, LibraryManagerData data, Queue<String> queue, SubMonitor progress) throws OperationCanceledException {
        progress.setTaskName(Messages.LibraryManager_BuildingDependencyGraph);
        while (!queue.isEmpty()) {
            ResolveNode rnode;
            progress.setWorkRemaining(Math.max(queue.size(), 10));
            String symbolicName = queue.poll();
            DependencyNode dnode = data.dependencyNodes().get(symbolicName);
            if (!dnode.isChanged()) continue;
            if (!dnode.isValid()) {
                rnode = data.resolveNodes().get(symbolicName);
                if (rnode == null) continue;
                rnode.getDependencies().keySet().forEach(symb -> {
                    DependencyNode dn = data.dependencyNodes().get(symb);
                    if (dn != null) {
                        dn.removeCause(symbolicName);
                        if (dn.isChanged()) {
                            queue.add((String)symb);
                        }
                    }
                });
                continue;
            }
            rnode = this.resolveDependency(project, symbolicName, dnode.getRange(), data.preferred().get(symbolicName), progress.split(1), data.referenced());
            if (data.resolveNodes().containsKey(symbolicName)) {
                ResolveNode oldRNode = data.resolveNodes().get(symbolicName);
                oldRNode.getDependencies().keySet().forEach(old -> {
                    if (!rnode.getDependencies().containsKey(old)) {
                        data.dependencyNodes().get(old).removeCause(symbolicName);
                    }
                });
            }
            data.resolveNodes().put(symbolicName, rnode);
            rnode.getDependencies().forEach((symb, val) -> {
                DependencyNode dn = data.dependencyNodes().computeIfAbsent((String)symb, s -> new DependencyNode((String)symb));
                dn.putCause(symbolicName, (VersionRange)val);
                if (dn.isChanged()) {
                    queue.add((String)symb);
                }
            });
        }
    }

    private void importDependencyNodes(IProject project, LibraryManagerData data, Manifest projectManifest, List<ErrorMarkerBuilder> markerList, SubMonitor progress) {
        for (DependencyNode dnode : data.dependencyNodes().values()) {
            if (dnode.isValid()) {
                ResolveNode rnode = data.resolveNodes().get(dnode.getSymbolicName());
                if (rnode.isValid()) {
                    if (rnode.requireImport(data.linked(), data.preferred())) {
                        this.importLibrary(project, rnode.getUri(), false, false);
                    }
                    if (rnode.isReferenced()) continue;
                    data.linked().remove(rnode.getSymbolicName());
                    continue;
                }
                markerList.add(LibraryMarkerFactory.createDependencyMarker(projectManifest, rnode, dnode));
                continue;
            }
            if (!dnode.isRangeEmpty()) continue;
            markerList.add(LibraryMarkerFactory.createDependencyMarker(projectManifest, dnode));
        }
    }

    private static void cleanupLinks(Map<String, IFolder> linked, SubMonitor progress) throws CoreException {
        progress.setTaskName(Messages.LibraryManager_RemovingUnnecessaryLinks);
        progress.setWorkRemaining(linked.size());
        for (IFolder folder : linked.values()) {
            folder.delete(true, (IProgressMonitor)progress.split(1));
        }
    }

    private static void findPreferred(IProject project, LibraryManagerData data, SubMonitor progress) {
        IFolder standardLibFolder = project.getFolder("Standard Libraries");
        IFolder externalLibFolder = project.getFolder("External Libraries");
        if (!standardLibFolder.exists() || !externalLibFolder.exists()) {
            return;
        }
        progress.beginTask(Messages.LibraryManager_FindingPreferredLibraryVersion, 100);
        IResourceVisitor visitor = res -> {
            if (res instanceof IFolder) {
                IFolder libFolder = (IFolder)res;
                progress.setWorkRemaining(100).worked(1);
                if (standardLibFolder.equals((Object)libFolder) || externalLibFolder.equals((Object)libFolder)) {
                    return true;
                }
                if (!libFolder.exists() || !libFolder.isLinked()) {
                    return false;
                }
                Manifest libManifest = ManifestHelper.getContainerManifest((IContainer)libFolder);
                if (libManifest != null) {
                    data.linked().put(libFolder.getName(), libFolder);
                    data.preferred().put(libFolder.getName(), new Version(libManifest.getProduct().getVersionInfo().getVersion()));
                } else {
                    Version version = LibraryManager.parseLibraryVersion(libFolder);
                    if (!version.equals((Object)Version.emptyVersion)) {
                        data.preferred().put(libFolder.getName(), version);
                    }
                }
            }
            return false;
        };
        try {
            standardLibFolder.accept(visitor);
            externalLibFolder.accept(visitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    static Version parseLibraryVersion(IFolder libraryFolder) {
        IPath path = libraryFolder.getRawLocation();
        String segment = path != null && path.segmentCount() >= 2 ? path.segment(path.segmentCount() - 2) : "";
        int index = segment.lastIndexOf(45);
        if (index > 0) {
            return new Version(segment.substring(index + 1));
        }
        return Version.emptyVersion;
    }

    private ResolveNode resolveDependency(IProject project, String symbolicName, VersionRange range, Version prefVersion, SubMonitor progress, Map<String, List<Version>> referenced) {
        LibraryRecord rec;
        boolean usePref = prefVersion != null && range.includes(prefVersion);
        progress.setTaskName(Messages.LibraryManager_ResolvingDependency + symbolicName);
        progress.setWorkRemaining(100);
        if (LibraryManager.isProvidedByReference(referenced, symbolicName, range)) {
            return new ResolveNode(symbolicName, prefVersion, project);
        }
        if (this.stdlibraries.containsKey(symbolicName)) {
            LibraryRecord rec2;
            if (usePref && (rec2 = LibraryManager.getLibraryRecord(this.stdlibraries, symbolicName, prefVersion)) != null) {
                return new ResolveNode(rec2);
            }
            rec2 = LibraryManager.getLibraryRecord(this.stdlibraries, symbolicName, range);
            if (rec2 != null) {
                return new ResolveNode(rec2);
            }
            return new ResolveNode(symbolicName, Messages.ErrorMarkerStandardLibNotAvailable);
        }
        if (usePref ? (rec = LibraryManager.getLibraryRecord(this.libraries, symbolicName, prefVersion)) != null : (rec = LibraryManager.getLibraryRecord(this.libraries, symbolicName, range)) != null) {
            return new ResolveNode(rec);
        }
        progress.worked(5);
        DownloadResult<URI> dlResult = this.libraryDownload(symbolicName, range, prefVersion, null, false, false, progress.split(95));
        if (dlResult.status() == DownloadResult.Status.OK && (rec = LibraryManager.getLibraryRecord(this.libraries, symbolicName, dlResult.result())) != null) {
            return new ResolveNode(rec);
        }
        if (usePref && (rec = LibraryManager.getLibraryRecord(this.libraries, symbolicName, range)) != null) {
            return new ResolveNode(rec);
        }
        return new ResolveNode(symbolicName, Messages.ErrorMarkerLibNotAvailable + dlResult.message());
    }

    private static boolean isProvidedByReference(Map<String, List<Version>> referenced, String symbolicName, VersionRange versionRange) {
        return referenced.getOrDefault(symbolicName, Collections.emptyList()).stream().anyMatch(arg_0 -> ((VersionRange)versionRange).includes(arg_0));
    }

    private static void collectReferencedDependencies(IProject project, Map<String, List<Version>> referenced) throws CoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = project.getReferencedProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refProject = iProjectArray[n2];
            if (refProject.isAccessible()) {
                Manifest manifest = ManifestHelper.getContainerManifest((IContainer)refProject);
                String symbolicName = ManifestHelper.getSymbolicName((Manifest)manifest, (String)refProject.getName());
                Version version = ManifestHelper.getVersion((Manifest)manifest, (Version)Version.emptyVersion);
                referenced.computeIfAbsent(symbolicName, name -> new ArrayList()).add(version);
            }
            ++n2;
        }
    }

    private static LibraryRecord getLibraryRecord(Map<String, List<LibraryRecord>> libs, String symbolicName, Version version) {
        return libs.getOrDefault(symbolicName, Collections.emptyList()).stream().filter(l -> l.version().equals((Object)version)).findFirst().orElse(null);
    }

    private static LibraryRecord getLibraryRecord(Map<String, List<LibraryRecord>> libs, String symbolicName, VersionRange range) {
        return libs.getOrDefault(symbolicName, Collections.emptyList()).stream().filter(l -> range.includes(l.version())).sorted((o1, o2) -> o2.version().compareTo(o1.version())).findFirst().orElse(null);
    }

    private static LibraryRecord getLibraryRecord(Map<String, List<LibraryRecord>> libs, String symbolicName, URI uri) {
        return libs.getOrDefault(symbolicName, Collections.emptyList()).stream().filter(l -> l.uri().equals(uri)).sorted((o1, o2) -> o2.version().compareTo(o1.version())).findFirst().orElse(null);
    }

    private static Path getStandardLibPath() {
        File installLocationFile = new File(Platform.getInstallLocation().getURL().getPath());
        Path fordiacInstallPath = installLocationFile.toPath();
        return fordiacInstallPath.resolve("typelibrary");
    }

    private record LibraryManagerData(Map<String, DependencyNode> dependencyNodes, Map<String, ResolveNode> resolveNodes, Map<String, Version> preferred, Map<String, IFolder> linked, Map<String, List<Version>> referenced) {
        public static LibraryManagerData init() {
            return new LibraryManagerData(new HashMap<String, DependencyNode>(), new HashMap<String, ResolveNode>(), new HashMap<String, Version>(), new HashMap<String, IFolder>(), new HashMap<String, List<Version>>());
        }
    }
}

