/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.handlers;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STVarGlobalDeclarationBlock;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.search.ModelQuerySpec;
import org.eclipse.fordiac.ide.model.search.ModelSearchQuery;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.ui.editor.findrefs.FindReferencesHandler;

public class STCoreFindReferencesHandler
extends FindReferencesHandler {
    @Inject
    private IQualifiedNameProvider nameProvider;

    protected void findReferences(EObject target) {
        STVarDeclaration varDec;
        String searchString = null;
        if (target instanceof STFunction) {
            STFunction function = (STFunction)target;
            searchString = this.nameProvider.getFullyQualifiedName((EObject)function).skipLast(1).toString("::");
        } else if (target instanceof FunctionFBType) {
            FunctionFBType function = (FunctionFBType)target;
            searchString = this.nameProvider.getFullyQualifiedName((EObject)function).toString("::");
        } else if (target instanceof STVarDeclaration && (varDec = (STVarDeclaration)target).eContainer() instanceof STVarGlobalDeclarationBlock) {
            searchString = this.nameProvider.getFullyQualifiedName((EObject)varDec).toString("::");
        }
        if (searchString != null) {
            ModelQuerySpec searchSpec = new ModelQuerySpec(searchString, false, false, true, false, false, true, true, ModelQuerySpec.SearchScope.PROJECT, (IResource)STCoreFindReferencesHandler.getProject(target), target);
            ModelSearchQuery searchJob = new ModelSearchQuery(searchSpec);
            NewSearchUI.runQueryInBackground((ISearchQuery)searchJob, (ISearchResultViewPart)NewSearchUI.getSearchResultView());
        } else {
            super.findReferences(target);
        }
    }

    private static IProject getProject(EObject target) {
        Resource resource = target.eResource();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resource.getURI().toPlatformString(true)));
        return file.getProject();
    }
}

