/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorLibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;

public final class TypedElementAnnotations {
    public static boolean validateType(ITypedElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (element.getType() == null) {
            if (diagnostics != null) {
                diagnostics.add(TypedElementAnnotations.createTypeValidationDiagnostic(Messages.TypedElementAnnotations_TypeNotSet, element));
            }
            return false;
        }
        if (element.getType() instanceof ErrorLibraryElement) {
            if (diagnostics != null) {
                diagnostics.add(TypedElementAnnotations.createTypeValidationDiagnostic(MessageFormat.format(Messages.TypedElementAnnotations_TypeNotFound, TypedElementAnnotations.getFullTypeName(element)), element));
            }
            return false;
        }
        return true;
    }

    private static Diagnostic createTypeValidationDiagnostic(String message, ITypedElement element) {
        return new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 27, message, FordiacMarkerHelper.getDiagnosticData((EObject)element, TypedElementAnnotations.getTypeFeature(element), TypedElementAnnotations.getFullTypeName(element)));
    }

    private static String getFullTypeName(ITypedElement element) {
        LibraryElement libraryElement = element.getType();
        if (libraryElement instanceof LibraryElement) {
            LibraryElement libraryElement2 = libraryElement;
            return PackageNameHelper.getFullTypeName(libraryElement2);
        }
        return element.getTypeName();
    }

    private static EStructuralFeature getTypeFeature(ITypedElement element) {
        EClass featureClass;
        EClassifier eClassifier;
        EStructuralFeature feature = element.eClass().getEStructuralFeature("type");
        if (feature != null && !feature.isMany() && (eClassifier = feature.getEType()) instanceof EClass && LibraryElementPackage.Literals.INAMED_ELEMENT.isSuperTypeOf(featureClass = (EClass)eClassifier)) {
            return feature;
        }
        return null;
    }

    private TypedElementAnnotations() {
        throw new UnsupportedOperationException();
    }
}

