/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ContainerVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

final class InterfaceListAnnotations {
    public static Stream<IInterfaceElement> getAllInputs(InterfaceList il) {
        return Stream.concat(Stream.concat(Stream.of(il.getEventInputs(), il.getInOutVars(), il.getSockets()).flatMap(Collection::stream), il.getInputVars().stream().flatMap(InterfaceListAnnotations::flattenAccessPins)), il.getErrorMarker().stream().filter(IInterfaceElement::isIsInput));
    }

    public static Stream<IInterfaceElement> getAllOutputs(InterfaceList il) {
        return Stream.concat(Stream.concat(Stream.of(il.getEventOutputs(), il.getOutMappedInOutVars(), il.getPlugs()).flatMap(Collection::stream), il.getOutputVars().stream().flatMap(InterfaceListAnnotations::flattenAccessPins)), il.getErrorMarker().stream().filter(em -> !em.isIsInput()));
    }

    public static Stream<IInterfaceElement> getAllInterfaceElements(InterfaceList il) {
        return Stream.concat(InterfaceListAnnotations.getAllInputs(il), InterfaceListAnnotations.getAllOutputs(il));
    }

    private static Stream<IInterfaceElement> flattenAccessPins(IInterfaceElement ie) {
        if (ie instanceof ContainerVarDeclaration) {
            ContainerVarDeclaration contVarDecl = (ContainerVarDeclaration)ie;
            return Stream.concat(Stream.of(ie), contVarDecl.getCachedMembers().stream().flatMap(InterfaceListAnnotations::flattenAccessPins));
        }
        return Stream.of(ie);
    }

    public static Event getEvent(InterfaceList il, String name) {
        for (Event event : il.getEventInputs()) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        for (Event event : il.getEventOutputs()) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        return null;
    }

    public static VarDeclaration getVariable(InterfaceList il, String name) {
        for (VarDeclaration inVar : il.getInputVars()) {
            if (!inVar.getName().equals(name)) continue;
            return inVar;
        }
        for (VarDeclaration outVar : il.getOutputVars()) {
            if (!outVar.getName().equals(name)) continue;
            return outVar;
        }
        for (VarDeclaration inOutVar : il.getInOutVars()) {
            if (!inOutVar.getName().equals(name)) continue;
            return inOutVar;
        }
        return null;
    }

    public static IInterfaceElement getInterfaceElement(InterfaceList il, List<String> path) {
        return InterfaceListAnnotations.getInterfaceElement(il, path, false);
    }

    public static IInterfaceElement getInput(InterfaceList il, List<String> path) {
        IInterfaceElement ie = InterfaceListAnnotations.getRootInput(il, path.get(0));
        if (path.size() == 1) {
            return ie;
        }
        return InterfaceListAnnotations.handleMemberAccess(ie, path, false);
    }

    public static IInterfaceElement getOutput(InterfaceList il, List<String> path) {
        IInterfaceElement ie = InterfaceListAnnotations.getRootOutput(il, path.get(0));
        if (path.size() == 1) {
            return ie;
        }
        return InterfaceListAnnotations.handleMemberAccess(ie, path, false);
    }

    public static IInterfaceElement getInterfaceElement(InterfaceList il, IInterfaceElement refElement) {
        if (refElement == null || il == refElement.eContainer()) {
            return refElement;
        }
        List<String> path = refElement.getBlockRelativePath();
        return refElement.isIsInput() ? InterfaceListAnnotations.getInput(il, path) : InterfaceListAnnotations.getOutput(il, path);
    }

    public static IInterfaceElement getInterfaceElement(InterfaceList il, List<String> path, boolean demandCreate) {
        if (path.isEmpty()) {
            return null;
        }
        IInterfaceElement ie = InterfaceListAnnotations.getRootIInterfaceElement(il, path.get(0));
        if (path.size() == 1) {
            return ie;
        }
        return InterfaceListAnnotations.handleMemberAccess(ie, path, demandCreate);
    }

    /*
     * WARNING - void declaration
     */
    private static IInterfaceElement handleMemberAccess(IInterfaceElement ie, List<String> path, boolean demandCreate) {
        void contVarDecl;
        if (!(ie instanceof ContainerVarDeclaration)) {
            return null;
        }
        ContainerVarDeclaration containerVarDeclaration = (ContainerVarDeclaration)ie;
        return contVarDecl.getCachedMember(path.subList(1, path.size()), demandCreate);
    }

    public static AdapterDeclaration getAdapter(InterfaceList il, String name) {
        for (AdapterDeclaration adapt : il.getPlugs()) {
            if (!adapt.getName().equals(name)) continue;
            return adapt;
        }
        for (AdapterDeclaration adapt : il.getSockets()) {
            if (!adapt.getName().equals(name)) continue;
            return adapt;
        }
        return null;
    }

    private static Stream<IInterfaceElement> getRootInputs(InterfaceList il) {
        return Stream.concat(Stream.of(il.getEventInputs(), il.getInputVars(), il.getInOutVars(), il.getSockets()).flatMap(Collection::stream), il.getErrorMarker().stream().filter(IInterfaceElement::isIsInput));
    }

    private static Stream<IInterfaceElement> getRootOutputs(InterfaceList il) {
        return Stream.concat(Stream.of(il.getEventOutputs(), il.getOutputVars(), il.getOutMappedInOutVars(), il.getPlugs()).flatMap(Collection::stream), il.getErrorMarker().stream().filter(Predicate.not(IInterfaceElement::isIsInput)));
    }

    private static Stream<IInterfaceElement> getRootInterfaceElements(InterfaceList il) {
        return Stream.concat(InterfaceListAnnotations.getRootInputs(il), InterfaceListAnnotations.getRootOutputs(il));
    }

    private static IInterfaceElement getRootInput(InterfaceList il, String name) {
        return InterfaceListAnnotations.getRootInputs(il).filter(ie -> ie.getName().equals(name)).findAny().orElse(null);
    }

    private static IInterfaceElement getRootOutput(InterfaceList il, String name) {
        return InterfaceListAnnotations.getRootOutputs(il).filter(ie -> ie.getName().equals(name)).findAny().orElse(null);
    }

    private static IInterfaceElement getRootIInterfaceElement(InterfaceList il, String name) {
        return InterfaceListAnnotations.getRootInterfaceElements(il).filter(ie -> ie.getName().equals(name)).findFirst().orElse(null);
    }

    private InterfaceListAnnotations() {
        throw new UnsupportedOperationException("Helper class should not be instantiated!");
    }
}

