/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.NamedElementAnnotations;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public final class InterfaceElementAnnotations {
    private static final String NAMED_ELEMENTS_KEY = InterfaceElementAnnotations.class.getName() + ".NAMED_ELEMENTS";

    public static List<String> getBlockRelativePath(IInterfaceElement element) {
        List<String> list;
        EObject eObject = element.eContainer();
        if (eObject instanceof IInterfaceElement) {
            IInterfaceElement parent = (IInterfaceElement)eObject;
            list = parent.getBlockRelativePath();
        } else {
            list = new ArrayList<String>();
        }
        ArrayList<String> path = list;
        path.add(element.getName());
        return path;
    }

    public static String getFullTypeName(IInterfaceElement element) {
        return ImportHelper.deresolveImport(element.getType(), element);
    }

    public static String getFullTypeName(VarDeclaration element) {
        String typeName = ImportHelper.deresolveImport(element.getType(), element);
        if (element.isArray() && typeName != null && !typeName.isBlank()) {
            String arraySize = ArraySizeHelper.getArraySize(element);
            if (!arraySize.contains("..")) {
                try {
                    return "ARRAY [0.." + (Integer.parseInt(arraySize) - 1) + "] OF " + typeName;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return "ARRAY [" + arraySize + "] OF " + typeName;
        }
        return typeName;
    }

    public static boolean isInOutVar(VarDeclaration varDecl) {
        return LibraryElementPackage.eINSTANCE.getInterfaceList_InOutVars().equals(varDecl.eContainingFeature()) || LibraryElementPackage.eINSTANCE.getInterfaceList_OutMappedInOutVars().equals(varDecl.eContainingFeature());
    }

    public static BlockFBNetworkElement getBlockFBNetworkElement(IInterfaceElement element) {
        EObject eObject = element.eContainer();
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockFBNetworkElement.class, InterfaceList.class, IInterfaceElement.class}, (Object)eObject, 0)) {
            case 0 -> {
                BlockFBNetworkElement blockFbNetworkElement;
                yield blockFbNetworkElement = (BlockFBNetworkElement)eObject;
            }
            case 1 -> {
                InterfaceList interfaceList = (InterfaceList)eObject;
                yield interfaceList.getBlockFBNetworkElement();
            }
            case 2 -> {
                IInterfaceElement varDecl = (IInterfaceElement)eObject;
                yield varDecl.getBlockFBNetworkElement();
            }
            default -> null;
        };
    }

    public static FBType getFBType(IInterfaceElement element) {
        EObject eObject = element.eContainer();
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FBType.class, InterfaceList.class, IInterfaceElement.class}, (Object)eObject, 0)) {
            case 0 -> {
                FBType fbType;
                yield fbType = (FBType)eObject;
            }
            case 1 -> {
                InterfaceList interfaceList = (InterfaceList)eObject;
                yield interfaceList.getFBType();
            }
            case 2 -> {
                IInterfaceElement varDecl = (IInterfaceElement)eObject;
                yield varDecl.getFBType();
            }
            default -> null;
        };
    }

    public static InterfaceList getInterfaceList(IInterfaceElement element) {
        EObject eObject = element.eContainer();
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InterfaceList.class, IInterfaceElement.class}, (Object)eObject, 0)) {
            case 0 -> {
                InterfaceList interfaceList;
                yield interfaceList = (InterfaceList)eObject;
            }
            case 1 -> {
                IInterfaceElement parent = (IInterfaceElement)eObject;
                yield parent.getInterfaceList();
            }
            default -> null;
        };
    }

    public static boolean validateName(IInterfaceElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (InterfaceElementAnnotations.isErrorMarker(element) || InterfaceElementAnnotations.isInTypedInstance(element)) {
            return true;
        }
        if (!NamedElementAnnotations.validateName(element, diagnostics, context)) {
            return false;
        }
        if (!InterfaceElementAnnotations.isOutMappedInOutVar(element) && !NamedElementAnnotations.validateDuplicateName(element, diagnostics, context, NAMED_ELEMENTS_KEY)) {
            return false;
        }
        if (!"DT".equals(element.getName()) && InterfaceElementAnnotations.existsDataType(InterfaceElementAnnotations.getDataTypeLibrary(element), element.getName())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 25, MessageFormat.format(Messages.InterfaceElementAnnotations_MemberNameCollidesWithDataType, element.getQualifiedName()), FordiacMarkerHelper.getDiagnosticData((EObject)element, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, element.getQualifiedName())));
            }
            return false;
        }
        return true;
    }

    static boolean isErrorMarker(IInterfaceElement element) {
        return element instanceof ErrorMarkerInterface;
    }

    static boolean isInTypedInstance(IInterfaceElement element) {
        BlockFBNetworkElement fbNetworkElement = element.getBlockFBNetworkElement();
        return fbNetworkElement != null && fbNetworkElement.getTypeEntry() != null;
    }

    static boolean isOutMappedInOutVar(IInterfaceElement element) {
        VarDeclaration varDeclaration;
        return element instanceof VarDeclaration && (varDeclaration = (VarDeclaration)element).isInOutVar() && !varDeclaration.isIsInput();
    }

    static boolean existsDataType(DataTypeLibrary dataTypeLibrary, String name) {
        return dataTypeLibrary != null && dataTypeLibrary.getTypeIfExists(name) != null;
    }

    static DataTypeLibrary getDataTypeLibrary(IInterfaceElement element) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext(element);
        if (typeLibrary != null) {
            return typeLibrary.getDataTypeLibrary();
        }
        return null;
    }

    static IInterfaceElement findInTypeInterface(IInterfaceElement element) {
        BlockFBNetworkElement blockFbnEl = element.getBlockFBNetworkElement();
        if (blockFbnEl == null) {
            return null;
        }
        InterfaceList typeInterface = blockFbnEl.getTypeInterface();
        if (typeInterface == null) {
            return null;
        }
        return typeInterface.getInterfaceElement(element);
    }

    private InterfaceElementAnnotations() {
        throw new UnsupportedOperationException();
    }
}

