/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class ModelEditChange
extends AbstractCommandChange<LibraryElement> {
    private final List<ModelEdit<?>> edits;

    private ModelEditChange(List<ModelEdit<?>> edits) {
        super(edits.getFirst().getLibraryElementURI(), LibraryElement.class);
        this.edits = edits;
        this.setEnabledShallow(edits.stream().anyMatch(Change::isEnabled));
    }

    @Override
    public void initializeValidationData(LibraryElement element, IProgressMonitor pm) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)this.edits.size());
        for (ModelEdit<?> edit : this.edits) {
            if (!edit.isEnabled()) continue;
            edit.initializeValidationDataElement(element, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    @Override
    public RefactoringStatus isValid(LibraryElement element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)this.edits.size());
        for (ModelEdit<?> edit : this.edits) {
            if (!edit.isEnabled()) continue;
            result.merge(edit.isValidElement(element, (IProgressMonitor)subMonitor.split(1)));
        }
        return result;
    }

    @Override
    protected Command createCommand(LibraryElement element) throws CoreException {
        CompoundCommand result = new CompoundCommand(this.getName());
        for (ModelEdit<?> edit : this.edits) {
            if (!edit.isEnabled()) continue;
            result.add(edit.createCommandElement(element));
        }
        return result;
    }

    public List<ModelEdit<?>> getModelEdits() {
        return Collections.unmodifiableList(this.edits);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (ModelEdit<?> edit : this.edits) {
            edit.setEnabled(enabled);
        }
    }

    public Change[] getChildren() {
        return (Change[])this.edits.toArray(Change[]::new);
    }

    public static CompositeChange fromModelEdits(String name, List<? extends ModelEdit<?>> edits) {
        if (edits.isEmpty()) {
            return null;
        }
        Map<URI, List<ModelEdit>> groupedEdits = edits.stream().collect(Collectors.groupingBy(ModelEdit::getLibraryElementURI));
        Change[] changes = (Change[])groupedEdits.values().stream().map(ModelEditChange::new).toArray(Change[]::new);
        return new CompositeChange(name, changes);
    }
}

