/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DataTypeModelEdit
extends ModelEdit<IInterfaceElement> {
    private final String newTypeDeclaration;
    private String oldTypeDeclaration;

    public DataTypeModelEdit(String name, URI elementURI, String newTypeDeclaration) {
        super(name, elementURI, IInterfaceElement.class);
        this.newTypeDeclaration = newTypeDeclaration;
    }

    @Override
    protected Command createCommand(IInterfaceElement element) {
        return ChangeDataTypeCommand.forTypeDeclaration((IInterfaceElement)element, (String)this.newTypeDeclaration);
    }

    @Override
    public void initializeValidationData(IInterfaceElement element, IProgressMonitor pm) {
        this.oldTypeDeclaration = element.getFullTypeName();
    }

    @Override
    public RefactoringStatus isValid(IInterfaceElement element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (!Objects.equals(element.getFullTypeName(), this.oldTypeDeclaration)) {
            status.addFatalError(Messages.DataTypeChange_TypeDeclarationChanged);
        }
        return status;
    }
}

