/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer;

import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class LibraryFolderDecorator
implements ILightweightLabelDecorator {
    private static final String VERSION_FORMAT = " [{0}]";

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        IFolder folder;
        if (element instanceof IFolder && LibraryFolderDecorator.isLinkedLibraryFolder(folder = (IFolder)element)) {
            Manifest manifest = ManifestHelper.getContainerManifest((IContainer)folder);
            if (manifest == null) {
                return;
            }
            String version = manifest.getProduct().getVersionInfo().getVersion();
            decoration.addSuffix(MessageFormat.format(VERSION_FORMAT, version));
        }
    }

    private static boolean isLinkedLibraryFolder(IFolder folder) {
        if (folder.getParent() != null) {
            String parentName = folder.getParent().getName();
            return parentName.equals("External Libraries") || parentName.equals("Standard Libraries");
        }
        return false;
    }
}

